/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.client.EditPanel;
import org.netbeans.modules.web.monitor.client.ParamEditor;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.Param;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class EditPanelCookies
extends DataDisplay {
    private static final boolean debug = false;
    private DisplayTable cookieTable = null;
    private MonitorData monitorData = null;
    private boolean setCookies = false;
    JButton newCookieB;
    JButton editCookieB;
    JButton deleteCookieB;

    EditPanelCookies() {
    }

    void redisplayData() {
        this.setData(this.monitorData);
        this.revalidate();
        this.repaint();
    }

    void setData(MonitorData monitorData) {
        this.monitorData = monitorData;
        this.setCookieTable();
        this.removeAll();
        String string = NbBundle.getBundle((Class)EditPanelCookies.class).getString("MON_Cookies_4");
        int n = -1;
        int n2 = 0;
        this.addGridBagComponent(this, EditPanelCookies.createTopSpacer(), 0, ++n, n2, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        this.addGridBagComponent(this, EditPanelCookies.createSortButtonLabel(string, this.cookieTable, NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_CookiesA11yDesc")), 0, ++n, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.cookieTable);
        this.addGridBagComponent(this, jScrollPane, 0, ++n, n2, 1, 1.0, 1.0, 17, 1, tableInsets, 0, 0);
        this.newCookieB = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.newCookieB, (String)NbBundle.getBundle((Class)EditPanel.class).getString("MON_New_cookie"));
        this.newCookieB.setToolTipText(NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_New_cookieA11yDesc"));
        this.newCookieB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParamEditor paramEditor = new ParamEditor("", "", ParamEditor.Editable.BOTH, ParamEditor.Condition.COOKIE, EditPanelCookies.this.newCookieB.getText());
                paramEditor.showDialog();
                if (paramEditor.getDialogOK()) {
                    String string = paramEditor.getName();
                    String string2 = paramEditor.getValue();
                    EditPanelCookies.this.monitorData.getRequestData().addCookie(string, string2);
                    EditPanelCookies.this.redisplayData();
                }
            }
        });
        this.deleteCookieB = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteCookieB, (String)NbBundle.getBundle((Class)EditPanel.class).getString("MON_Delete_cookie"));
        this.deleteCookieB.setToolTipText(NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_Delete_cookieA11yDesc"));
        this.deleteCookieB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = EditPanelCookies.this.cookieTable.getRowCount();
                StringBuffer stringBuffer = new StringBuffer(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanelCookies == null ? (class$org$netbeans$modules$web$monitor$client$EditPanelCookies = EditPanelCookies.class$("org.netbeans.modules.web.monitor.client.EditPanelCookies")) : class$org$netbeans$modules$web$monitor$client$EditPanelCookies)).getString("MON_Confirm_Delete_Cookies"));
                stringBuffer.append("\n");
                for (n = 0; n < n2; ++n) {
                    if (!EditPanelCookies.this.cookieTable.isRowSelected(n)) continue;
                    stringBuffer.append(EditPanelCookies.this.cookieTable.getValueAt(n, 0));
                    stringBuffer.append(" ");
                    stringBuffer.append(EditPanelCookies.this.cookieTable.getValueAt(n, 1));
                    stringBuffer.append("\n");
                }
                EditPanelCookies.this.showConfirmDialog(stringBuffer.toString());
                if (EditPanelCookies.this.setCookies) {
                    for (n = 0; n < n2; ++n) {
                        if (!EditPanelCookies.this.cookieTable.isRowSelected(n)) continue;
                        String string = (String)EditPanelCookies.this.cookieTable.getValueAt(n, 0);
                        String string2 = (String)EditPanelCookies.this.cookieTable.getValueAt(n, 1);
                        EditPanelCookies.this.monitorData.getRequestData().deleteCookie(string, string2);
                    }
                    EditPanelCookies.this.redisplayData();
                }
            }
        });
        int n3 = -1;
        this.addGridBagComponent(this, EditPanelCookies.createGlue(), ++n3, ++n, 1, 1, 1.0, 0.0, 17, 0, buttonInsets, 0, 0);
        this.addGridBagComponent(this, this.newCookieB, ++n3, n, 1, 1, 0.0, 0.0, 13, 0, buttonInsets, 0, 0);
        this.addGridBagComponent(this, this.deleteCookieB, ++n3, n, 1, 1, 0.0, 0.0, 13, 0, buttonInsets, 0, 0);
        this.setEnablings();
        this.setMaximumSize(this.getPreferredSize());
        this.repaint();
    }

    void showConfirmDialog(String string) {
        Object[] objectArray = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getBundle((Class)EditPanelCookies.class).getString("MON_Confirmation_Required"), 2, 3, objectArray, NotifyDescriptor.CANCEL_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
        this.setCookies = notifyDescriptor.getValue().equals(NotifyDescriptor.OK_OPTION);
    }

    void showErrorDialog() {
        Object[] objectArray = new Object[]{NotifyDescriptor.OK_OPTION};
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getBundle((Class)EditPanelCookies.class).getString("MON_Bad_cookie"), NbBundle.getBundle((Class)EditPanelCookies.class).getString("MON_Invalid_input"), -1, 0, objectArray, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    void setEnablings() {
        this.newCookieB.setEnabled(true);
        int[] nArray = this.cookieTable.getSelectedRows();
        this.deleteCookieB.setEnabled(nArray.length > 0);
    }

    void setCookieTable() {
        Param[] paramArray = this.monitorData.getRequestData().getCookiesAsParams();
        this.cookieTable = new DisplayTable(paramArray, 5, true);
        this.cookieTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_CookiesTableA11yName"));
        this.cookieTable.setToolTipText(NbBundle.getBundle((Class)EditPanelCookies.class).getString("ACS_MON_CookiesTableA11yDesc"));
        ListSelectionModel listSelectionModel = this.cookieTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditPanelCookies.this.setEnablings();
            }
        });
        this.cookieTable.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                EditPanelCookies.this.updateCookieHeader();
            }
        });
    }

    void updateCookieHeader() {
        int n = this.cookieTable.getRowCount();
        if (n == 0) {
            this.monitorData.getRequestData().setCookieHeader("");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(this.cookieTable.getValueAt(i, 0));
            stringBuffer.append("=");
            stringBuffer.append(this.cookieTable.getValueAt(i, 1));
        }
        this.monitorData.getRequestData().setCookieHeader(stringBuffer.toString());
    }

    public void repaint() {
        super.repaint();
    }

    void log(String string) {
        System.out.println("EditPanelCookies::" + string);
    }
}

