/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.monitor.client.Controller;
import org.netbeans.modules.web.monitor.client.EditPanelCookies;
import org.netbeans.modules.web.monitor.client.EditPanelHeaders;
import org.netbeans.modules.web.monitor.client.EditPanelQuery;
import org.netbeans.modules.web.monitor.client.EditPanelRequest;
import org.netbeans.modules.web.monitor.client.EditPanelServer;
import org.netbeans.modules.web.monitor.client.MonitorAction;
import org.netbeans.modules.web.monitor.client.TransactionNode;
import org.netbeans.modules.web.monitor.client.Util;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class EditPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private int displayType = 0;
    private static final int DISPLAY_TYPE_QUERY = 0;
    private static final int DISPLAY_TYPE_REQUEST = 1;
    private static final int DISPLAY_TYPE_COOKIES = 2;
    private static final int DISPLAY_TYPE_SERVER = 3;
    private static final int DISPLAY_TYPE_HEADERS = 4;
    private transient Dimension tabD = new Dimension(450, 280);
    private EditPanelQuery queryPanel;
    private EditPanelRequest requestPanel;
    private EditPanelCookies cookiesPanel;
    private EditPanelServer serverPanel;
    private EditPanelHeaders headersPanel;
    private MonitorData monitorData = null;
    private Dialog dialog = null;
    private DialogDescriptor editDialog = null;
    private JButton sendButton;
    private JButton okButton;
    private JButton cancelButton;
    static final String METHOD = "method";
    static final String GET = "GET";
    static final String POST = "POST";
    static final String PUT = "PUT";
    private static EditPanel instance = null;

    static void displayEditPanel(TransactionNode transactionNode) {
        MonitorData monitorData = null;
        monitorData = Controller.getInstance().getMonitorData(transactionNode, false, false);
        if (monitorData == null) {
            String string = NbBundle.getMessage((Class)EditPanel.class, (String)"MSG_NoMonitorData");
            Logger.getLogger("global").log(Level.INFO, string);
            return;
        }
        if (monitorData.getRequestData().getAttributeValue(METHOD).equals(POST)) {
            Util.removeParametersFromQuery(monitorData.getRequestData());
        }
        monitorData.getRequestData().deleteCookie("jsessionid");
        if (instance == null) {
            instance = new EditPanel();
        }
        instance.showDialog(monitorData);
    }

    static synchronized EditPanel getInstance() {
        if (instance == null) {
            instance = new EditPanel();
        }
        return instance;
    }

    private EditPanel() {
        this.createDialogButtons();
        this.setLayout(new BoxLayout(this, 1));
        this.queryPanel = new EditPanelQuery();
        this.requestPanel = new EditPanelRequest();
        this.cookiesPanel = new EditPanelCookies();
        this.serverPanel = new EditPanelServer();
        this.headersPanel = new EditPanelHeaders();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EditPanel.class, (String)"ACS_MON_Replay_panel"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_Replay_tabsName"));
        jTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_Replay_tabsDesc"));
        jTabbedPane.setPreferredSize(this.tabD);
        jTabbedPane.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Query_Panel_Tab"), this.queryPanel);
        jTabbedPane.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Request_Panel_Tab"), this.requestPanel);
        jTabbedPane.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Cookies_Panel_Tab"), this.cookiesPanel);
        jTabbedPane.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Server_Panel_Tab"), this.serverPanel);
        jTabbedPane.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Headers_Panel_Tab"), this.headersPanel);
        jTabbedPane.addChangeListener(this);
        this.add(jTabbedPane);
        this.add(Box.createGlue());
        this.add(Box.createVerticalStrut(5));
        this.setMaximumSize(this.getPreferredSize());
    }

    void showDialog(MonitorData monitorData) {
        this.monitorData = monitorData;
        this.queryPanel.setData(this.monitorData);
        this.requestPanel.setData(this.monitorData);
        this.cookiesPanel.setData(this.monitorData);
        this.serverPanel.setData(this.monitorData);
        this.headersPanel.setData(this.monitorData);
        Object[] objectArray = new Object[]{this.sendButton, this.cancelButton};
        this.editDialog = new DialogDescriptor((Object)this, NbBundle.getBundle((Class)EditPanel.class).getString("MON_EditReplay_panel"), false, objectArray, objectArray[0], 0, new HelpCtx("monitor_resend"), (ActionListener)this);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.editDialog);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = new String();
        Object object = this.editDialog.getValue();
        if (object == null) {
            return;
        }
        string = object instanceof JButton ? ((JButton)object).getText() : object.toString();
        if (string.equals(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_SendA11yDesc"))) {
            String string2 = this.monitorData.getRequestData().getAttributeValue(METHOD);
            if (string2.equals(GET)) {
                Util.composeQueryString(this.monitorData.getRequestData());
            }
            try {
                MonitorAction.getController().replayTransaction(this.monitorData);
                this.dialog.dispose();
            }
            catch (UnknownHostException unknownHostException) {
                Object[] objectArray = new Object[]{this.okButton};
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage((Class)EditPanel.class, (String)"MON_Exec_server_wrong", (Object)this.monitorData.getServerName()), NbBundle.getBundle((Class)EditPanel.class).getString("MON_Exec_server"), -1, 1, objectArray, objectArray[0]);
                DialogDisplayer.getDefault().notify(notifyDescriptor);
                this.displayType = 3;
                this.showData();
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{NbBundle.getBundle((Class)EditPanel.class).getString("MON_OK")};
                Object[] objectArray2 = new Object[]{this.monitorData.getServerName(), this.monitorData.getServerPortAsString()};
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage((Class)EditPanel.class, (String)"MON_Exec_server_start", (Object[])objectArray2), NbBundle.getBundle((Class)EditPanel.class).getString("MON_Exec_server"), -1, 1, objectArray, objectArray[0]);
                DialogDisplayer.getDefault().notify(notifyDescriptor);
            }
        } else if (string.equals(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_CancelA11yDesc"))) {
            this.dialog.dispose();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        this.displayType = jTabbedPane.getSelectedIndex();
        this.showData();
    }

    void showData() {
        if (this.displayType == 0) {
            this.queryPanel.setData(this.monitorData);
        } else if (this.displayType == 1) {
            this.requestPanel.setData(this.monitorData);
        } else if (this.displayType == 2) {
            this.cookiesPanel.setData(this.monitorData);
        } else if (this.displayType == 3) {
            this.serverPanel.setData(this.monitorData);
        } else if (this.displayType == 4) {
            this.headersPanel.setData(this.monitorData);
        }
    }

    private void createDialogButtons() {
        this.sendButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.sendButton, (String)NbBundle.getBundle((Class)EditPanel.class).getString("MON_Send"));
        this.sendButton.setToolTipText(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_SendA11yDesc"));
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getBundle((Class)EditPanel.class).getString("MON_OK"));
        this.okButton.setToolTipText(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_OKA11yDesc"));
        this.cancelButton = new JButton(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Cancel"));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getBundle((Class)EditPanel.class).getString("MON_Cancel"));
        this.cancelButton.setToolTipText(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_CancelA11yDesc"));
    }
}

