/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.data.ClientData;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.EngineData;
import org.netbeans.modules.web.monitor.data.ServletData;
import org.openide.util.NbBundle;

public class ClientDisplay
extends DataDisplay {
    private static final boolean debug = false;
    private DisplayTable clientTable = null;
    private DisplayTable engineTable = null;
    private String[] categories = new String[]{NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Protocol"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Remote_Address"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Software"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Locale"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Encodings"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Fileformats"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Charsets")};
    private static final String[] props = new String[]{NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Java_version"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Platform"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Server_name"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Server_port")};

    private void createPanelWidgets() {
        int n = -1;
        this.addGridBagComponent(this, ClientDisplay.createTopSpacer(), 0, ++n, 0, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        this.clientTable = new DisplayTable(this.categories);
        this.clientTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_ClientTable_3A11yName"));
        this.clientTable.setToolTipText(NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_ClientTable_3A11yDesc"));
        this.addGridBagComponent(this, ClientDisplay.createHeaderLabel(NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Client_3"), NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_Client_3A11yDesc"), this.clientTable), 0, ++n, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        this.addGridBagComponent(this, this.clientTable, 0, ++n, 0, 1, 1.0, 0.0, 17, 1, tableInsets, 0, 0);
        this.engineTable = new DisplayTable(props);
        this.engineTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_Servlet_engineTableA11yName"));
        this.engineTable.setToolTipText(NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_Servlet_engineTableA11yDesc"));
        this.addGridBagComponent(this, ClientDisplay.createHeaderLabel(NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Servlet_engine"), NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_Servlet_engineA11yDesc"), this.engineTable), 0, ++n, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        this.addGridBagComponent(this, this.engineTable, 0, ++n, 0, 1, 1.0, 0.0, 17, 1, tableInsets, 0, 0);
        this.addGridBagComponent(this, ClientDisplay.createGlue(), 0, ++n, 1, 1, 1.0, 1.0, 17, 1, zeroInsets, 0, 0);
    }

    public void setData(DataRecord dataRecord) {
        this.removeAll();
        if (dataRecord == null) {
            return;
        }
        this.createPanelWidgets();
        ClientData clientData = dataRecord.getClientData();
        this.clientTable.setValueAt(clientData.getAttributeValue("protocol"), 0, 1);
        this.clientTable.setValueAt(clientData.getAttributeValue("remoteAddress"), 1, 1);
        this.clientTable.setValueAt(clientData.getAttributeValue("software"), 2, 1);
        this.clientTable.setValueAt(clientData.getAttributeValue("locale"), 3, 1);
        this.clientTable.setValueAt(clientData.getAttributeValue("encodingsAccepted"), 4, 1);
        this.clientTable.setValueAt(clientData.getAttributeValue("formatsAccepted"), 5, 1);
        this.clientTable.setValueAt(clientData.getAttributeValue("charsetsAccepted"), 6, 1);
        EngineData engineData = dataRecord.getEngineData();
        if (engineData != null) {
            this.engineTable.setValueAt(engineData.getAttributeValue("jre"), 0, 1);
            this.engineTable.setValueAt(engineData.getAttributeValue("platform"), 1, 1);
            this.engineTable.setValueAt(engineData.getAttributeValue("serverName"), 2, 1);
            this.engineTable.setValueAt(engineData.getAttributeValue("serverPort"), 3, 1);
        } else {
            ServletData servletData = dataRecord.getServletData();
            this.engineTable.setValueAt(servletData.getAttributeValue("jre"), 0, 1);
            this.engineTable.setValueAt(servletData.getAttributeValue("platform"), 1, 1);
            this.engineTable.setValueAt(servletData.getAttributeValue("serverName"), 2, 1);
            this.engineTable.setValueAt(servletData.getAttributeValue("serverPort"), 3, 1);
        }
    }
}

