/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.railsprojects.GenerateAction;
import org.netbeans.modules.ruby.railsprojects.MigrateAction;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginAction;
import org.netbeans.modules.ruby.railsprojects.ui.TreeRootNode;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.IrbAction;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.TestActionConfiguration;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunnerAction;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.rubyproject.ui.RubyBaseLogicalViewProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectEvent;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectListener;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public final class RailsLogicalViewProvider
extends RubyBaseLogicalViewProvider {
    public RailsLogicalViewProvider(RailsProject railsProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        super((RubyBaseProject)railsProject, updateHelper, propertyEvaluator, referenceHelper);
    }

    public Node createLogicalView() {
        return new RailsLogicalViewRootNode();
    }

    protected Node findWithPathFinder(Node node, FileObject fileObject) {
        Node node2;
        TreeRootNode.PathFinder pathFinder = (TreeRootNode.PathFinder)node.getLookup().lookup(TreeRootNode.PathFinder.class);
        if (pathFinder != null && (node2 = pathFinder.findPath(node, fileObject)) != null) {
            return node2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RailsLogicalViewRootNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private Set<FileObject> files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;
        private final RSpecSupport rspecSupport;

        public RailsLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)RailsLogicalViewProvider.this.getProject(), (String)"Projects/org-netbeans-modules-ruby-railsprojects/Nodes"), Lookups.singleton((Object)RailsLogicalViewProvider.this.getProject()));
            this.privateLock = new Object();
            this.setIconBaseWithExtension("org/netbeans/modules/ruby/railsprojects/ui/resources/rails.png");
            super.setName(ProjectUtils.getInformation((Project)RailsLogicalViewProvider.this.getProject()).getDisplayName());
            this.setProjectFiles((Project)RailsLogicalViewProvider.this.getProject());
            RailsLogicalViewProvider.this.getUpdateHelper().getRakeProjectHelper().addRakeProjectListener(new RakeProjectListener(){

                public void configurationXmlChanged(RakeProjectEvent rakeProjectEvent) {
                    RailsLogicalViewRootNode.this.fireShortDescriptionChange();
                }

                public void propertiesChanged(RakeProjectEvent rakeProjectEvent) {
                    RailsLogicalViewRootNode.this.fireShortDescriptionChange();
                }
            });
            this.rspecSupport = new RSpecSupport((Project)RailsLogicalViewProvider.this.getProject());
        }

        private void fireShortDescriptionChange() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RailsLogicalViewRootNode.this.fireShortDescriptionChange(null, null);
                }
            });
        }

        public String getShortDescription() {
            String string = RubyPlatform.platformDescriptionFor((Project)RailsLogicalViewProvider.this.getProject());
            if (string == null) {
                string = NbBundle.getMessage(RailsLogicalViewProvider.class, (String)"RailsLogicalViewProvider.PlatformNotFound");
            }
            String string2 = FileUtil.getFileDisplayName((FileObject)RailsLogicalViewProvider.this.getProject().getProjectDirectory());
            return NbBundle.getMessage(RailsLogicalViewProvider.class, (String)"RailsLogicalViewProvider.ProjectTooltipDescription", (Object)string2, (Object)string);
        }

        protected final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private final void setGroups(Collection<SourceGroup> collection) {
            Object object2;
            if (this.groupsListeners != null) {
                for (Object object2 : this.groupsListeners.keySet()) {
                    PropertyChangeListener propertyChangeListener = this.groupsListeners.get(object2);
                    object2.removePropertyChangeListener(propertyChangeListener);
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet hashSet = new HashSet();
            object2 = collection.iterator();
            for (SourceGroup sourceGroup : collection) {
                PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup);
                this.groupsListeners.put(sourceGroup, propertyChangeListener);
                sourceGroup.addPropertyChangeListener(propertyChangeListener);
                FileObject fileObject = sourceGroup.getRootFolder();
                hashSet.add(fileObject);
            }
            this.setFiles(hashSet);
        }

        protected final void setFiles(Set<FileObject> set) {
            FileStatusListener fileStatusListener;
            if (this.fileSystemListeners != null) {
                for (FileSystem object2 : this.fileSystemListeners.keySet()) {
                    fileStatusListener = this.fileSystemListeners.get(object2);
                    object2.removeFileStatusListener(fileStatusListener);
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = set;
            if (set == null) {
                return;
            }
            Iterator<FileSystem> iterator = set.iterator();
            HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
            while (iterator.hasNext()) {
                ErrorManager errorManager;
                fileStatusListener = (FileObject)iterator.next();
                try {
                    FileSystem fileStateInvalidException = fileStatusListener.getFileSystem();
                    if (hashSet.contains(fileStateInvalidException)) continue;
                    hashSet.add(fileStateInvalidException);
                    errorManager = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileStateInvalidException);
                    fileStateInvalidException.addFileStatusListener((FileStatusListener)errorManager);
                    this.fileSystemListeners.put(fileStateInvalidException, (FileStatusListener)errorManager);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)fileStateInvalidException, 0, "Cannot get " + fileStatusListener + " filesystem, ignoring...", null, null, null);
                    errorManager.notify(1, (Throwable)fileStateInvalidException);
                }
            }
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = this.getMyOpenedIcon(n);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return image;
        }

        private Image getMyOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl;
            boolean bl2;
            Object object = this.privateLock;
            synchronized (object) {
                bl2 = this.iconChange;
                bl = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (bl2) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (bl) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                    for (FileObject fileObject : this.files) {
                        if (!fileStatusEvent.hasChanged(fileObject)) continue;
                        this.iconChange |= fileStatusEvent.isIconChange();
                        this.nameChange |= fileStatusEvent.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setProjectFiles((Project)RailsLogicalViewProvider.this.getProject());
            this.fireShortDescriptionChange();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setProjectFiles((Project)RailsLogicalViewProvider.this.getProject());
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)RailsLogicalViewProvider.this.getProject(), (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(RailsLogicalViewRootNode.class);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(RailsLogicalViewProvider.class);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(SystemAction.get(GenerateAction.class));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(SystemAction.get(RakeRunnerAction.class));
            arrayList.add(SystemAction.get(IrbAction.class));
            arrayList.add(SystemAction.get(MigrateAction.class));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rails-console", (String)resourceBundle.getString("LBL_ConsoleAction_Name"), null));
            arrayList.add(SystemAction.get(PluginAction.class));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            if (AutoTestSupport.isInstalled((Project)RailsLogicalViewProvider.this.getProject(), (TestRunner.TestType)TestRunner.TestType.AUTOTEST) && TestActionConfiguration.enable((String)"autotest", (Project)RailsLogicalViewProvider.this.getProject())) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"autotest", (String)resourceBundle.getString("LBL_AutoTest"), null));
            }
            if (AutoTestSupport.isInstalled((Project)RailsLogicalViewProvider.this.getProject(), (TestRunner.TestType)TestRunner.TestType.AUTOSPEC) && TestActionConfiguration.enable((String)"autospec", (Project)RailsLogicalViewProvider.this.getProject())) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"autospec", (String)resourceBundle.getString("LBL_AutoSpec"), null));
            }
            if (this.rspecSupport.isRSpecInstalled() && TestActionConfiguration.enable((String)"rspec", (Project)RailsLogicalViewProvider.this.getProject())) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rspec", (String)resourceBundle.getString("LBL_RSpec"), null));
            }
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
            if (TestActionConfiguration.enable((String)"test", (Project)RailsLogicalViewProvider.this.getProject())) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)resourceBundle.getString("LBL_TestAction_Name"), null));
            }
            arrayList.add(RubyCoverageProvider.createCoverageAction((Project)RailsLogicalViewProvider.this.getProject()));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setProjectConfigurationAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add(SystemAction.get(FindAction.class));
            arrayList.add(null);
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public String toString() {
            return super.toString() + "[project=" + RailsLogicalViewProvider.this.getProject() + "]";
        }
    }
}

