/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PluginProgressPanel
extends JPanel {
    private InputHandler inputHandler;
    private JPanel detailsPanel;
    private JScrollPane detailsScrollPane;
    private JLabel messageLabel;
    private JTextArea outputArea;
    private JCheckBox outputToggle;
    private JProgressBar progressBar;
    private OutputStream processInput;

    public PluginProgressPanel(String string) {
        this.initComponents();
        this.messageLabel.setText(string);
        this.inputHandler = new InputHandler();
        this.inputHandler.attach(this.outputArea);
    }

    public void appendOutput(final String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PluginProgressPanel.this.appendOutput(string);
                }
            });
            return;
        }
        this.outputArea.setEditable(true);
        Document document = this.outputArea.getDocument();
        if (document != null) {
            try {
                document.insertString(document.getLength(), string + "\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void done(String string) {
        this.messageLabel.setText(string);
        this.progressBar.setIndeterminate(false);
        this.progressBar.getModel().setValue(this.progressBar.getModel().getMaximum());
        this.outputArea.setEditable(false);
        this.inputHandler.detach();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        JSeparator jSeparator = new JSeparator();
        this.outputToggle = new JCheckBox();
        this.progressBar = new JProgressBar();
        this.detailsPanel = new JPanel();
        this.detailsScrollPane = new JScrollPane();
        this.outputArea = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(PluginProgressPanel.class, (String)"PluginProgressPanel.messageLabel.text"));
        this.outputToggle.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.outputToggle, (String)NbBundle.getMessage(PluginProgressPanel.class, (String)"PluginProgressPanel.outputToggle.text"));
        this.outputToggle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.outputToggle.setEnabled(false);
        this.outputToggle.setMargin(new Insets(0, 0, 0, 0));
        this.outputToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginProgressPanel.this.outputToggleActionPerformed(actionEvent);
            }
        });
        this.progressBar.setIndeterminate(true);
        this.detailsPanel.setLayout(new BorderLayout());
        this.outputArea.setColumns(20);
        this.outputArea.setEditable(false);
        this.outputArea.setLineWrap(true);
        this.outputArea.setRows(6);
        this.detailsScrollPane.setViewportView(this.outputArea);
        this.outputArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginProgressPanel.class, (String)"PluginProgressPanel.outputArea.AccessibleContext.accessibleName"));
        this.outputArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginProgressPanel.class, (String)"PluginProgressPanel.outputArea.AccessibleContext.accessibleDescription"));
        this.detailsPanel.add((Component)this.detailsScrollPane, "Center");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.messageLabel).addContainerGap(416, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.progressBar, -1, 427, Short.MAX_VALUE).add(22, 22, 22)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.outputToggle).addContainerGap(291, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.detailsPanel, -1, 437, Short.MAX_VALUE).add((Component)jSeparator, -1, 437, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.messageLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0).add((Component)jSeparator, -2, 10, -2).addPreferredGap(0).add((Component)this.outputToggle).addPreferredGap(0).add((Component)this.detailsPanel, -1, 231, Short.MAX_VALUE).addContainerGap()));
    }

    private void outputToggleActionPerformed(ActionEvent actionEvent) {
        if (this.outputToggle.isSelected()) {
            this.detailsPanel.add((Component)this.detailsScrollPane, "Center");
        } else {
            this.detailsPanel.remove(this.detailsScrollPane);
        }
        this.detailsPanel.invalidate();
        this.invalidate();
        this.revalidate();
        this.validate();
        this.repaint();
    }

    public void setProcessInput(OutputStream outputStream) {
        this.processInput = outputStream;
    }

    private class InputHandler
    implements KeyListener,
    DocumentListener {
        private JTextComponent textComponent;
        private int startOffset;

        private InputHandler() {
        }

        private void detach() {
            this.textComponent.removeKeyListener(this);
            this.textComponent.getDocument().removeDocumentListener(this);
        }

        private void attach(JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
            jTextComponent.addKeyListener(this);
            jTextComponent.getDocument().addDocumentListener(this);
            if (jTextComponent.getDocument() instanceof AbstractDocument) {
                ((AbstractDocument)jTextComponent.getDocument()).setDocumentFilter(new DocumentFilter(){

                    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (n >= InputHandler.this.startOffset) {
                            super.insertString(filterBypass, n, string, attributeSet);
                        }
                    }

                    public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                        if (n >= InputHandler.this.startOffset) {
                            super.remove(filterBypass, n, n2);
                        }
                    }

                    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (n >= InputHandler.this.startOffset) {
                            super.replace(filterBypass, n, n2, string, attributeSet);
                        }
                    }
                });
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.append("\n");
            }
            keyEvent.consume();
            String string = "" + keyEvent.getKeyChar();
            try {
                PluginProgressPanel.this.processInput.write(string.getBytes());
                PluginProgressPanel.this.processInput.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.textComponent.setCaretPosition(this.textComponent.getDocument().getLength());
            this.startOffset = this.textComponent.getDocument().getLength();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void append(String string) {
            try {
                this.textComponent.getDocument().insertString(this.textComponent.getDocument().getLength(), string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

