/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.FilteredNode;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.UserCancelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceWizardPanel
extends JPanel {
    private final Map<DataObject, SourceData> sourceMap = Util.createWizardSourceMap();
    private final Panel descPanel;
    private boolean testRole = false;
    private JButton addButton;
    private JLabel lblSelectedSources;
    private JButton removeButton;
    private JList sourcesList;

    private SourceWizardPanel(Panel panel, boolean bl) {
        this.descPanel = panel;
        this.testRole = bl;
        this.initComponents();
        this.initAccessibility();
        this.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
        this.initList();
        this.putClientProperty("WizardPanel_contentSelectedIndex", 0);
        if (bl) {
            this.setName(Util.getString("TXT_SelecTestSources"));
        } else {
            this.setName(Util.getString("TXT_SelectSources"));
        }
    }

    public Map<DataObject, SourceData> getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map<DataObject, SourceData> map) {
        this.sourceMap.clear();
        this.sourceMap.putAll(map);
        this.sourcesList.setListData(map.keySet().toArray());
        this.descPanel.fireStateChanged();
    }

    private String getPanelDescription() {
        if (!this.testRole) {
            return Util.getString("MSG_SourcesPanel_desc");
        }
        return Util.getString("MSG_SourcesPanel_test_desc");
    }

    private String getAccessibleListDescription() {
        if (!this.testRole) {
            return Util.getString("ACSD_sourcesList");
        }
        return Util.getString("ACSD_sourcesList_test");
    }

    private void initList() {
        this.sourcesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SourceWizardPanel.this.removeButton.setEnabled(!SourceWizardPanel.this.sourcesList.isSelectionEmpty());
            }
        });
        this.removeButton.setEnabled(!this.sourcesList.isSelectionEmpty());
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.getPanelDescription());
        this.addButton.setToolTipText(Util.getString("CTL_AddSource_desc"));
        this.removeButton.setToolTipText(Util.getString("CTL_RemoveSource_desc"));
        this.sourcesList.getAccessibleContext().setAccessibleName(Util.getString("ACSN_sourcesList"));
        this.sourcesList.getAccessibleContext().setAccessibleDescription(this.getAccessibleListDescription());
    }

    private void initComponents() {
        this.sourcesList = new JList();
        this.sourcesList.setCellRenderer(new DataObjectListCellRenderer());
        this.addButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)Util.getString("CTL_AddSource"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceWizardPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.removeButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)Util.getString("CTL_RemoveSource"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceWizardPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        Util.layoutSelectResourcePanel(this, this.getPanelDescription(), Util.getString("LBL_SelectedSourcesToI18N"), this.sourcesList, this.addButton, this.removeButton);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.sourcesList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.sourceMap.remove(objectArray[i]);
        }
        this.sourcesList.setListData(this.sourceMap.keySet().toArray());
        this.descPanel.fireStateChanged();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Project project = this.descPanel.getProject();
        try {
            FilteredNode.NodeFilter nodeFilter = new FilteredNode.NodeFilter(){

                public boolean acceptNode(Node node) {
                    return !node.getName().startsWith(".");
                }
            };
            Node[] nodeArray = NodeOperation.getDefault().select(Util.getString("LBL_SelectSources"), Util.getString("LBL_Filesystems"), SelectorUtils.sourcesNode(project, nodeFilter), new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodeArray) {
                    if (nodeArray == null || nodeArray.length == 0) {
                        return false;
                    }
                    for (Node node : nodeArray) {
                        Node.Cookie cookie = node.getCookie(DataObject.class);
                        if (cookie == null) {
                            return false;
                        }
                        if (!(cookie instanceof DataFolder ? I18nUtil.containsAcceptedDataObject((DataFolder)cookie) : FactoryRegistry.hasFactory(cookie.getClass()))) continue;
                        return true;
                    }
                    return false;
                }
            });
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
                if (dataObject instanceof DataFolder) {
                    Iterator<DataObject> iterator = I18nUtil.getAcceptedDataObjects((DataObject.Container)((DataFolder)dataObject)).iterator();
                    while (iterator.hasNext()) {
                        Util.addSource(this.sourceMap, iterator.next());
                    }
                    continue;
                }
                Util.addSource(this.sourceMap, dataObject);
            }
            this.sourcesList.setListData(this.sourceMap.keySet().toArray());
            this.descPanel.fireStateChanged();
        }
        catch (UserCancelException userCancelException) {
            // empty catch block
        }
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel {
        private final boolean testWizard;

        public Panel() {
            this(false);
        }

        public Panel(boolean bl) {
            this.testWizard = bl;
        }

        protected Component createComponent() {
            SourceWizardPanel sourceWizardPanel = new SourceWizardPanel(this, this.testWizard);
            return sourceWizardPanel;
        }

        public boolean isValid() {
            return !((SourceWizardPanel)this.getComponent()).getSourceMap().isEmpty();
        }

        public void readSettings(I18nWizardDescriptor.Settings settings) {
            super.readSettings(settings);
            ((SourceWizardPanel)this.getComponent()).setSourceMap(this.getMap());
        }

        public void storeSettings(I18nWizardDescriptor.Settings settings) {
            super.storeSettings(settings);
            super.storeSettings(settings);
            this.getMap().clear();
            this.getMap().putAll(((SourceWizardPanel)this.getComponent()).getSourceMap());
        }

        public HelpCtx getHelp() {
            return new HelpCtx(this.testWizard ? "internation.testing" : "internation.wizard");
        }
    }

    public static class DataObjectListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            DataObject dataObject = (DataObject)object;
            if (dataObject != null) {
                ClassPath classPath = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                jLabel.setText(classPath.getResourceName(dataObject.getPrimaryFile(), '.', false));
                jLabel.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
            } else {
                jLabel.setText("");
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    }
}

