/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.netbeans.modules.i18n.regexp.ParseException;
import org.netbeans.modules.i18n.regexp.Translator;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaI18nFinder
implements I18nSupport.I18nFinder {
    protected static final int STATE_JAVA = 0;
    protected static final int STATE_JAVA_A_SLASH = 1;
    protected static final int STATE_LINECOMMENT = 2;
    protected static final int STATE_BLOCKCOMMENT = 3;
    protected static final int STATE_BLOCKCOMMENT_A_STAR = 4;
    protected static final int STATE_STRING = 5;
    protected static final int STATE_STRING_A_BSLASH = 6;
    protected static final int STATE_CHAR = 7;
    protected StyledDocument document;
    protected int state;
    protected boolean i18nSearch;
    protected Position lastPosition;
    protected StringBuffer lastJavaString;
    protected char[] buffer;
    protected int position;
    protected int currentStringStart;
    protected int currentStringEnd;

    public JavaI18nFinder(StyledDocument styledDocument) {
        this.document = styledDocument;
        this.init();
    }

    private void init() {
        this.state = 0;
        this.initJavaStringBuffer();
        this.lastPosition = null;
    }

    protected void reset() {
        this.init();
    }

    public HardCodedString[] findAllHardCodedStrings() {
        this.reset();
        this.i18nSearch = false;
        return this.findAllStrings();
    }

    public HardCodedString findNextHardCodedString() {
        this.i18nSearch = false;
        return this.findNextString();
    }

    public HardCodedString[] findAllI18nStrings() {
        this.reset();
        this.i18nSearch = true;
        return this.findAllStrings();
    }

    public HardCodedString findNextI18nString() {
        this.i18nSearch = true;
        return this.findNextString();
    }

    protected HardCodedString[] findAllStrings() {
        HardCodedString hardCodedString;
        ArrayList<HardCodedString> arrayList = new ArrayList<HardCodedString>();
        while ((hardCodedString = this.findNextString()) != null) {
            arrayList.add(hardCodedString);
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new HardCodedString[arrayList.size()]) : null;
    }

    protected HardCodedString findNextString() {
        try {
            this.buffer = this.document.getText(0, this.document.getLength()).toCharArray();
        }
        catch (BadLocationException badLocationException) {
            if (Boolean.getBoolean("netbeans.debug.exception")) {
                badLocationException.printStackTrace();
            }
            return null;
        }
        this.position = this.lastPosition == null ? 0 : this.lastPosition.getOffset();
        this.currentStringStart = -1;
        this.currentStringEnd = -1;
        while (this.position < this.buffer.length) {
            char c = this.buffer[this.position];
            if (c != '\n') {
                HardCodedString hardCodedString = this.handleCharacter(c);
                if (hardCodedString != null) {
                    return hardCodedString;
                }
            } else {
                this.handleNewLineCharacter();
            }
            ++this.position;
        }
        return null;
    }

    protected HardCodedString handleCharacter(char c) {
        if (this.state == 0) {
            return this.handleStateJava(c);
        }
        if (this.state == 1) {
            return this.handleStateJavaASlash(c);
        }
        if (this.state == 7) {
            return this.handleStateChar(c);
        }
        if (this.state == 6) {
            return this.handleStateStringABSlash(c);
        }
        if (this.state == 2) {
            return this.handleStateLineComment(c);
        }
        if (this.state == 3) {
            return this.handleStateBlockComment(c);
        }
        if (this.state == 4) {
            return this.handleStateBlockCommentAStar(c);
        }
        if (this.state == 5) {
            return this.handleStateString(c);
        }
        return null;
    }

    protected void handleNewLineCharacter() {
        if (this.state == 0 || this.state == 1 || this.state == 7 || this.state == 2 || this.state == 5 || this.state == 6) {
            this.initJavaStringBuffer();
            this.currentStringStart = -1;
            this.currentStringEnd = -1;
            this.state = 0;
        } else if (this.state == 3 || this.state == 4) {
            this.state = 3;
        }
    }

    protected HardCodedString handleStateJava(char c) {
        this.lastJavaString.append(c);
        if (c == '/') {
            this.state = 1;
        } else if (c == '\"') {
            this.state = 5;
            if (this.currentStringStart == -1) {
                this.currentStringStart = this.position;
            }
        } else if (c == '\'') {
            this.state = 7;
        }
        return null;
    }

    protected HardCodedString handleStateJavaASlash(char c) {
        this.lastJavaString.append(c);
        if (c == '/') {
            this.state = 2;
        } else if (c == '*') {
            this.state = 3;
        }
        return null;
    }

    protected HardCodedString handleStateChar(char c) {
        this.lastJavaString.append(c);
        if (c == '\'') {
            this.state = 0;
        }
        return null;
    }

    protected HardCodedString handleStateStringABSlash(char c) {
        this.state = 5;
        return null;
    }

    protected HardCodedString handleStateLineComment(char c) {
        return null;
    }

    protected HardCodedString handleStateBlockComment(char c) {
        if (c == '*') {
            this.state = 4;
        }
        return null;
    }

    protected HardCodedString handleStateBlockCommentAStar(char c) {
        if (c == '/') {
            this.state = 0;
            this.initJavaStringBuffer();
        } else if (c != '*') {
            this.state = 3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HardCodedString handleStateString(char c) {
        if (c == '\\') {
            this.state = 6;
        } else if (c == '\"') {
            this.state = 0;
            if (this.currentStringEnd == -1 && this.currentStringStart != -1) {
                this.currentStringEnd = this.position + 1;
                int n = this.currentStringEnd - this.currentStringStart;
                try {
                    Position position = this.document.createPosition(this.currentStringStart);
                    Position position2 = this.document.createPosition(this.currentStringEnd);
                    String string = this.document.getText(position.getOffset(), n);
                    String string2 = new String(this.buffer, this.currentStringEnd, this.buffer.length - this.currentStringEnd);
                    int n2 = string2.indexOf(10);
                    if (n2 == -1) {
                        n2 = string2.length();
                    }
                    this.lastJavaString.append(this.document.getText(this.currentStringStart + 1, string.length()));
                    String string3 = this.document.getText(this.currentStringStart + 1 + string.length(), this.currentStringEnd + n2 - this.currentStringStart - string.length());
                    this.lastJavaString.append(string3.replace('\"', '_'));
                    if (this.isSearchedString(this.lastJavaString.toString(), string)) {
                        this.lastPosition = position2;
                        HardCodedString hardCodedString = new HardCodedString(this.extractString(string), position, position2);
                        return hardCodedString;
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                }
                finally {
                    this.currentStringStart = -1;
                    this.currentStringEnd = -1;
                    this.initJavaStringBuffer();
                }
            }
        }
        return null;
    }

    private void initJavaStringBuffer() {
        this.lastJavaString = new StringBuffer();
    }

    private String extractString(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    protected boolean isSearchedString(String string, String string2) {
        Boolean bl;
        Object object;
        String string3 = UtilConvert.unicodesToChars((String)string);
        Exception exception = null;
        try {
            object = this.createRegularExpression(string2);
            bl = Pattern.compile((String)object).matcher(string3).find() == this.i18nSearch;
        }
        catch (ParseException parseException) {
            exception = parseException;
            bl = null;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            exception = patternSyntaxException;
            bl = null;
        }
        if (Boolean.FALSE.equals(bl)) {
            return false;
        }
        object = new AnnotationDetector(this.currentStringStart);
        try {
            boolean bl2 = true;
            do {
                if (!bl2) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                }
                ((AnnotationDetector)object).reset();
                JavaSource.forDocument((Document)this.document).runUserActionTask((Task)object, true);
                bl2 = false;
            } while (((AnnotationDetector)object).wasCancelled());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (((AnnotationDetector)object).wasAnnotationDetected()) {
            return false;
        }
        if (bl != null) {
            assert (bl.equals(Boolean.TRUE));
            return true;
        }
        ErrorManager.getDefault().notify(1, (Throwable)exception);
        String string4 = NbBundle.getMessage(JavaI18nSupport.class, (String)"MSG_RegExpCompileError", (Object)string2);
        Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string4, 0, 0));
        return NotifyDescriptor.YES_OPTION.equals(object2);
    }

    private String createRegularExpression(String string) throws ParseException {
        String string2 = this.i18nSearch ? I18nUtil.getOptions().getI18nRegularExpression() : I18nUtil.getOptions().getRegularExpression();
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("key", string);
        hashMap.put("hardString", string);
        return Translator.translateRegexp(string2, hashMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AnnotationDetector
    implements CancellableTask<CompilationController> {
        private final int caretPosition;
        private volatile boolean cancelled;
        private boolean annotationDetected = false;

        private AnnotationDetector(int n) {
            this.caretPosition = n;
        }

        void reset() {
            this.cancelled = false;
            this.annotationDetected = false;
        }

        public void run(CompilationController compilationController) throws IOException {
            if (this.cancelled) {
                return;
            }
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            if (this.cancelled) {
                return;
            }
            TreePath treePath = compilationController.getTreeUtilities().pathFor(this.caretPosition);
            if (treePath == null) {
                return;
            }
            Tree.Kind kind = treePath.getLeaf().getKind();
            if (kind == Tree.Kind.STRING_LITERAL) {
                if ((treePath = treePath.getParentPath()) == null) {
                    return;
                }
                kind = treePath.getLeaf().getKind();
            }
            if (kind == Tree.Kind.NEW_ARRAY) {
                if ((treePath = treePath.getParentPath()) == null) {
                    return;
                }
                kind = treePath.getLeaf().getKind();
            }
            if (kind == Tree.Kind.ASSIGNMENT) {
                if ((treePath = treePath.getParentPath()) == null) {
                    return;
                }
                kind = treePath.getLeaf().getKind();
            }
            this.annotationDetected = kind == Tree.Kind.ANNOTATION;
        }

        public void cancel() {
            this.cancelled = true;
        }

        boolean wasCancelled() {
            return this.cancelled;
        }

        boolean wasAnnotationDetected() {
            return this.annotationDetected;
        }
    }
}

