/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.awt.Mnemonics;

public abstract class InfoPanel
extends JPanel {
    private ResourceBundle bundle;
    private JLabel propertyLabel;
    private JLabel stringLabel;
    private JTextField stringText;
    private JTextField propertyText;
    private JLabel foundInLabel;
    private JLabel componentLabel;
    private JTextField componentText;
    private JTextField foundInText;

    public InfoPanel(HardCodedString hardCodedString, StyledDocument styledDocument) {
        if (this.bundle == null) {
            this.bundle = I18nUtil.getBundle();
        }
        this.initComponents();
        this.initAccessibility();
        this.setHardCodedString(hardCodedString, styledDocument);
    }

    protected abstract void setHardCodedString(HardCodedString var1, StyledDocument var2);

    protected JTextField getStringText() {
        return this.stringText;
    }

    protected JTextField getFoundInText() {
        return this.foundInText;
    }

    protected JTextField getComponentText() {
        return this.componentText;
    }

    protected JTextField getPropertyText() {
        return this.propertyText;
    }

    protected JLabel getComponentLabel() {
        return this.componentLabel;
    }

    protected JLabel getPropertyLabel() {
        return this.propertyLabel;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_InfoPanel"));
        this.stringText.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_stringText"));
        this.propertyText.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_propertyText"));
        this.componentText.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_componentText"));
        this.foundInText.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_foundInText"));
    }

    private void initComponents() {
        this.stringLabel = new JLabel();
        this.stringText = new JTextField();
        this.foundInLabel = new JLabel();
        this.foundInText = new JTextField();
        this.componentLabel = new JLabel();
        this.componentText = new JTextField();
        this.propertyLabel = new JLabel();
        this.propertyText = new JTextField();
        this.setLayout(new GridBagLayout());
        this.stringLabel.setLabelFor(this.stringText);
        Mnemonics.setLocalizedText((JLabel)this.stringLabel, (String)this.bundle.getString("CTL_StringLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.stringLabel, gridBagConstraints);
        this.stringText.setEditable(false);
        this.stringText.selectAll();
        this.stringText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoPanel.this.stringTextFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 11, 0, 11);
        this.add((Component)this.stringText, gridBagConstraints);
        this.foundInLabel.setLabelFor(this.foundInText);
        Mnemonics.setLocalizedText((JLabel)this.foundInLabel, (String)this.bundle.getString("CTL_FoundInLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.foundInLabel, gridBagConstraints);
        this.foundInText.setEditable(false);
        this.foundInText.selectAll();
        this.foundInText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoPanel.this.foundInTextFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.foundInText, gridBagConstraints);
        this.componentLabel.setLabelFor(this.componentText);
        Mnemonics.setLocalizedText((JLabel)this.componentLabel, (String)this.bundle.getString("CTL_ComponentLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.componentLabel, gridBagConstraints);
        this.componentText.setEditable(false);
        this.componentText.selectAll();
        this.componentText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoPanel.this.componentTextFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.componentText, gridBagConstraints);
        this.propertyLabel.setLabelFor(this.propertyText);
        Mnemonics.setLocalizedText((JLabel)this.propertyLabel, (String)this.bundle.getString("CTL_PropertyLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 11, 0);
        this.add((Component)this.propertyLabel, gridBagConstraints);
        this.propertyText.setEditable(false);
        this.propertyText.selectAll();
        this.propertyText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoPanel.this.propertyTextFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add((Component)this.propertyText, gridBagConstraints);
    }

    private void propertyTextFocusGained(FocusEvent focusEvent) {
        this.propertyText.selectAll();
    }

    private void componentTextFocusGained(FocusEvent focusEvent) {
        this.componentText.selectAll();
    }

    private void foundInTextFocusGained(FocusEvent focusEvent) {
        this.foundInText.selectAll();
    }

    private void stringTextFocusGained(FocusEvent focusEvent) {
        this.stringText.selectAll();
    }
}

