/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringElement;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;

public class HibernateMappingFindUsagesPlugin
implements RefactoringPlugin {
    private final WhereUsedQuery query;
    private FileObject fo;

    public HibernateMappingFindUsagesPlugin(WhereUsedQuery whereUsedQuery) {
        this.query = whereUsedQuery;
        this.fo = (FileObject)whereUsedQuery.getRefactoringSource().lookup(FileObject.class);
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.query.getBooleanValue((Object)"FIND_REFERENCES")) {
            if (this.fo == null || !this.fo.getMIMEType().equals("text/x-hibernate-mapping+xml")) {
                return null;
            }
            String string = this.getOrigResourceName();
            if (string == null) {
                return null;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment == null) {
                return null;
            }
            List<FileObject> list = hibernateEnvironment.getAllHibernateConfigFileObjects();
            if (list.isEmpty()) {
                return null;
            }
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> map = HibernateRefactoringUtil.getMappingResourceOccurrences(list, string, false);
            for (FileObject fileObject : map.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> list2 = map.get(fileObject);
                for (HibernateRefactoringUtil.OccurrenceItem occurrenceItem : list2) {
                    HibernateRefactoringElement hibernateRefactoringElement = new HibernateRefactoringElement(fileObject, string, occurrenceItem.getLocation(), occurrenceItem.getText());
                    refactoringElementsBag.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)hibernateRefactoringElement);
                }
            }
            return null;
        }
        return null;
    }

    private String getOrigResourceName() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project);
        if (sourceGroupArray.length == 0) {
            return null;
        }
        String string = sourceGroupArray[0].getRootFolder().getPath();
        String string2 = this.fo.getPath();
        String string3 = string2.substring(string.length() + 1);
        return string3;
    }
}

