/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.folding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.folding.JspFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspFoldManager
implements FoldManager {
    private FoldOperation operation;
    private static final int FOLD_UPDATE_DELAY = 1000;
    private boolean documentDirty = true;
    private BaseDocument doc;
    private final List<Fold> currentFolds = new ArrayList<Fold>(20);
    private Preferences prefs;
    private final RequestProcessor.Task FOLDS_UPDATE_TASK = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            try {
                JspFoldManager.this.documentDirty = false;
                JspFoldManager.this.updateFolds();
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    });

    public JspFoldManager() {
        this.prefs = (Preferences)MimeLookup.getLookup((String)"text/x-jsp").lookup(Preferences.class);
    }

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        Document document = this.getOperation().getHierarchy().getComponent().getDocument();
        if (document instanceof BaseDocument) {
            this.doc = (BaseDocument)document;
            this.restartTimer();
        }
    }

    private void restartTimer() {
        this.FOLDS_UPDATE_TASK.schedule(1000);
    }

    public void release() {
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.restartTimer();
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.restartTimer();
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
    }

    public void removeDamagedNotify(Fold fold) {
    }

    public void expandNotify(Fold fold) {
    }

    private List<FoldInfo> generateFolds() {
        try {
            int n;
            BaseDocument baseDocument = this.getDocument();
            JspSyntaxSupport jspSyntaxSupport = JspSyntaxSupport.get((Document)baseDocument);
            ArrayList<FoldInfo> arrayList = new ArrayList<FoldInfo>(this.getDocument().getLength() / 100);
            SyntaxElement syntaxElement = jspSyntaxSupport.getElementChain(1);
            Stack stack = new Stack();
            int n2 = n = syntaxElement != null ? syntaxElement.getElementOffset() : 0;
            while (syntaxElement != null) {
                TagSE tagSE;
                if (this.documentDirty) {
                    return null;
                }
                if (syntaxElement.getCompletionContext() == 4) {
                    arrayList.add(new FoldInfo((Document)this.doc, syntaxElement.getElementOffset(), syntaxElement.getElementOffset() + syntaxElement.getElementLength(), JspFoldTypes.COMMENT, "<%--...--%>"));
                } else if (syntaxElement.getCompletionContext() == 7) {
                    arrayList.add(new FoldInfo((Document)this.doc, syntaxElement.getElementOffset(), syntaxElement.getElementOffset() + syntaxElement.getElementLength(), JspFoldTypes.SCRIPTLET, "<%...%>"));
                } else if (syntaxElement.getCompletionContext() == 1) {
                    tagSE = new TagSE((SyntaxElement.TagLikeElement)syntaxElement);
                    this.handleOpenTagElement((Document)this.doc, tagSE, arrayList, stack);
                } else if (syntaxElement.getCompletionContext() == 2) {
                    tagSE = new TagSE((SyntaxElement.TagLikeElement)syntaxElement);
                    this.handleEndTagElement((Document)this.doc, tagSE, arrayList, stack);
                }
                if ((syntaxElement = syntaxElement.getNext()) == null) continue;
                if (n >= syntaxElement.getElementOffset()) {
                    return Collections.EMPTY_LIST;
                }
                n = syntaxElement.getElementOffset();
            }
            return arrayList;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return null;
        }
    }

    private void handleOpenTagElement(Document document, TagSE tagSE, List list, Stack stack) throws BadLocationException {
        if (tagSE.isSingletonTag()) {
            list.add(new FoldInfo(document, tagSE.getElementOffset(), tagSE.getElementOffset() + tagSE.getElementLength(), JspFoldTypes.TAG, this.getSingletonTagFoldName(tagSE.getTagName())));
        } else {
            stack.push(tagSE);
        }
    }

    private void handleEndTagElement(Document document, TagSE tagSE, List list, Stack stack) throws BadLocationException {
        if (!stack.isEmpty()) {
            TagSE tagSE2 = (TagSE)stack.peek();
            assert (tagSE2.isOpenTag());
            if (tagSE.getTagName().equals(tagSE2.getTagName())) {
                list.add(new FoldInfo(document, tagSE2.getElementOffset(), tagSE.getElementOffset() + tagSE.getElementLength(), JspFoldTypes.TAG, this.getTagFoldName(tagSE2.getTagName())));
                stack.pop();
            } else {
                ArrayList<TagSE> arrayList = new ArrayList<TagSE>();
                boolean bl = false;
                while (!stack.isEmpty()) {
                    TagSE tagSE3 = (TagSE)stack.pop();
                    arrayList.add(tagSE3);
                    assert (tagSE3.isOpenTag());
                    if (!tagSE3.getTagName().equals(tagSE.getTagName())) continue;
                    list.add(new FoldInfo(document, tagSE3.getElementOffset(), tagSE.getElementOffset() + tagSE.getElementLength(), JspFoldTypes.TAG, this.getTagFoldName(tagSE3.getTagName())));
                    bl = true;
                    break;
                }
                if (!bl) {
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        stack.push(arrayList.get(i));
                    }
                }
            }
        }
    }

    private String getSingletonTagFoldName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    private String getTagFoldName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append(">...</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private void mergeFolds(List<FoldInfo> list, Set<Fold> set, Set<FoldInfo> set2) throws BadLocationException {
        FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
        HashSet<FoldInfo> hashSet2 = new HashSet<FoldInfo>();
        for (FoldInfo object2 : list) {
            if (!this.isOneLineElement(object2)) continue;
            hashSet2.add(object2);
        }
        list.removeAll(hashSet2);
        List list2 = FoldUtilities.findRecursive((Fold)foldHierarchy.getRootFold());
        assert (list2 != null) : "Existing folds is null!";
        list2.retainAll(this.currentFolds);
        Hashtable<Integer, FoldInfo> hashtable = new Hashtable<Integer, FoldInfo>();
        HashSet<FoldInfo> hashSet = new HashSet<FoldInfo>();
        for (FoldInfo foldInfo : list) {
            int n = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo.getStartOffset());
            FoldInfo foldInfo2 = (FoldInfo)hashtable.get(new Integer(n));
            if (foldInfo2 != null && foldInfo2.getEndOffset() < foldInfo.getEndOffset()) {
                hashSet.add(foldInfo2);
            }
            hashtable.put(new Integer(n), foldInfo);
            Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)foldInfo.getStartOffset());
            if (fold != null && fold.getStartOffset() == foldInfo.getStartOffset() && fold.getEndOffset() == foldInfo.getEndOffset() && this.currentFolds.contains(fold)) {
                if (foldInfo.foldType == fold.getType() && foldInfo.description.equals(fold.getDescription())) continue;
                set.add(fold);
                set2.add(foldInfo);
                continue;
            }
            set2.add(foldInfo);
        }
        set2.removeAll(hashSet);
        list2.removeAll(set);
        Hashtable hashtable2 = new Hashtable();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Fold fold = (Fold)iterator.next();
            boolean bl = false;
            for (FoldInfo foldInfo : list) {
                if (fold.getStartOffset() != foldInfo.getStartOffset() || fold.getEndOffset() != foldInfo.getEndOffset()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                set.add(fold);
                continue;
            }
            int n = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fold.getStartOffset());
            hashtable2.put(new Integer(n), fold);
        }
        HashSet<FoldInfo> hashSet3 = new HashSet<FoldInfo>();
        for (FoldInfo foldInfo : set2) {
            Fold fold = (Fold)hashtable2.get(new Integer(Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo.getStartOffset())));
            if (fold == null) continue;
            if (fold.getEndOffset() < foldInfo.getEndOffset()) {
                set.add(fold);
                continue;
            }
            hashSet3.add(foldInfo);
        }
        set2.removeAll(hashSet3);
    }

    private synchronized void updateFolds() throws BadLocationException {
        final FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
        final HashSet hashSet = new HashSet();
        final HashSet hashSet2 = new HashSet();
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        this.getDocument().render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    foldHierarchy.lock();
                    List list = JspFoldManager.this.generateFolds();
                    if (list == null) {
                        return;
                    }
                    JspFoldManager.this.mergeFolds(list, hashSet, hashSet2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
        });
        if (badLocationExceptionArray[0] != null) {
            throw badLocationExceptionArray[0];
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JspFoldManager.this.getDocument().readLock();
                try {
                    foldHierarchy.lock();
                    try {
                        FoldHierarchyTransaction foldHierarchyTransaction = JspFoldManager.this.getOperation().openTransaction();
                        try {
                            for (Object object : hashSet) {
                                JspFoldManager.this.getOperation().removeFromHierarchy((Fold)object, foldHierarchyTransaction);
                                JspFoldManager.this.currentFolds.remove(object);
                            }
                            for (FoldInfo foldInfo : hashSet2) {
                                if (foldInfo.getStartOffset() < 0 || foldInfo.getEndOffset() < 0 || foldInfo.getStartOffset() >= foldInfo.getEndOffset() || foldInfo.getEndOffset() > JspFoldManager.this.getDocument().getLength()) continue;
                                try {
                                    JspFoldManager.this.currentFolds.add(JspFoldManager.this.getOperation().addToHierarchy(foldInfo.foldType, foldInfo.description, JspFoldManager.this.isInitiallyCollapsed(foldInfo.foldType), foldInfo.getStartOffset(), foldInfo.getEndOffset(), 0, 0, null, foldHierarchyTransaction));
                                }
                                catch (BadLocationException badLocationException) {}
                            }
                        }
                        finally {
                            foldHierarchyTransaction.commit();
                        }
                    }
                    finally {
                        foldHierarchy.unlock();
                    }
                }
                finally {
                    JspFoldManager.this.getDocument().readUnlock();
                }
            }
        });
    }

    private boolean isInitiallyCollapsed(FoldType foldType) {
        String string = null;
        if (foldType == JspFoldTypes.TAG) {
            string = "code-folding-collapse-tags";
        } else if (foldType == JspFoldTypes.COMMENT) {
            string = "code-folding-collapse-javadoc";
        }
        if (string != null) {
            return this.prefs.getBoolean(string, false);
        }
        return false;
    }

    private boolean isOneLineElement(FoldInfo foldInfo) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo.getStartOffset()) == Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo.getEndOffset());
    }

    private BaseDocument getDocument() {
        return this.doc;
    }

    private static class TagSE {
        private SyntaxElement.TagLikeElement jspse = null;

        public TagSE(SyntaxElement.TagLikeElement tagLikeElement) {
            this.jspse = tagLikeElement;
        }

        public int getElementOffset() {
            return this.jspse.getElementOffset();
        }

        public int getElementLength() {
            return this.jspse.getElementLength();
        }

        public int getType() {
            return this.jspse.getCompletionContext();
        }

        public boolean isOpenTag() {
            return this.jspse.getCompletionContext() == 1;
        }

        public String getTagName() {
            return this.jspse.getName();
        }

        public boolean isSingletonTag() {
            if (!this.isOpenTag()) {
                return false;
            }
            return ((SyntaxElement.Tag)this.jspse).isClosed();
        }
    }

    private static class FoldInfo {
        private Position startOffset;
        private Position endOffset;
        private FoldType foldType;
        private String description;

        public FoldInfo(Document document, int n, int n2, FoldType foldType, String string) throws BadLocationException {
            this.startOffset = document.createPosition(n);
            this.endOffset = document.createPosition(n2);
            this.foldType = foldType;
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public int getEndOffset() {
            return this.endOffset.getOffset();
        }

        public FoldType getFoldType() {
            return this.foldType;
        }

        public int getStartOffset() {
            return this.startOffset.getOffset();
        }

        public String toString() {
            return "FoldInfo[start=" + this.startOffset + ", end=" + this.endOffset + ", descr=" + this.description + ", type=" + this.foldType + "]";
        }
    }
}

