/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.spi.JspColoringData;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.openide.loaders.DataObject;
import org.openide.util.WeakListeners;

final class JspUpToDateStatusProvider
extends UpToDateStatusProvider
implements DocumentListener,
PropertyChangeListener {
    private UpToDateStatus upToDate = UpToDateStatus.UP_TO_DATE_OK;

    public static JspUpToDateStatusProvider get(Document document) {
        JspUpToDateStatusProvider jspUpToDateStatusProvider = (JspUpToDateStatusProvider)document.getProperty(JspUpToDateStatusProvider.class);
        if (jspUpToDateStatusProvider == null) {
            jspUpToDateStatusProvider = new JspUpToDateStatusProvider(document);
            document.putProperty(JspUpToDateStatusProvider.class, jspUpToDateStatusProvider);
        }
        return jspUpToDateStatusProvider;
    }

    private JspUpToDateStatusProvider(Document document) {
        document.addDocumentListener(this);
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        if (dataObject != null && dataObject.isValid()) {
            JspColoringData jspColoringData = JspUtils.getJSPColoringData(dataObject.getPrimaryFile());
            if (jspColoringData != null) {
                jspColoringData.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jspColoringData));
            } else {
                this.upToDate = UpToDateStatus.UP_TO_DATE_DIRTY;
                Logger.getAnonymousLogger().info("JspUtils.getJSPColoringData(document, " + dataObject.getPrimaryFile() + ") returned null!");
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        if ("parsingInProgress".equals(propertyChangeEvent.getPropertyName()) && bl.booleanValue()) {
            this.setUpToDate(UpToDateStatus.UP_TO_DATE_PROCESSING);
        }
        if ("parsingSuccessful".equals(propertyChangeEvent.getPropertyName())) {
            this.setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
        }
    }

    public synchronized UpToDateStatus getUpToDate() {
        return this.upToDate;
    }

    private void setUpToDate(UpToDateStatus upToDateStatus) {
        UpToDateStatus upToDateStatus2 = this.upToDate;
        if (upToDateStatus2.equals((Object)upToDateStatus)) {
            return;
        }
        this.upToDate = upToDateStatus;
        this.firePropertyChange("upToDate", upToDateStatus2, upToDateStatus);
    }

    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        this.setUpToDate(UpToDateStatus.UP_TO_DATE_DIRTY);
    }

    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        this.setUpToDate(UpToDateStatus.UP_TO_DATE_DIRTY);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

