/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.kenai;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.openide.util.Utilities;

public class KenaiHudsonBuildAssociation
extends ProjectHudsonProvider {
    private static final Logger LOG = Logger.getLogger(KenaiHudsonBuildAssociation.class.getName());

    public ProjectHudsonProvider.Association findAssociation(Project project) {
        Object object = project.getProjectDirectory().getAttribute("ProvidedExtensions.RemoteLocation");
        if (object instanceof String) {
            try {
                KenaiProject kenaiProject = KenaiProject.forRepository((String)((String)object));
                ProjectHudsonProvider.Association association = this.findAssociation(kenaiProject);
                if (association != null) {
                    return association;
                }
            }
            catch (KenaiException kenaiException) {
                LOG.log(Level.FINE, "Looking up association for " + project, kenaiException);
            }
        }
        return null;
    }

    private ProjectHudsonProvider.Association findAssociation(KenaiProject kenaiProject) throws KenaiException {
        KenaiFeature[] kenaiFeatureArray;
        int n;
        int n2;
        if (kenaiProject != null && (n2 = 0) < (n = (kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.HUDSON)).length)) {
            KenaiFeature kenaiFeature = kenaiFeatureArray[n2];
            String string = kenaiFeature.getWebLocation().toString();
            return ProjectHudsonProvider.Association.fromString((String)string);
        }
        return null;
    }

    public boolean recordAssociation(Project project, ProjectHudsonProvider.Association association) {
        return Utilities.compareObjects((Object)association, (Object)this.findAssociation(project));
    }
}

