/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.logging;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.logging.SessionLogEntry;

public class DefaultSessionLog
extends AbstractSessionLog
implements Serializable {
    protected String fileName;
    private Map<String, Integer> categoryLogLevelMap = new HashMap<String, Integer>();

    public DefaultSessionLog() {
        this.level = 5;
        for (int i = 0; i < loggerCategories.length; ++i) {
            String loggerCategory = loggerCategories[i];
            this.categoryLogLevelMap.put(loggerCategory, null);
        }
    }

    public DefaultSessionLog(Writer writer) {
        this();
        this.initialize(writer);
    }

    protected void initialize(Writer writer) {
        this.writer = writer;
    }

    public int getLevel(String category) {
        Integer logLevel;
        if (category != null && (logLevel = this.categoryLogLevelMap.get(category)) != null) {
            return logLevel;
        }
        return this.level;
    }

    public void setLevel(int level, String category) {
        if (category == null) {
            this.level = level;
        } else if (this.categoryLogLevelMap.containsKey(category)) {
            this.categoryLogLevelMap.put(category, level);
        }
    }

    public boolean shouldLog(int level, String category) {
        return this.getLevel(category) <= level;
    }

    public synchronized void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            return;
        }
        try {
            this.printPrefixString(entry.getLevel());
            this.getWriter().write(this.getSupplementDetailString(entry));
            if (entry.hasException()) {
                if (entry.getLevel() == 7) {
                    entry.getException().printStackTrace(new PrintWriter(this.getWriter()));
                } else if (entry.getLevel() <= 6) {
                    if (this.shouldLogExceptionStackTrace()) {
                        entry.getException().printStackTrace(new PrintWriter(this.getWriter()));
                    } else {
                        this.writeMessage(entry.getException().toString());
                    }
                }
            } else {
                this.writeMessage(this.formatMessage(entry));
            }
            this.getWriter().write(Helper.cr());
            this.getWriter().flush();
        }
        catch (IOException exception) {
            throw ValidationException.logIOError(exception);
        }
    }

    public void setWriter(String aFileName) {
        if (aFileName != null) {
            try {
                this.writer = new FileWriter(aFileName);
                this.fileName = aFileName;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getWriterFilename() {
        return this.fileName;
    }

    protected void writeMessage(String message) throws IOException {
        this.getWriter().write(message);
    }

    protected void writeSeparator() throws IOException {
        this.getWriter().write("--");
    }
}

