/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.weaving;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.spi.ClassTransformer;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.weaving.ClassDetails;
import oracle.toplink.essentials.internal.weaving.TopLinkClassWeaver;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.libraries.asm.ClassReader;
import oracle.toplink.libraries.asm.ClassWriter;
import oracle.toplink.libraries.asm.attrs.Attributes;

public class TopLinkWeaver
implements ClassTransformer {
    public static final String WEAVING_OUTPUT_PATH = "toplink.weaving.output.path";
    public static final String WEAVING_SHOULD_OVERWRITE = "toplink.weaving.overwrite.existing";
    public static final String WEAVER_NOT_OVERWRITING = "weaver_not_overwriting";
    public static final String WEAVER_COULD_NOT_WRITE = "weaver_could_not_write";
    public static final String WEAVER_FAILED = "weaver_failed";
    public static final String WEAVER_TRANSFORMED_CLASS = "weaver_transformed_class";
    protected Session session;
    protected Map classDetailsMap;

    public TopLinkWeaver(Session session, Map classDetailsMap) {
        this.session = session;
        this.classDetailsMap = classDetailsMap;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        ClassDetails classDetails = (ClassDetails)this.classDetailsMap.get(className);
        if (classDetails != null) {
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(true, true);
            TopLinkClassWeaver tcw = new TopLinkClassWeaver(cw, classDetails);
            try {
                cr.accept(tcw, Attributes.getDefaultAttributes(), false);
            }
            catch (Throwable e) {
                this.log(7, WEAVER_FAILED, new Object[]{className, e});
                this.log(7, e);
                IllegalClassFormatException ex = new IllegalClassFormatException();
                ex.initCause(e);
                throw ex;
            }
            if (tcw.alreadyWeaved) {
                return null;
            }
            byte[] bytes = cw.toByteArray();
            String outputPath = System.getProperty(WEAVING_OUTPUT_PATH, "");
            if (!outputPath.equals("")) {
                this.outputFile(className, bytes, outputPath);
            }
            if (tcw.weavedVH) {
                this.log(2, WEAVER_TRANSFORMED_CLASS, new Object[]{className});
                return bytes;
            }
        }
        return null;
    }

    protected void outputFile(String className, byte[] classBytes, String outputPath) {
        StringBuffer directoryName = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(className, "\n\\/");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            directoryName.append(token + File.separator);
        }
        try {
            String usedOutputPath = outputPath;
            if (!outputPath.endsWith(File.separator)) {
                usedOutputPath = outputPath + File.separator;
            }
            File file = new File(usedOutputPath + directoryName);
            file.mkdirs();
            file = new File(file, token + ".class");
            if (!file.exists()) {
                file.createNewFile();
            } else if (!System.getProperty(WEAVING_SHOULD_OVERWRITE, "false").equalsIgnoreCase("true")) {
                this.log(6, WEAVER_NOT_OVERWRITING, new Object[]{className});
                return;
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(classBytes);
            fos.close();
        }
        catch (Exception e) {
            this.log(6, WEAVER_COULD_NOT_WRITE, new Object[]{className, e});
        }
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }

    protected void log(int level, String msg, Object[] params) {
        ((AbstractSession)this.session).log(level, "weaver", msg, params);
    }

    protected void log(int level, Throwable t) {
        ((AbstractSession)this.session).logThrowable(level, "weaver", t);
    }

    static {
        ClassDetails.class.getClass();
    }
}

