/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.weaving;

import oracle.toplink.essentials.internal.weaving.AttributeDetails;
import oracle.toplink.essentials.internal.weaving.ClassDetails;
import oracle.toplink.essentials.internal.weaving.TopLinkClassWeaver;
import oracle.toplink.libraries.asm.Attribute;
import oracle.toplink.libraries.asm.CodeAdapter;
import oracle.toplink.libraries.asm.CodeVisitor;
import oracle.toplink.libraries.asm.Constants;
import oracle.toplink.libraries.asm.Label;

public class TopLinkMethodWeaver
extends CodeAdapter
implements Constants {
    protected TopLinkClassWeaver tcw;
    protected String methodName;
    private String methodDescriptor = null;
    private boolean methodStarted = false;
    private boolean constructorInitializationDone = false;

    public TopLinkMethodWeaver(TopLinkClassWeaver tcw, String methodName, String methodDescriptor, CodeVisitor cv) {
        super(cv);
        this.tcw = tcw;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }

    public void weaveAttributesIfRequired(int opcode, String owner, String name, String desc) {
        AttributeDetails attributeDetails = this.tcw.classDetails.getAttributeDetailsFromClassOrSuperClass(name);
        if (attributeDetails == null || !attributeDetails.isMappedWithAttributeAccess()) {
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        if (opcode == 180) {
            if (attributeDetails != null) {
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_toplink_get" + name, "()L" + attributeDetails.getReferenceClass().replace('.', '/') + ";");
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        } else if (opcode == 181) {
            if (attributeDetails != null) {
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_toplink_set" + name, "(L" + attributeDetails.getReferenceClass().replace('.', '/') + ";)V");
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        } else {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    public void weaveConstructorIfRequired(int opcode, String owner, String name, String desc) {
        if (!this.constructorInitializationDone && ("<init>".equals(this.methodName) || "<cinit>".equals(this.methodName))) {
            if (opcode == 183 && name.startsWith("<init>")) {
                ClassDetails details = this.tcw.classDetails;
                for (String key : details.getAttributesMap().keySet()) {
                    AttributeDetails attribute = (AttributeDetails)details.getAttributesMap().get(key);
                    if (!attribute.weaveValueHolders() || attribute.isCollectionMapping() || attribute.isAttributeOnSuperClass()) continue;
                    super.visitVarInsn(25, 0);
                    super.visitTypeInsn(187, "oracle/toplink/essentials/indirection/ValueHolder");
                    super.visitInsn(89);
                    super.visitMethodInsn(183, "oracle/toplink/essentials/indirection/ValueHolder", "<init>", "()V");
                    super.visitFieldInsn(181, details.className, "_toplink_" + attribute.attributeName + "_vh", "Loracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface;");
                    super.visitVarInsn(25, 0);
                    super.visitFieldInsn(180, details.className, "_toplink_" + attribute.attributeName + "_vh", "Loracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface;");
                    super.visitInsn(4);
                    super.visitMethodInsn(185, "oracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface", "setIsNewlyWeavedValueHolder", "(Z)V");
                }
            }
            this.constructorInitializationDone = true;
        }
    }

    public void addValueHolderReferencesIfRequired() {
        if (this.methodStarted) {
            return;
        }
        AttributeDetails attributeDetails = (AttributeDetails)this.tcw.classDetails.getGetterMethodToAttributeDetails().get(this.methodName);
        if (attributeDetails != null && !attributeDetails.isAttributeOnSuperClass()) {
            this.cv.visitVarInsn(25, 0);
            this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_toplink_" + attributeDetails.getAttributeName() + "_vh", "Loracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface;");
            this.cv.visitMethodInsn(185, "oracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface", "isInstantiated", "()Z");
            Label l0 = new Label();
            this.cv.visitJumpInsn(154, l0);
            this.cv.visitVarInsn(25, 0);
            this.cv.visitVarInsn(25, 0);
            this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_toplink_" + attributeDetails.getAttributeName() + "_vh", "Loracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface;");
            this.cv.visitMethodInsn(185, "oracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface", "getValue", "()Ljava/lang/Object;");
            this.cv.visitTypeInsn(192, attributeDetails.getReferenceClass().replace('.', '/'));
            this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), attributeDetails.getSetterMethodName(), "(L" + attributeDetails.getReferenceClass().replace('.', '/') + ";)V");
            this.cv.visitLabel(l0);
        } else {
            attributeDetails = (AttributeDetails)this.tcw.classDetails.getSetterMethodToAttributeDetails().get(this.methodName);
            if (attributeDetails != null) {
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_toplink_" + attributeDetails.getAttributeName() + "_vh", "Loracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitVarInsn(25, 1);
                this.cv.visitMethodInsn(185, "oracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface", "setValue", "(Ljava/lang/Object;)V");
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_toplink_" + attributeDetails.getAttributeName() + "_vh", "Loracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitInsn(4);
                this.cv.visitMethodInsn(185, "oracle/toplink/essentials/indirection/WeavedAttributeValueHolderInterface", "setIsCoordinatedWithProperty", "(Z)V");
            }
        }
    }

    public void visitInsn(int opcode) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitTypeInsn(opcode, desc);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.weaveAttributesIfRequired(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        super.visitMethodInsn(opcode, owner, name, desc);
        this.weaveConstructorIfRequired(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.cv.visitLabel(label);
    }

    public void visitLdcInsn(Object cst) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitMaxs(0, 0);
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitLocalVariable(name, desc, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        this.cv.visitLineNumber(line, start);
    }

    public void visitAttribute(Attribute attr) {
        this.addValueHolderReferencesIfRequired();
        this.methodStarted = true;
        this.cv.visitAttribute(attr);
    }

    protected AttributeDetails weaveValueHolders(ClassDetails startingDetails, String fieldName) {
        if (startingDetails == null) {
            return null;
        }
        AttributeDetails attributeDetails = (AttributeDetails)startingDetails.getAttributesMap().get(fieldName);
        if (attributeDetails != null && attributeDetails.weaveValueHolders()) {
            return attributeDetails;
        }
        return this.weaveValueHolders(startingDetails.getSuperClassDetails(), fieldName);
    }
}

