/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.HashMap;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.EmbeddedAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;

public class EmbeddedIdAccessor
extends EmbeddedAccessor {
    protected HashMap<String, DatabaseField> m_idFields = new HashMap();

    public EmbeddedIdAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    public boolean isEmbeddedId() {
        return true;
    }

    public void process() {
        if (this.m_descriptor.ignoreIDs()) {
            this.m_logger.logWarningMessage("metadata_warning_ignore_embedded_id", this);
        } else {
            if (this.m_descriptor.hasEmbeddedIdAttribute()) {
                this.m_validator.throwMultipleEmbeddedIdsFound(this.getJavaClass(), this.getAttributeName(), this.m_descriptor.getEmbeddedIdAttributeName());
            }
            if (this.m_descriptor.hasPrimaryKeyFields()) {
                this.m_validator.throwEmbeddedIdAndIdFound(this.getJavaClass(), this.getAttributeName(), this.m_descriptor.getIdAttributeName());
            }
            this.m_descriptor.setPKClass(this.getReferenceClass());
            this.m_descriptor.setEmbeddedIdAttributeName(this.getAttributeName());
        }
        super.process();
        for (DatabaseField field : this.m_idFields.values()) {
            this.m_descriptor.addPrimaryKeyField(field);
        }
    }

    protected void processAttributeOverride(AggregateObjectMapping mapping, MetadataColumn column) {
        super.processAttributeOverride(mapping, column);
        DatabaseField field = column.getDatabaseField();
        field.setTableName(this.m_descriptor.getPrimaryTableName());
        this.m_idFields.put(column.getAttributeName(), field);
    }

    protected MetadataDescriptor processEmbeddableClass() {
        MetadataDescriptor embeddableDescriptor = super.processEmbeddableClass();
        if (this.isEmbeddedId() && !this.m_descriptor.ignoreIDs()) {
            if (embeddableDescriptor.getMappings().isEmpty()) {
                String accessType = embeddableDescriptor.usesPropertyAccess() ? EmbeddedAccessor.AccessType.PROPERTY.name() : EmbeddedAccessor.AccessType.FIELD.name();
                this.m_validator.throwEmbeddedIdHasNoAttributes(this.m_descriptor.getJavaClass(), embeddableDescriptor.getJavaClass(), accessType);
            }
            for (DatabaseMapping mapping : embeddableDescriptor.getMappings()) {
                DatabaseField field = (DatabaseField)mapping.getField().clone();
                field.setTableName(this.m_descriptor.getPrimaryTableName());
                this.m_idFields.put(mapping.getAttributeName(), field);
            }
        }
        return embeddableDescriptor;
    }
}

