/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.device;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.screen.display.DeviceTheme;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfoPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.screen.ScreenAccessController;
import org.netbeans.modules.vmd.screen.device.DummyDisplayPresenter;
import org.netbeans.modules.vmd.screen.device.TopPanel;

public class DevicePanel
extends JPanel {
    private static final Color BACKGROUND_COLOR = new Color(16513523);
    private final ScreenDisplayPresenter dummyPresenter = new DummyDisplayPresenter();
    private ScreenAccessController controller;
    private JPanel displayPanel;
    private TopPanel topPanel;

    public DevicePanel(ScreenAccessController screenAccessController) {
        this.controller = screenAccessController;
        this.setBackground(BACKGROUND_COLOR);
        this.topPanel = new TopPanel(this);
        this.displayPanel = new JPanel();
        this.displayPanel.setLayout(new BorderLayout());
        this.displayPanel.setBackground(BACKGROUND_COLOR);
        this.initializeUI();
    }

    private ScreenDeviceInfo getDeviceInfo() {
        final ScreenDeviceInfo[] screenDeviceInfoArray = new ScreenDeviceInfo[1];
        final DesignDocument designDocument = this.controller.getDocument();
        if (designDocument == null) {
            return null;
        }
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = designDocument.getRootComponent();
                ScreenDeviceInfoPresenter screenDeviceInfoPresenter = (ScreenDeviceInfoPresenter)designComponent.getPresenter(ScreenDeviceInfoPresenter.class);
                assert (screenDeviceInfoPresenter != null) : "No ScreenDevice attached to the root component";
                screenDeviceInfoArray[0] = screenDeviceInfoPresenter.getScreenDeviceInfo();
            }
        });
        return screenDeviceInfoArray[0];
    }

    public ScreenAccessController getController() {
        return this.controller;
    }

    private void initializeUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.topPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.TOP_LEFT), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.TOP), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.TOP_RIGHT), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.LEFT), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.displayPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.RIGHT), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.BOTTOM_LEFT), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.BOTTOM), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        this.add((Component)this.getDeviceInfo().getDeviceBorder(ScreenDeviceInfo.Edge.BOTTOM_RIGHT), gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(BACKGROUND_COLOR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void reload() {
        Component[] componentArray;
        ScreenDisplayPresenter screenDisplayPresenter;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        DesignComponent designComponent = this.controller.getEditedScreen();
        ScreenDisplayPresenter screenDisplayPresenter2 = screenDisplayPresenter = designComponent != null ? (ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class) : null;
        if (screenDisplayPresenter == null) {
            screenDisplayPresenter = this.dummyPresenter;
        }
        this.displayPanel.setVisible(false);
        this.displayPanel.removeAll();
        this.displayPanel.setPreferredSize(null);
        this.displayPanel.add((Component)screenDisplayPresenter.getView(), "Center");
        this.displayPanel.setBackground(this.getDeviceInfo().getDeviceTheme().getColor(DeviceTheme.Colors.BACKGROUND));
        screenDisplayPresenter.reload(this.getDeviceInfo());
        int n = 0;
        for (Component component2 : componentArray = screenDisplayPresenter.getView().getComponents()) {
            n = (int)((double)n + component2.getPreferredSize().getHeight());
        }
        Dimension dimension = this.getDeviceInfo().getCurrentScreenSize();
        this.displayPanel.setMinimumSize(dimension);
        if (dimension.height >= n) {
            this.displayPanel.setPreferredSize(dimension);
        } else {
            this.displayPanel.setPreferredSize(new Dimension(dimension.width, n));
        }
        this.displayPanel.setMaximumSize(new Dimension(dimension.width, Integer.MAX_VALUE));
        this.displayPanel.setVisible(true);
        this.displayPanel.validate();
        this.topPanel.reload();
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    public DesignComponent getDesignComponentAt(Point point) {
        return DevicePanel.getDesignComponentAt(this.controller.getEditedScreen(), this, point);
    }

    private static DesignComponent getDesignComponentAt(DesignComponent designComponent, JComponent jComponent, Point point) {
        Object object;
        if (designComponent == null) {
            return null;
        }
        ScreenDisplayPresenter screenDisplayPresenter = (ScreenDisplayPresenter)designComponent.getPresenter(ScreenDisplayPresenter.class);
        if (screenDisplayPresenter == null) {
            return null;
        }
        JComponent jComponent2 = screenDisplayPresenter.getView();
        Point point2 = screenDisplayPresenter.getLocation();
        if (point2 != null && !point2.equals(jComponent2.getLocation())) {
            jComponent2.setLocation(point2);
        }
        Container container = jComponent2;
        Point point3 = new Point(point);
        while (true) {
            if (container == null) {
                return null;
            }
            if (container == jComponent) break;
            object = container.getLocation();
            point3.x -= ((Point)object).x;
            point3.y -= ((Point)object).y;
            container = container.getParent();
        }
        for (DesignComponent designComponent2 : screenDisplayPresenter.getChildren()) {
            DesignComponent designComponent3 = DevicePanel.getDesignComponentAt(designComponent2, jComponent2, point3);
            if (designComponent3 == null) continue;
            return designComponent3;
        }
        object = screenDisplayPresenter.getSelectionShape();
        if (object != null && object.contains(point3)) {
            return screenDisplayPresenter.getRelatedComponent();
        }
        return null;
    }

    public Point calculateTranslation(Container container, Point point) {
        Point point2 = new Point();
        if (point != null && !point.equals(container.getLocation())) {
            container.setLocation(point);
        }
        while (true) {
            if (container == null) {
                return null;
            }
            if (container == this) break;
            Point point3 = container.getLocation();
            point2.x += point3.x;
            point2.y += point3.y;
            container = container.getParent();
        }
        return point2;
    }

    public void setScreenSize(Dimension dimension) {
        ScreenDeviceInfo screenDeviceInfo = this.getDeviceInfo();
        if (dimension == null) {
            dimension = new Dimension(240, 320);
        }
        if (dimension.equals(screenDeviceInfo.getCurrentScreenSize())) {
            return;
        }
        screenDeviceInfo.setArbitraryScreenSize(dimension);
        this.reload();
    }
}

