/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.entity;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.util.SourceLevelChecker;
import org.netbeans.modules.j2ee.persistence.wizard.entity.EntityWizardPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EntityWizardDescriptor
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private EntityWizardPanel p;
    private List changeListeners = new ArrayList();
    private WizardDescriptor wizardDescriptor;
    private Project project;

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public Component getComponent() {
        if (this.p == null) {
            this.p = new EntityWizardPanel(this);
            this.p.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object;
                    if (propertyChangeEvent.getPropertyName().equals("EntityWizardPanel_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                        EntityWizardDescriptor.this.stateChanged(null);
                    }
                }
            });
        }
        return this.p;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(EntityWizardDescriptor.class);
    }

    public boolean isValid() {
        if (this.wizardDescriptor == null) {
            return true;
        }
        if (SourceLevelChecker.isSourceLevel14orLower(this.project)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_NeedProperSourceLevel"));
            return false;
        }
        if (this.p.getPrimaryKeyClassName().trim().equals("")) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_PrimaryKeyNotEmpty"));
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
        if (this.project == null) {
            this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
            this.p.setProject(this.project);
        }
        try {
            if (ProviderUtil.isValidServerInstanceOrNone(this.project) && !this.isPersistenceUnitDefined()) {
                String string = NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_NoPersistenceUnit");
                this.p.setPersistenceUnitButtonVisibility(true, string);
            } else {
                this.p.setPersistenceUnitButtonVisibility(false, null);
            }
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            String string = NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)invalidPersistenceXmlException.getPath());
            this.p.setPersistenceUnitButtonVisibility(false, string);
        }
    }

    private boolean isPersistenceUnitDefined() throws InvalidPersistenceXmlException {
        return ProviderUtil.persistenceExists(this.project) || this.getPersistenceUnit() != null;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public void storeSettings(Object object) {
    }

    public String getPrimaryKeyClassName() {
        return this.p.getPrimaryKeyClassName();
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.p.getPersistenceUnit();
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator iterator;
        Object object = this.changeListeners;
        synchronized (object) {
            iterator = new HashSet(this.changeListeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }
}

