/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.api.entity.generator;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaTableProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.JavaPersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntitiesFromDBGenerator {
    private final List<String> tableNames;
    private final boolean generateNamedQueries;
    private final String packageName;
    private final SourceGroup location;
    private final DatabaseConnection connection;
    private final Project project;
    private final PersistenceUnit persistenceUnit;
    private final JavaPersistenceGenerator generator;
    private boolean fullyQualifiedTableNames;
    private EntityRelation.CollectionType collectionType;
    private boolean regenTableAttrs;
    private EntityRelation.FetchType fetchType;
    private SchemaElement schemaElement;

    public EntitiesFromDBGenerator(List<String> list, boolean bl, boolean bl2, boolean bl3, EntityRelation.FetchType fetchType, EntityRelation.CollectionType collectionType, String string, SourceGroup sourceGroup, DatabaseConnection databaseConnection, Project project, PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"tableNames", list);
        Parameters.notNull((CharSequence)"packageName", (Object)string);
        Parameters.notNull((CharSequence)"location", (Object)sourceGroup);
        Parameters.notNull((CharSequence)"connection", (Object)databaseConnection);
        this.tableNames = list;
        this.generateNamedQueries = bl;
        this.fullyQualifiedTableNames = bl2;
        this.regenTableAttrs = bl3;
        this.fetchType = fetchType;
        this.collectionType = collectionType;
        this.packageName = string;
        this.location = sourceGroup;
        this.connection = databaseConnection;
        this.project = project;
        this.persistenceUnit = persistenceUnit;
        this.generator = new JavaPersistenceGenerator(persistenceUnit);
    }

    public EntitiesFromDBGenerator(List<String> list, boolean bl, String string, SourceGroup sourceGroup, DatabaseConnection databaseConnection, Project project, PersistenceUnit persistenceUnit) {
        this(list, bl, false, false, EntityRelation.FetchType.DEFAULT, EntityRelation.CollectionType.COLLECTION, string, sourceGroup, databaseConnection, project, persistenceUnit);
    }

    public Set<FileObject> generate(ProgressContributor progressContributor) throws SQLException, IOException {
        Object object;
        RelatedCMPHelper relatedCMPHelper = new RelatedCMPHelper(this.project, PersistenceLocation.getLocation((Project)this.project), this.generator);
        relatedCMPHelper.setLocation(this.location);
        relatedCMPHelper.setPackageName(this.packageName);
        try {
            object = this.getTableClosure();
            SelectedTables selectedTables = new SelectedTables(this.generator, (TableClosure)object, this.location, this.packageName);
            relatedCMPHelper.setTableClosure((TableClosure)object);
            relatedCMPHelper.setTableSource(this.getSchemaElement(), null);
            relatedCMPHelper.setSelectedTables(selectedTables);
            relatedCMPHelper.setGenerateFinderMethods(this.generateNamedQueries);
            relatedCMPHelper.setFullyQualifiedTableNames(this.fullyQualifiedTableNames);
            relatedCMPHelper.setRegenTablesAttrs(this.regenTableAttrs);
            relatedCMPHelper.setFetchType(this.fetchType);
            relatedCMPHelper.setCollectionType(this.collectionType);
            relatedCMPHelper.buildBeans();
        }
        catch (DBException dBException) {
            IOException iOException = new IOException(dBException.getMessage());
            iOException.initCause(dBException);
            throw iOException;
        }
        this.generator.generateBeans(null, relatedCMPHelper, null, progressContributor);
        object = this.generator.createdObjects();
        return object;
    }

    private TableClosure getTableClosure() throws SQLException, DBException {
        DBSchemaTableProvider dBSchemaTableProvider = new DBSchemaTableProvider(this.getSchemaElement(), this.generator);
        HashSet<Table> hashSet = new HashSet<Table>();
        for (Table table : dBSchemaTableProvider.getTables()) {
            if (!this.tableNames.contains(table.getName())) continue;
            hashSet.add(table);
        }
        TableClosure tableClosure = new TableClosure(dBSchemaTableProvider);
        tableClosure.addTables(hashSet);
        return tableClosure;
    }

    private SchemaElement getSchemaElement() throws SQLException, DBException {
        if (this.schemaElement != null) {
            return this.schemaElement;
        }
        ConnectionProvider connectionProvider = this.getConnectionProvider();
        SchemaElementImpl schemaElementImpl = new SchemaElementImpl(connectionProvider);
        this.schemaElement = new SchemaElement((SchemaElement.Impl)schemaElementImpl);
        this.schemaElement.setName(DBIdentifier.create((String)"schema"));
        schemaElementImpl.initTables(connectionProvider, new LinkedList<String>(this.tableNames), new LinkedList(), true);
        return this.schemaElement;
    }

    private ConnectionProvider getConnectionProvider() throws SQLException {
        ConnectionProvider connectionProvider = new ConnectionProvider(this.connection.getJDBCConnection(), this.connection.getDriverClass());
        connectionProvider.setSchema(this.connection.getSchema());
        return connectionProvider;
    }
}

