/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Iterator;
import org.netbeans.tax.TreeAttlistDecl;
import org.netbeans.tax.TreeAttlistDeclAttributeDef;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCDATASection;
import org.netbeans.tax.TreeCharacterReference;
import org.netbeans.tax.TreeComment;
import org.netbeans.tax.TreeConditionalSection;
import org.netbeans.tax.TreeDTD;
import org.netbeans.tax.TreeDocument;
import org.netbeans.tax.TreeDocumentFragment;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeEntityDecl;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeGeneralEntityReference;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeNotationDecl;
import org.netbeans.tax.TreeParameterEntityReference;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeProcessingInstruction;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.io.TreeOutputResult;
import org.netbeans.tax.io.TreeWriter;
import org.netbeans.tax.spec.AttlistDecl;
import org.netbeans.tax.spec.Attribute;
import org.netbeans.tax.spec.CDATASection;
import org.netbeans.tax.spec.CharacterReference;
import org.netbeans.tax.spec.Comment;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.Document;
import org.netbeans.tax.spec.DocumentFragment;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.Element;
import org.netbeans.tax.spec.ElementDecl;
import org.netbeans.tax.spec.EntityDecl;
import org.netbeans.tax.spec.GeneralEntityReference;
import org.netbeans.tax.spec.NotationDecl;
import org.netbeans.tax.spec.ParameterEntityReference;
import org.netbeans.tax.spec.ProcessingInstruction;
import org.netbeans.tax.spec.Text;

public class TreeStreamResult
implements TreeOutputResult {
    private TreeStreamWriter writer;

    public TreeStreamResult(OutputStream outputStream) {
        this.writer = new TreeStreamWriter(outputStream);
    }

    public TreeStreamResult(StringWriter stringWriter) {
        this.writer = new TreeStreamWriter(stringWriter);
    }

    public TreeStreamResult(PipedWriter pipedWriter) {
        this.writer = new TreeStreamWriter(pipedWriter);
    }

    public final TreeWriter getWriter(TreeDocumentRoot treeDocumentRoot) {
        this.writer.setDocument(treeDocumentRoot);
        return this.writer;
    }

    public static final class TreeStreamWriter
    implements TreeWriter,
    AttlistDecl.Writer,
    Attribute.Writer,
    CDATASection.Writer,
    CharacterReference.Writer,
    Comment.Writer,
    ConditionalSection.Writer,
    DocumentFragment.Writer,
    Document.Writer,
    DocumentType.Writer,
    DTD.Writer,
    ElementDecl.Writer,
    Element.Writer,
    EntityDecl.Writer,
    GeneralEntityReference.Writer,
    NotationDecl.Writer,
    ParameterEntityReference.Writer,
    ProcessingInstruction.Writer,
    Text.Writer {
        private static final char LESS_THAN = '<';
        private static final char GREAT_THAN = '>';
        private static final char AMPERSAND = '&';
        private static final char SEMICOLON = ';';
        private static final char APOSTROPHE = '\'';
        private static final char QUOTE = '\"';
        private static final char PER_CENT = '%';
        private static final char ASSIGN = '=';
        private static final char BRACKET_LEFT = '[';
        private static final char SPACE = ' ';
        private static final String PI_START = "<?";
        private static final String PI_END = "?>";
        private static final String COMMENT_START = "<!--";
        private static final String COMMENT_END = "-->";
        private static final String ELEMENT_EMPTY_END = " />";
        private static final String ELEMENT_END_START = "</";
        private static final String CDATA_START = "<![CDATA[";
        private static final String CDATA_END = "]]>";
        private static final String DOCTYPE_START = "<!DOCTYPE ";
        private static final String DOCTYPE_INTERN_END = "]]>";
        private static final String CHAR_REF_START = "&#";
        private static final String CHAR_REF_HEX_START = "&#x";
        private static final String ELEMENT_DECL_START = "<!ELEMENT ";
        private static final String ATTLIST_DECL_START = "<!ATTLIST ";
        private static final String ENTITY_DECL_START = "<!ENTITY ";
        private static final String NOTATION_DECL_START = "<!NOTATION ";
        private static final String XML_HEADER = "<?xml ";
        private static final String XML_VERSION = "version";
        private static final String XML_ENCODING = "encoding";
        private static final String XML_STANDALONE = "standalone";
        private static final String PUBLIC = "PUBLIC ";
        private static final String SYSTEM = "SYSTEM ";
        private OutputStream outputStream;
        private Writer writer;
        private TreeDocumentRoot document;
        private int indent = 0;
        private int indent_step = 4;

        public TreeStreamWriter(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public TreeStreamWriter(StringWriter stringWriter) {
            this.writer = stringWriter;
        }

        public TreeStreamWriter(PipedWriter pipedWriter) {
            this.writer = pipedWriter;
        }

        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        public Writer getWriter() {
            return this.writer;
        }

        public void setDocument(TreeDocumentRoot treeDocumentRoot) {
            this.document = treeDocumentRoot;
        }

        public void writeDocument() throws TreeException {
            String string = this.document.getEncoding();
            if (this.outputStream != null) {
                try {
                    if (string != null) {
                        string = TreeUtilities.iana2java(string);
                    }
                    this.writer = string == null ? new OutputStreamWriter(this.outputStream) : new OutputStreamWriter(this.outputStream, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new TreeException(unsupportedEncodingException);
                }
            }
            this.writeNode((TreeNode)((Object)this.document));
            try {
                this.writer.flush();
            }
            catch (IOException iOException) {
                throw new TreeException(iOException);
            }
        }

        public void writeNode(TreeNode treeNode) throws TreeException {
            if (treeNode instanceof TreeAttlistDecl) {
                this.writeAttlistDecl((TreeAttlistDecl)treeNode);
            } else if (treeNode instanceof TreeAttribute) {
                this.writeAttribute((TreeAttribute)treeNode);
            } else if (treeNode instanceof TreeCDATASection) {
                this.writeCDATASection((TreeCDATASection)treeNode);
            } else if (treeNode instanceof TreeCharacterReference) {
                this.writeCharacterReference((TreeCharacterReference)treeNode);
            } else if (treeNode instanceof TreeComment) {
                this.writeComment((TreeComment)treeNode);
            } else if (treeNode instanceof TreeConditionalSection) {
                this.writeConditionalSection((TreeConditionalSection)treeNode);
            } else if (treeNode instanceof TreeDocumentFragment) {
                this.writeDocumentFragment((TreeDocumentFragment)treeNode);
            } else if (treeNode instanceof TreeDocument) {
                this.writeDocument((TreeDocument)treeNode);
            } else if (treeNode instanceof TreeDocumentType) {
                this.writeDocumentType((TreeDocumentType)treeNode);
            } else if (treeNode instanceof TreeDTD) {
                this.writeDTD((TreeDTD)treeNode);
            } else if (treeNode instanceof TreeElementDecl) {
                this.writeElementDecl((TreeElementDecl)treeNode);
            } else if (treeNode instanceof TreeElement) {
                this.writeElement((TreeElement)treeNode);
            } else if (treeNode instanceof TreeEntityDecl) {
                this.writeEntityDecl((TreeEntityDecl)treeNode);
            } else if (treeNode instanceof TreeGeneralEntityReference) {
                this.writeGeneralEntityReference((TreeGeneralEntityReference)treeNode);
            } else if (treeNode instanceof TreeNotationDecl) {
                this.writeNotationDecl((TreeNotationDecl)treeNode);
            } else if (treeNode instanceof TreeParameterEntityReference) {
                this.writeParameterEntityReference((TreeParameterEntityReference)treeNode);
            } else if (treeNode instanceof TreeProcessingInstruction) {
                this.writeProcessingInstruction((TreeProcessingInstruction)treeNode);
            } else if (treeNode instanceof TreeText) {
                this.writeText((TreeText)treeNode);
            }
        }

        public void writeAttlistDecl(TreeAttlistDecl treeAttlistDecl) throws TreeException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ATTLIST_DECL_START).append(treeAttlistDecl.getElementName());
            TreeNamedObjectMap treeNamedObjectMap = treeAttlistDecl.getAttributeDefs();
            Iterator iterator = treeNamedObjectMap.iterator();
            while (iterator.hasNext()) {
                TreeAttlistDeclAttributeDef treeAttlistDeclAttributeDef = (TreeAttlistDeclAttributeDef)iterator.next();
                stringBuffer.append("\n\t").append(treeAttlistDeclAttributeDef.getName()).append(' ');
                if (treeAttlistDeclAttributeDef.getType() != 8) {
                    stringBuffer.append(treeAttlistDeclAttributeDef.getTypeName()).append(' ');
                }
                if (treeAttlistDeclAttributeDef.getType() == 8 || treeAttlistDeclAttributeDef.getType() == 9) {
                    stringBuffer.append(treeAttlistDeclAttributeDef.getEnumeratedTypeString()).append(' ');
                }
                if (treeAttlistDeclAttributeDef.getDefaultType() != 0) {
                    stringBuffer.append(treeAttlistDeclAttributeDef.getDefaultTypeName()).append(' ');
                }
                if (treeAttlistDeclAttributeDef.getDefaultType() != 3 && treeAttlistDeclAttributeDef.getDefaultType() != 0) continue;
                stringBuffer.append("\"").append(treeAttlistDeclAttributeDef.getDefaultValue()).append("\"");
            }
            stringBuffer.append('>');
            this.write(stringBuffer.toString());
        }

        public void writeAttribute(TreeAttribute treeAttribute) throws TreeException {
            if (!treeAttribute.isSpecified()) {
                return;
            }
            this.write(this.createValueString(treeAttribute.getQName(), treeAttribute.getNonNormalizedValue()));
        }

        public void writeCDATASection(TreeCDATASection treeCDATASection) throws TreeException {
            String string = treeCDATASection.getData();
            String string2 = MessageFormat.format("<![CDATA[{0}]]>", string);
            this.write(string2);
        }

        public void writeCharacterReference(TreeCharacterReference treeCharacterReference) throws TreeException {
            String string = treeCharacterReference.getName();
            String string2 = MessageFormat.format("&{0};", string);
            this.write(string2);
        }

        public void writeComment(TreeComment treeComment) throws TreeException {
            String string = treeComment.getData();
            String string2 = MessageFormat.format("<!--{0}-->", string);
            this.write(string2);
        }

        public void writeConditionalSection(TreeConditionalSection treeConditionalSection) throws TreeException {
            if (treeConditionalSection.isInclude()) {
                this.write("<![ INCLUDE [\n");
                this.writeObjectList(treeConditionalSection);
            } else {
                this.write("<![ IGNORE [");
                this.write(treeConditionalSection.getIgnoredContent());
            }
            this.write("]]>");
        }

        public void writeDocumentFragment(TreeDocumentFragment treeDocumentFragment) throws TreeException {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = null;
            if (treeDocumentFragment.getVersion() != null) {
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer();
                }
                stringBuffer2.append(this.createValueString(XML_VERSION, treeDocumentFragment.getVersion())).append(' ');
            }
            if (treeDocumentFragment.getEncoding() != null) {
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer();
                }
                stringBuffer2.append(this.createValueString(XML_ENCODING, treeDocumentFragment.getEncoding()));
            }
            if (stringBuffer2 != null) {
                stringBuffer.append(XML_HEADER).append(stringBuffer2).append(PI_END);
            }
            this.write(stringBuffer.toString() + "\n\n");
            this.indent -= this.indent_step;
            this.writeObjectList(treeDocumentFragment);
        }

        public void writeDocument(TreeDocument treeDocument) throws TreeException {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = null;
            if (treeDocument.getVersion() != null) {
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer();
                }
                stringBuffer2.append(this.createValueString(XML_VERSION, treeDocument.getVersion()));
            }
            if (treeDocument.getEncoding() != null) {
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer();
                }
                stringBuffer2.append(' ').append(this.createValueString(XML_ENCODING, treeDocument.getEncoding()));
            }
            if (treeDocument.getStandalone() != null) {
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer();
                }
                stringBuffer2.append(' ').append(this.createValueString(XML_STANDALONE, treeDocument.getStandalone()));
            }
            if (stringBuffer2 != null) {
                stringBuffer.append(XML_HEADER).append(stringBuffer2).append(PI_END);
            }
            this.write(stringBuffer.toString() + "\n");
            this.indent -= this.indent_step;
            this.writeObjectList(treeDocument);
        }

        public void writeDocumentType(TreeDocumentType treeDocumentType) throws TreeException {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(DOCTYPE_START).append(treeDocumentType.getElementName());
            if (treeDocumentType.getPublicId() != null) {
                stringBuffer.append(' ').append(PUBLIC);
                stringBuffer.append(this.createQuoteString(treeDocumentType.getPublicId())).append(' ');
                object = treeDocumentType.getSystemId();
                stringBuffer.append(this.createQuoteString((String)(object == null ? "" : object)));
            } else if (treeDocumentType.getSystemId() != null) {
                stringBuffer.append(' ').append(SYSTEM);
                stringBuffer.append(this.createQuoteString(treeDocumentType.getSystemId()));
            }
            this.write(stringBuffer.toString());
            if (treeDocumentType.hasChildNodes()) {
                this.write(" [");
                try {
                    if (treeDocumentType == null) {
                        return;
                    }
                    object = treeDocumentType.getClass();
                    Field field = ((Class)object).getDeclaredField("internalDTDText");
                    field.setAccessible(true);
                    String string = (String)field.get(treeDocumentType);
                    if (string != null) {
                        this.write(string);
                    } else {
                        this.write("\n");
                        this.writeObjectList(treeDocumentType);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    this.write("\n");
                    this.writeObjectList(treeDocumentType);
                }
                this.write("]");
            }
            this.write('>');
        }

        public void writeDTD(TreeDTD treeDTD) throws TreeException {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = null;
            if (treeDTD.getVersion() != null) {
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer();
                }
                stringBuffer2.append(this.createValueString(XML_VERSION, treeDTD.getVersion())).append(' ');
            }
            if (treeDTD.getEncoding() != null) {
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer();
                }
                stringBuffer2.append(this.createValueString(XML_ENCODING, treeDTD.getEncoding()));
            }
            if (stringBuffer2 != null) {
                stringBuffer.append(XML_HEADER).append(stringBuffer2).append(PI_END);
            }
            this.write(stringBuffer.toString() + "\n\n");
            this.indent -= this.indent_step;
            this.writeObjectList(treeDTD);
        }

        public void writeElementDecl(TreeElementDecl treeElementDecl) throws TreeException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ELEMENT_DECL_START).append(treeElementDecl.getName()).append(' ');
            stringBuffer.append(treeElementDecl.getContentType().toString());
            stringBuffer.append('>');
            this.write(stringBuffer.toString());
        }

        public void writeElement(TreeElement treeElement) throws TreeException {
            Object object;
            String string = treeElement.getQName();
            this.write("<" + string);
            Iterator iterator = treeElement.getAttributes().iterator();
            while (iterator.hasNext()) {
                object = (TreeAttribute)iterator.next();
                if (!((TreeAttribute)object).isSpecified()) continue;
                this.write(' ');
                this.writeAttribute((TreeAttribute)object);
            }
            if (treeElement.isEmpty()) {
                this.write("/>");
            } else {
                this.write(">");
                this.writeObjectList(treeElement);
                object = MessageFormat.format("</{0}>", string);
                this.write((String)object);
            }
        }

        public void writeEntityDecl(TreeEntityDecl treeEntityDecl) throws TreeException {
            String string = treeEntityDecl.isParameter() ? "% " : "";
            String string2 = treeEntityDecl.getName();
            String string3 = "";
            switch (treeEntityDecl.getType()) {
                case 1: {
                    string3 = "\"" + treeEntityDecl.getInternalText() + "\"";
                    break;
                }
                case 2: {
                    string3 = this.createExternalIdString(treeEntityDecl.getPublicId(), treeEntityDecl.getSystemId());
                    break;
                }
                case 3: {
                    string3 = this.createExternalIdString(treeEntityDecl.getPublicId(), treeEntityDecl.getSystemId()) + " NDATA " + treeEntityDecl.getNotationName();
                }
            }
            String string4 = MessageFormat.format("<!ENTITY {0}{1} {2}>", string, string2, string3);
            this.write(string4);
        }

        public void writeGeneralEntityReference(TreeGeneralEntityReference treeGeneralEntityReference) throws TreeException {
            String string = treeGeneralEntityReference.getName();
            String string2 = MessageFormat.format("&{0};", string);
            this.write(string2);
        }

        public void writeNotationDecl(TreeNotationDecl treeNotationDecl) throws TreeException {
            String string = treeNotationDecl.getName();
            String string2 = treeNotationDecl.getSystemId();
            String string3 = treeNotationDecl.getPublicId();
            String string4 = this.createExternalIdString(string3, string2);
            String string5 = MessageFormat.format("<!NOTATION {0} {1}>", string, string4);
            this.write(string5);
        }

        public void writeParameterEntityReference(TreeParameterEntityReference treeParameterEntityReference) throws TreeException {
            String string = treeParameterEntityReference.getName();
            String string2 = MessageFormat.format("%{0};", string);
            this.write(string2);
        }

        public void writeProcessingInstruction(TreeProcessingInstruction treeProcessingInstruction) throws TreeException {
            String string = treeProcessingInstruction.getTarget();
            String string2 = treeProcessingInstruction.getData();
            String string3 = MessageFormat.format("<?{0} {1}?>", string, string2);
            this.write(string3);
        }

        public void writeText(TreeText treeText) throws TreeException {
            String string = treeText.getData();
            this.write(string);
        }

        private void write(String string) throws TreeException {
            try {
                this.writer.write(string);
            }
            catch (IOException iOException) {
                throw new TreeException(iOException);
            }
        }

        private void write(char c) throws TreeException {
            try {
                this.writer.write(c);
            }
            catch (IOException iOException) {
                throw new TreeException(iOException);
            }
        }

        private void startIndent() throws TreeException {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.indent; ++i) {
                stringBuffer.append(' ');
            }
            try {
                this.writer.write(stringBuffer.toString());
            }
            catch (IOException iOException) {
                throw new TreeException(iOException);
            }
        }

        private void endIndent() throws TreeException {
            this.write("\n");
        }

        private void writeObjectList(TreeParentNode treeParentNode) throws TreeException {
            this.indent += this.indent_step;
            boolean bl = !(treeParentNode instanceof TreeElement);
            boolean bl2 = treeParentNode instanceof TreeDocument;
            Iterator iterator = treeParentNode.getChildNodes().iterator();
            while (iterator.hasNext()) {
                TreeNode treeNode = (TreeNode)iterator.next();
                if (bl) {
                    this.startIndent();
                }
                this.writeNode(treeNode);
                if (!bl) continue;
                this.endIndent();
            }
            this.indent -= this.indent_step;
        }

        private String createValueString(String string, String string2) {
            String string3 = MessageFormat.format("{0}={1}", string, this.createQuoteString(string2));
            return string3;
        }

        private String createQuoteString(String string) {
            Character c = new Character('\"');
            if (string.indexOf(34) != -1) {
                c = new Character('\'');
            }
            return this.createQuoteString(string, c);
        }

        private String createQuoteString(String string, Character c) {
            String string2 = MessageFormat.format("{1}{0}{1}", string, c);
            return string2;
        }

        private String createExternalIdString(String string, String string2) {
            String string3 = string == null ? MessageFormat.format("SYSTEM {0}", this.createQuoteString(string2)) : (string2 == null ? MessageFormat.format("PUBLIC {0}", this.createQuoteString(string)) : MessageFormat.format("PUBLIC {0} {1}", this.createQuoteString(string), this.createQuoteString(string2)));
            return string3;
        }
    }
}

