/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.tax.event.TreeEvent;
import org.netbeans.tax.event.TreeEventChangeSupport;

public final class TreeEventManager {
    public static final short FIRE_NOW = 1;
    public static final short FIRE_LATER = 2;
    private short firePolicy;
    private Set cachedSupports = new HashSet();

    public TreeEventManager(short s) {
        this.firePolicy = s;
    }

    public TreeEventManager() {
        this(1);
    }

    public TreeEventManager(TreeEventManager treeEventManager) {
        this.firePolicy = treeEventManager.firePolicy;
    }

    public final short getFirePolicy() {
        return this.firePolicy;
    }

    public final void setFirePolicy(short s) {
        if (this.firePolicy == s) {
            return;
        }
        this.firePolicy = s;
        if (s == 1) {
            this.fireCached();
        }
    }

    private void fireCached() {
        Iterator iterator = this.cachedSupports.iterator();
        while (iterator.hasNext()) {
            TreeEventChangeSupport treeEventChangeSupport = (TreeEventChangeSupport)iterator.next();
            treeEventChangeSupport.firePropertyChangeCache();
            iterator.remove();
        }
    }

    private void addToCache(TreeEventChangeSupport treeEventChangeSupport) {
        this.cachedSupports.add(treeEventChangeSupport);
    }

    public final void firePropertyChange(TreeEventChangeSupport treeEventChangeSupport, TreeEvent treeEvent) {
        if (this.firePolicy == 1) {
            treeEventChangeSupport.firePropertyChangeCache();
            treeEventChangeSupport.firePropertyChangeNow(treeEvent);
            return;
        }
        if (this.firePolicy == 2) {
            treeEventChangeSupport.firePropertyChangeLater(treeEvent);
            this.addToCache(treeEventChangeSupport);
            return;
        }
    }
}

