/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCharacterData;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeData;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNamespace;
import org.netbeans.tax.TreeNamespaceContext;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.Document;
import org.netbeans.tax.spec.DocumentFragment;
import org.netbeans.tax.spec.Element;
import org.netbeans.tax.spec.GeneralEntityReference;

public class TreeElement
extends TreeParentNode
implements Document.Child,
DocumentFragment.Child,
Element.Child,
GeneralEntityReference.Child {
    public static final String PROP_TAG_NAME = "tagName";
    public static final String PROP_ATTRIBUTES = "attributes";
    private TreeName tagName;
    private TreeNamespaceContext namespaceContext;
    private TreeNamedObjectMap attributes;
    private boolean empty;
    private boolean containsCharacterData;
    static /* synthetic */ Class class$org$netbeans$tax$spec$Element$Child;
    static /* synthetic */ Class class$org$netbeans$tax$spec$Element$Attribute;

    public TreeElement(String string, boolean bl) throws InvalidArgumentException {
        TreeName treeName = new TreeName(string);
        this.checkTagName(treeName);
        this.tagName = treeName;
        this.empty = bl;
        this.containsCharacterData = false;
        this.namespaceContext = new TreeNamespaceContext(this);
        this.attributes = new TreeNamedObjectMap(this.createAttributesContentManager());
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeElement:: : name = " + string + " : empty = " + bl);
        }
    }

    public TreeElement(String string) throws InvalidArgumentException {
        this(string, false);
    }

    protected TreeElement(TreeElement treeElement, boolean bl) {
        super(treeElement, bl);
        this.tagName = treeElement.tagName;
        this.empty = treeElement.empty;
        this.namespaceContext = new TreeNamespaceContext(this);
        this.attributes = new TreeNamedObjectMap(this.createAttributesContentManager());
        this.attributes.addAll((Collection)((TreeNamedObjectMap)treeElement.attributes.clone()));
    }

    public Object clone(boolean bl) {
        return new TreeElement(this, bl);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeElement treeElement = (TreeElement)object;
        if (this.empty != treeElement.empty) {
            return false;
        }
        if (!Util.equals(this.getTreeName(), treeElement.getTreeName())) {
            return false;
        }
        return Util.equals(this.getAttributes(), treeElement.getAttributes());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeElement treeElement = (TreeElement)treeObject;
        this.empty = this.empty || treeElement.empty;
        try {
            this.setTreeName(treeElement.getTreeName());
        }
        catch (Exception exception) {
            throw new CannotMergeException(treeObject, exception);
        }
        this.attributes.merge(treeElement.getAttributes());
    }

    protected void setReadOnly(boolean bl) {
        super.setReadOnly(bl);
        this.attributes.setReadOnly(bl);
    }

    public final String getQName() {
        return this.tagName.getQualifiedName();
    }

    public final void setQName(String string) throws ReadOnlyException, InvalidArgumentException {
        this.setTreeName(new TreeName(string));
    }

    public final TreeName getTreeName() {
        return this.tagName;
    }

    private final void setTreeNameImpl(TreeName treeName) {
        TreeName treeName2 = this.tagName;
        this.tagName = treeName;
        this.firePropertyChange(PROP_TAG_NAME, treeName2, treeName);
    }

    public final void setTreeName(TreeName treeName) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.tagName, treeName)) {
            return;
        }
        this.checkReadOnly();
        this.checkTagName(treeName);
        this.setTreeNameImpl(treeName);
    }

    public boolean isEmpty() {
        if (!this.empty) {
            return false;
        }
        return this.getChildNodes().size() == 0;
    }

    protected final void checkTagName(TreeName treeName) throws InvalidArgumentException {
        TreeUtilities.checkElementTagName(treeName);
    }

    protected final TreeNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public final TreeNamespace getNamespace() {
        String string = this.getNamespacePrefix();
        String string2 = this.namespaceContext.getURI(string);
        if (string2 == null) {
            return TreeNamespace.NO_NAMESPACE;
        }
        return new TreeNamespace(string, string2);
    }

    public final String getNamespacePrefix() {
        return this.tagName.getPrefix();
    }

    public final String getNamespaceURI() {
        return this.getNamespace().getURI();
    }

    public final String getLocalName() {
        return this.tagName.getName();
    }

    public final int getAttributesNumber() {
        return this.attributes.size();
    }

    public final boolean hasAttributes() {
        return this.attributes.size() != 0;
    }

    public final boolean hasAttribute(String string) {
        return this.getAttribute(string) != null;
    }

    public final TreeNamedObjectMap getAttributes() {
        return this.attributes;
    }

    public final TreeAttribute getAttribute(String string) {
        try {
            TreeName treeName = new TreeName(string);
            return (TreeAttribute)this.attributes.get(treeName);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            return null;
        }
    }

    public final TreeAttribute addAttribute(String string, String string2) throws ReadOnlyException, InvalidArgumentException {
        this.checkReadOnly();
        TreeAttribute treeAttribute = new TreeAttribute(string, string2);
        TreeAttribute treeAttribute2 = this.removeAttribute(string);
        this.attributes.add(treeAttribute);
        return treeAttribute2;
    }

    public final void addAttribute(TreeAttribute treeAttribute) throws ReadOnlyException, InvalidArgumentException {
        String string = treeAttribute.getQName();
        this.checkReadOnly();
        TreeAttribute treeAttribute2 = this.removeAttribute(string);
        this.attributes.add(treeAttribute);
    }

    public final TreeAttribute removeAttribute(String string) throws ReadOnlyException {
        return this.removeAttribute(this.getAttribute(string));
    }

    public final TreeAttribute removeAttribute(TreeAttribute treeAttribute) throws ReadOnlyException {
        this.checkReadOnly();
        this.attributes.remove(treeAttribute);
        return treeAttribute;
    }

    public final void removeAttributes() throws ReadOnlyException {
        this.checkReadOnly();
        this.attributes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void normalize() throws ReadOnlyException {
        this.checkReadOnly();
        try {
            try {
                this.getChildNodes().getEventManager().setFirePolicy((short)2);
                int n = 0;
                while (true) {
                    TreeChild treeChild;
                    if ((treeChild = this.item(n)) instanceof TreeElement) {
                        ((TreeElement)treeChild).normalize();
                    } else if (treeChild instanceof TreeText) {
                        TreeChild treeChild2;
                        while ((treeChild2 = this.item(n + 1)) instanceof TreeText) {
                            try {
                                ((TreeText)treeChild).appendData(((TreeText)treeChild2).getData());
                                this.removeChild(treeChild2);
                            }
                            catch (InvalidArgumentException invalidArgumentException) {
                                break;
                            }
                        }
                    }
                    ++n;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.getChildNodes().getEventManager().setFirePolicy((short)1);
            }
        }
        catch (Throwable throwable) {
            this.getChildNodes().getEventManager().setFirePolicy((short)1);
            throw throwable;
        }
    }

    public final boolean containsCharacterData() {
        return this.containsCharacterData;
    }

    private void updateContainsCharacterData() {
        Iterator iterator = this.getChildNodes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TreeCharacterData)) continue;
            TreeCharacterData treeCharacterData = (TreeCharacterData)e;
            if (treeCharacterData instanceof TreeData) {
                if (!((TreeData)((Object)treeCharacterData)).onlyWhiteSpaces()) {
                    this.containsCharacterData = true;
                }
            } else {
                this.containsCharacterData = true;
            }
            if (!this.containsCharacterData) continue;
            return;
        }
        this.containsCharacterData = false;
    }

    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    protected TreeNamedObjectMap.ContentManager createAttributesContentManager() {
        return new AttributesContentManager();
    }

    protected class AttributesContentManager
    extends TreeNamedObjectMap.ContentManager {
        protected AttributesContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeElement.this;
        }

        public void checkAssignableObject(Object object) {
            this.checkAssignableClass(class$org$netbeans$tax$spec$Element$Attribute == null ? (class$org$netbeans$tax$spec$Element$Attribute = TreeElement.class$("org.netbeans.tax.spec.Element$Attribute")) : class$org$netbeans$tax$spec$Element$Attribute, object);
        }

        public void objectInserted(TreeObject treeObject) {
            ((TreeAttribute)treeObject).setOwnerElement(TreeElement.this);
            TreeElement.this.firePropertyChange(TreeElement.PROP_ATTRIBUTES, TreeElement.this.attributes, null);
        }

        public void objectRemoved(TreeObject treeObject) {
            ((TreeAttribute)treeObject).setOwnerElement(null);
            TreeElement.this.firePropertyChange(TreeElement.PROP_ATTRIBUTES, TreeElement.this.attributes, null);
        }

        public void orderChanged(int[] nArray) {
            TreeElement.this.firePropertyChange(TreeElement.PROP_ATTRIBUTES, TreeElement.this.attributes, null);
        }
    }

    protected class ChildListContentManager
    extends TreeParentNode.ChildListContentManager {
        protected ChildListContentManager() {
            super(TreeElement.this);
        }

        public TreeNode getOwnerNode() {
            return TreeElement.this;
        }

        public void checkAssignableObject(Object object) {
            super.checkAssignableObject(object);
            this.checkAssignableClass(class$org$netbeans$tax$spec$Element$Child == null ? (class$org$netbeans$tax$spec$Element$Child = TreeElement.class$("org.netbeans.tax.spec.Element$Child")) : class$org$netbeans$tax$spec$Element$Child, object);
        }
    }
}

