/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation.EntityMappingsUtilities;

public final class AttributesHelper {
    private final TypeElement typeElement;
    private final AnnotationModelHelper helper;
    private final PropertyHandler propertyHandler;
    private final boolean fieldAccess;

    public AttributesHelper(AnnotationModelHelper annotationModelHelper, TypeElement typeElement, PropertyHandler propertyHandler) {
        this.helper = annotationModelHelper;
        this.typeElement = typeElement;
        this.propertyHandler = propertyHandler;
        if (typeElement == null) {
            this.fieldAccess = true;
            return;
        }
        List<? extends Element> list = typeElement.getEnclosedElements();
        this.fieldAccess = EntityMappingsUtilities.hasFieldAccess(annotationModelHelper, list);
    }

    public void parse() {
        if (this.typeElement == null) {
            return;
        }
        for (Element element : this.typeElement.getEnclosedElements()) {
            ElementKind elementKind = element.getKind();
            if (this.fieldAccess) {
                if (!ElementKind.FIELD.equals((Object)elementKind)) continue;
                this.handleProperty(element);
                continue;
            }
            if (!ElementKind.METHOD.equals((Object)elementKind)) continue;
            this.handleProperty(element);
        }
    }

    private void handleProperty(Element element) {
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        String string = element.getSimpleName().toString();
        if (ElementKind.METHOD.equals((Object)element.getKind()) && (string = EntityMappingsUtilities.getterNameToPropertyName(string)) == null) {
            return;
        }
        this.propertyHandler.handleProperty(element, string);
    }

    public boolean hasFieldAccess() {
        return this.fieldAccess;
    }

    public static interface PropertyHandler {
        public void handleProperty(Element var1, String var2);
    }
}

