/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.math.BigInteger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.common.RunAs;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.InitParamTableModel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.InitParamsPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.RunAsPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleRefTableModel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleRefTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.LinkButton;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ServletPanel
extends SectionInnerPanel
implements ActionListener {
    private DDDataObject dObj;
    private Servlet servlet;
    private JButton linkServletClass;
    private JButton linkJspFile;
    private InitParamsPanel initParamsPanel;
    private JComboBox runAsCB;
    private JButton browseButton;
    private JButton browseButton1;
    private ButtonGroup buttonGroup1;
    private JLabel descriptionLabel;
    private JTextArea descriptionTA;
    private JPanel filler;
    private JLabel initParamsLabel;
    private JLabel jLabel1;
    private JRadioButton jspFileRB;
    private JTextField jspFileTF;
    private JLabel orderLabel;
    private JTextField orderTF;
    private JRadioButton servletClassRB;
    private JTextField servletClassTF;
    private JLabel servletMappingLabel;
    private JTextField servletMappingsTF;
    private JLabel servletNameLabel;
    private JTextField servletNameTF;

    public ServletPanel(SectionView sectionView, DDDataObject dDDataObject, Servlet servlet) {
        super(sectionView);
        this.dObj = dDDataObject;
        this.servlet = servlet;
        this.initComponents();
        this.servletNameTF.setText(servlet.getServletName());
        this.addValidatee(this.servletNameTF);
        Utils.makeTextAreaLikeTextField((JTextArea)this.descriptionTA, (JTextField)this.servletNameTF);
        this.descriptionTA.setText(servlet.getDefaultDescription());
        this.addModifier(this.descriptionTA);
        BigInteger bigInteger = servlet.getLoadOnStartup();
        this.orderTF.setText(bigInteger == null ? "" : bigInteger.toString());
        this.addValidatee(this.orderTF);
        String string = servlet.getJspFile();
        if (string != null) {
            this.jspFileRB.setSelected(true);
            this.servletClassTF.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.jspFileTF.setText(string);
        } else {
            this.servletClassRB.setSelected(true);
            this.jspFileTF.setEnabled(false);
            this.browseButton1.setEnabled(false);
            this.servletClassTF.setText(servlet.getServletClass());
        }
        this.servletClassRB.addActionListener(this);
        this.jspFileRB.addActionListener(this);
        this.addValidatee(this.servletClassTF);
        this.addValidatee(this.jspFileTF);
        String[] stringArray = DDUtils.getUrlPatterns(dDDataObject.getWebApp(), servlet);
        this.servletMappingsTF.setText(DDUtils.urlPatternList(stringArray));
        this.addValidatee(this.servletMappingsTF);
        InitParamTableModel initParamTableModel = new InitParamTableModel();
        this.initParamsPanel = new InitParamsPanel(dDDataObject, initParamTableModel);
        this.initParamsPanel.setModel(servlet, servlet.getInitParam());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.add((Component)((Object)this.initParamsPanel), gridBagConstraints);
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_SecurityRoleRefs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        this.add(jLabel, gridBagConstraints);
        SecurityRoleRefTableModel securityRoleRefTableModel = new SecurityRoleRefTableModel();
        SecurityRoleRefTablePanel securityRoleRefTablePanel = new SecurityRoleRefTablePanel(dDDataObject, securityRoleRefTableModel);
        securityRoleRefTablePanel.setModel(dDDataObject.getWebApp(), servlet, servlet.getSecurityRoleRef());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.add((Component)((Object)securityRoleRefTablePanel), gridBagConstraints);
        RunAsPanel runAsPanel = new RunAsPanel(dDDataObject.getWebApp());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.add(runAsPanel, gridBagConstraints);
        this.runAsCB = runAsPanel.getRunAsCB();
        RunAs runAs = servlet.getRunAs();
        if (runAs == null) {
            this.runAsCB.setSelectedItem("");
        } else {
            this.runAsCB.setSelectedItem(runAs.getRoleName());
        }
        this.addModifier(this.runAsCB);
        this.linkServletClass = new LinkButton((LinkCookie)this, (Object)servlet, "ClassName");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        Mnemonics.setLocalizedText((AbstractButton)this.linkServletClass, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_goToSource"));
        this.add(this.linkServletClass, gridBagConstraints);
        this.linkJspFile = new LinkButton((LinkCookie)this, (Object)servlet, "JspFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        Mnemonics.setLocalizedText((AbstractButton)this.linkJspFile, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_goToSource_2"));
        this.add(this.linkJspFile, gridBagConstraints);
        this.setAccessibility();
    }

    private void setAccessibility() {
        this.initParamsLabel.setLabelFor(this.initParamsPanel.getTable());
    }

    public void linkButtonPressed(Object object, String string) {
        if ("ClassName".equals(string)) {
            DDUtils.openEditorFor(this.dObj, ((Servlet)object).getServletClass());
        } else if ("JspFile".equals(string)) {
            DDUtils.openEditorForSingleFile(this.dObj, ((Servlet)object).getJspFile());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.servletNameLabel = new JLabel();
        this.servletNameTF = new JTextField();
        this.orderLabel = new JLabel();
        this.orderTF = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTA = new JTextArea();
        this.servletClassRB = new JRadioButton();
        this.servletClassTF = new JTextField();
        this.browseButton = new JButton();
        this.jspFileRB = new JRadioButton();
        this.jspFileTF = new JTextField();
        this.browseButton1 = new JButton();
        this.servletMappingLabel = new JLabel();
        this.servletMappingsTF = new JTextField();
        this.jLabel1 = new JLabel();
        this.initParamsLabel = new JLabel();
        this.filler = new JPanel();
        this.setLayout(new GridBagLayout());
        this.servletNameLabel.setLabelFor(this.servletNameTF);
        Mnemonics.setLocalizedText((JLabel)this.servletNameLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_servletName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.servletNameLabel, gridBagConstraints);
        this.servletNameTF.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.servletNameTF, gridBagConstraints);
        this.orderLabel.setLabelFor(this.orderTF);
        Mnemonics.setLocalizedText((JLabel)this.orderLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_order"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.add(this.orderLabel, gridBagConstraints);
        this.orderTF.setColumns(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.orderTF, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionTA);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.descriptionLabel, gridBagConstraints);
        this.descriptionTA.setRows(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.descriptionTA, gridBagConstraints);
        this.buttonGroup1.add(this.servletClassRB);
        Mnemonics.setLocalizedText((AbstractButton)this.servletClassRB, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_servletClass"));
        this.servletClassRB.setHorizontalTextPosition(4);
        this.servletClassRB.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add(this.servletClassRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.servletClassTF, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_browse"));
        this.browseButton.setMargin(new Insets(0, 14, 0, 14));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServletPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.add(this.browseButton, gridBagConstraints);
        this.buttonGroup1.add(this.jspFileRB);
        Mnemonics.setLocalizedText((AbstractButton)this.jspFileRB, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_jspFile"));
        this.jspFileRB.setHorizontalTextPosition(4);
        this.jspFileRB.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add(this.jspFileRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.jspFileTF, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton1, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_browse_2"));
        this.browseButton1.setMargin(new Insets(0, 14, 0, 14));
        this.browseButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServletPanel.this.browseButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.add(this.browseButton1, gridBagConstraints);
        this.servletMappingLabel.setLabelFor(this.servletMappingsTF);
        Mnemonics.setLocalizedText((JLabel)this.servletMappingLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_urlPatterns"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.servletMappingLabel, gridBagConstraints);
        this.servletMappingsTF.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.servletMappingsTF, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ServletPanel.class, (String)"HINT_urlPatterns"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.add(this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.initParamsLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_initParams"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        this.add(this.initParamsLabel, gridBagConstraints);
        this.filler.setBackground(new Color(255, 255, 255));
        this.filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.filler, gridBagConstraints);
    }

    private void browseButton1ActionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            SourceGroup[] sourceGroupArray = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
            if (fileObject != null && !(string = "/" + DDUtils.getResourcePath(sourceGroupArray, fileObject, '/', true)).equals(this.jspFileTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.jspFileTF.setText(string);
                this.dObj.setChangedFromUI(true);
                this.servlet.setJspFile(string);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            SourceGroup[] sourceGroupArray = DDUtils.getJavaSourceGroups(this.dObj);
            FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
            if (fileObject != null && (string = DDUtils.getResourcePath(sourceGroupArray, fileObject)).length() > 0 && !string.equals(this.servletClassTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.servletClassTF.setText(string);
                this.dObj.setChangedFromUI(true);
                this.servlet.setServletClass(string);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.servletClassRB.isSelected()) {
            this.servletClassTF.setEnabled(true);
            this.jspFileTF.setEnabled(false);
            this.browseButton.setEnabled(true);
            this.browseButton1.setEnabled(false);
            String string = this.servletClassTF.getText().trim();
            if (string.length() > 0 && !string.equals(this.servlet.getServletClass())) {
                this.dObj.modelUpdatedFromUI();
                this.dObj.setChangedFromUI(true);
                this.servlet.setServletClass(string);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        } else {
            this.servletClassTF.setEnabled(false);
            this.jspFileTF.setEnabled(true);
            this.browseButton.setEnabled(false);
            this.browseButton1.setEnabled(true);
            String string = this.jspFileTF.getText().trim();
            if (string.length() > 0 && !string.equals(this.servlet.getJspFile())) {
                this.dObj.modelUpdatedFromUI();
                this.dObj.setChangedFromUI(true);
                this.servlet.setJspFile(string);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
    }

    public JComponent getErrorComponent(String string) {
        if ("ServletName".equals(string)) {
            return this.servletNameTF;
        }
        if ("ServletClass".equals(string)) {
            return this.servletClassTF;
        }
        if ("JspFile".equals(string)) {
            return this.jspFileTF;
        }
        if ("ServletMapping".equals(string)) {
            return this.servletMappingsTF;
        }
        return null;
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        if (jTextComponent == this.servletNameTF) {
            String string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Servlet Name", (JComponent)this.servletNameTF));
                return;
            }
            Servlet[] servletArray = this.dObj.getWebApp().getServlet();
            for (int i = 0; i < servletArray.length; ++i) {
                if (this.servlet == servletArray[i] || !string2.equals(servletArray[i].getServletName())) continue;
                this.getSectionView().getErrorPanel().setError(new Error(0, 3, string2, (JComponent)this.servletNameTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        } else if (jTextComponent == this.servletClassTF) {
            String string3 = string;
            if (string3.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Servlet Class", (JComponent)this.servletClassTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        } else if (jTextComponent == this.jspFileTF) {
            String string4 = string;
            if (string4.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Jsp File", (JComponent)this.jspFileTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        } else if (jTextComponent == this.servletMappingsTF) {
            String string5 = string;
            String[] stringArray = DDUtils.getStringArray(string5);
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = DDUtils.checkServletMappig(stringArray[i]);
                if (string6 != null) {
                    this.getSectionView().getErrorPanel().setError(new Error(0, string6, (JComponent)this.servletMappingsTF));
                    return;
                }
                if (!DDUtils.isServletMapping(this.dObj.getWebApp(), this.servlet, stringArray[i])) continue;
                this.getSectionView().getErrorPanel().setError(new Error(3, stringArray[i], (JComponent)this.servletMappingsTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        } else if (jTextComponent == this.orderTF) {
            String string7 = string;
            BigInteger bigInteger = null;
            try {
                bigInteger = new BigInteger(string7);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (bigInteger == null) {
                this.getSectionView().getErrorPanel().setError(new Error(0, 0, "Invalid Value : " + string7, (JComponent)this.orderTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    public void setValue(JComponent jComponent, Object object) {
        if (jComponent == this.servletNameTF) {
            String string = (String)object;
            ServletMapping[] servletMappingArray = DDUtils.getServletMappings(this.dObj.getWebApp(), this.servlet);
            for (int i = 0; i < servletMappingArray.length; ++i) {
                servletMappingArray[i].setServletName(string);
            }
            FilterMapping[] filterMappingArray = DDUtils.getFilterMappings(this.dObj.getWebApp(), this.servlet);
            for (int i = 0; i < filterMappingArray.length; ++i) {
                filterMappingArray[i].setServletName(string);
            }
            this.servlet.setServletName(string);
            SectionPanel sectionPanel = this.getSectionView().findSectionPanel((Object)this.servlet);
            sectionPanel.setTitle(((ServletsMultiViewElement.ServletsView)this.getSectionView()).getServletTitle(this.servlet));
            sectionPanel.getNode().setDisplayName(string);
        } else if (jComponent == this.servletClassTF) {
            String string = (String)object;
            this.servlet.setServletClass(string.length() == 0 ? null : string);
        } else if (jComponent == this.jspFileTF) {
            String string = (String)object;
            this.servlet.setJspFile(string.length() == 0 ? null : string);
        } else if (jComponent == this.descriptionTA) {
            String string = (String)object;
            this.servlet.setDescription(string.length() == 0 ? null : string);
        } else if (jComponent == this.servletMappingsTF) {
            DDUtils.setServletMappings(this.dObj.getWebApp(), this.servlet, DDUtils.getStringArray((String)object));
            SectionPanel sectionPanel = this.getSectionView().findSectionPanel((Object)this.servlet);
            sectionPanel.setTitle(((ServletsMultiViewElement.ServletsView)this.getSectionView()).getServletTitle(this.servlet));
        } else if (jComponent == this.orderTF) {
            String string = (String)object;
            this.servlet.setLoadOnStartup(string.length() == 0 ? null : new BigInteger(string));
        } else if (jComponent == this.runAsCB) {
            String string = (String)this.runAsCB.getSelectedItem();
            if (string.length() == 0) {
                this.servlet.setRunAs(null);
            } else {
                try {
                    RunAs runAs = (RunAs)this.dObj.getWebApp().createBean("RunAs");
                    runAs.setRoleName(string);
                    this.servlet.setRunAs(runAs);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (jTextComponent == this.servletNameTF) {
            this.servletNameTF.setText(this.servlet.getServletName());
        } else if (jTextComponent == this.servletClassTF) {
            this.servletClassTF.setText(this.servlet.getServletClass());
        } else if (jTextComponent == this.jspFileTF) {
            this.jspFileTF.setText(this.servlet.getJspFile());
        } else if (jTextComponent == this.servletMappingsTF) {
            String[] stringArray = DDUtils.getUrlPatterns(this.dObj.getWebApp(), this.servlet);
            this.servletMappingsTF.setText(DDUtils.urlPatternList(stringArray));
        } else if (jTextComponent == this.orderTF) {
            BigInteger bigInteger = this.servlet.getLoadOnStartup();
            this.orderTF.setText(bigInteger == null ? "" : bigInteger.toString());
        }
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }
}

