/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.JspConfig;
import org.netbeans.modules.j2ee.dd.api.web.JspPropertyGroup;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.PagesPanelFactory;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SectionValidator;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SimpleDialogPanel;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PagesMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private SectionView view;
    private ToolBarDesignEditor comp;
    private DDDataObject dObj;
    private WebApp webApp;
    private PagesPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private boolean needInit = true;
    private int index;
    private RequestProcessor.Task repaintingTask;
    private static final String PAGES_MV_ID = "dd_multiviewPages";
    private static final String HELP_ID_PREFIX = "dd_multiview_pages_";

    public PagesMultiViewElement(DDDataObject dDDataObject, int n) {
        super((XmlMultiViewDataObject)dDDataObject);
        this.dObj = dDDataObject;
        this.index = n;
        this.comp = new ToolBarDesignEditor();
        this.factory = new PagesPanelFactory(this.comp, dDDataObject);
        this.addAction = new AddAction(dDDataObject, NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_addJspPG"));
        this.removeAction = new RemoveAction(NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_remove"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PagesMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new PagesView(this.webApp);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        } else {
            this.view.openPanel((Object)"welcome_files");
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!(this.dObj.isChangedFromUI() || (string = propertyChangeEvent.getPropertyName()).indexOf("WelcomeFileList") <= 0 && string.indexOf("JspConfig") <= 0 && string.indexOf("ErrorPage") <= 0 && string.indexOf("version") <= 0)) {
            if (PAGES_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String string) {
            super(string);
            char c = NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_remove_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ConfirmDialog confirmDialog = new ConfirmDialog(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TXT_removeJspGroupConfirm"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)confirmDialog);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(confirmDialog.getValue())) {
                SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
                JspPropertyGroup jspPropertyGroup = (JspPropertyGroup)sectionPanel.getKey();
                try {
                    PagesMultiViewElement.this.dObj.modelUpdatedFromUI();
                    PagesMultiViewElement.this.dObj.setChangedFromUI(true);
                    PagesMultiViewElement.this.webApp.getSingleJspConfig().removeJspPropertyGroup(jspPropertyGroup);
                    sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                }
                catch (VersionNotSupportedException versionNotSupportedException) {
                }
                finally {
                    PagesMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(DDDataObject dDDataObject, String string) {
            super(string);
            char c = NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_addJspPG_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = new String[]{NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_displayName"), NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_description"), NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_urlPatterns")};
            String[] stringArray2 = new String[]{NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_jsp_property_display_name"), NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_jsp_property_desc"), NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_jsp_property_url_pattern")};
            boolean[] blArray = new boolean[]{false, false, true};
            SimpleDialogPanel.DialogDescriptor dialogDescriptor = new SimpleDialogPanel.DialogDescriptor(stringArray, true);
            dialogDescriptor.setButtons(blArray);
            dialogDescriptor.setA11yDesc(stringArray2);
            dialogDescriptor.setTextField(new boolean[]{true, false, true});
            final SimpleDialogPanel simpleDialogPanel = new SimpleDialogPanel(dialogDescriptor);
            simpleDialogPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_add_jsp_property_group"));
            simpleDialogPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_add_jsp_property_group"));
            simpleDialogPanel.getCustomizerButtons()[0].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SourceGroup[] sourceGroupArray = DDUtils.getDocBaseGroups(PagesMultiViewElement.this.dObj);
                        FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
                        if (fileObject != null) {
                            String string;
                            String string2 = "/" + DDUtils.getResourcePath(sourceGroupArray, fileObject, '/', true);
                            String string3 = simpleDialogPanel.getValues()[2];
                            if (string2.length() > 0 && !string3.equals(string = DDUtils.addItem(string3, string2, false))) {
                                simpleDialogPanel.getTextComponents()[2].setText(string);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            EditDialog editDialog = new EditDialog((JPanel)simpleDialogPanel, NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_JspPropertyGroup"), true){

                protected String validate() {
                    String[] stringArray = simpleDialogPanel.getValues();
                    String string = stringArray[2].trim();
                    return SectionValidator.validateNewJspPropertyGroup(string);
                }
            };
            editDialog.setValid(false);
            EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
            simpleDialogPanel.getTextComponents()[2].getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
            dialog.setVisible(true);
            simpleDialogPanel.getTextComponents()[2].getDocument().removeDocumentListener((DocumentListener)docListener);
            if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
                PagesMultiViewElement.this.dObj.modelUpdatedFromUI();
                PagesMultiViewElement.this.dObj.setChangedFromUI(true);
                String[] stringArray3 = simpleDialogPanel.getValues();
                String string = stringArray3[0];
                String string2 = stringArray3[1];
                String string3 = stringArray3[2].trim();
                try {
                    JspConfig jspConfig = null;
                    try {
                        jspConfig = PagesMultiViewElement.this.webApp.getSingleJspConfig();
                        if (jspConfig == null) {
                            jspConfig = (JspConfig)PagesMultiViewElement.this.webApp.createBean("JspConfig");
                            PagesMultiViewElement.this.webApp.setJspConfig(jspConfig);
                        }
                    }
                    catch (VersionNotSupportedException versionNotSupportedException) {
                        // empty catch block
                    }
                    JspPropertyGroup jspPropertyGroup = (JspPropertyGroup)jspConfig.createBean("JspPropertyGroup");
                    if (string.length() > 0) {
                        jspPropertyGroup.setDisplayName(string);
                    }
                    if (string2.length() > 0) {
                        jspPropertyGroup.setDescription(string2);
                    }
                    String[] stringArray4 = DDUtils.getStringArray(string3);
                    jspPropertyGroup.setUrlPattern(stringArray4);
                    jspConfig.addJspPropertyGroup(jspPropertyGroup);
                    PagesView pagesView = (PagesView)PagesMultiViewElement.this.comp.getContentView();
                    JspPGNode jspPGNode = new JspPGNode(pagesView, jspPropertyGroup);
                    pagesView.getJspPGsNode().getChildren().add(new Node[]{jspPGNode});
                    SectionPanel sectionPanel = new SectionPanel((SectionView)pagesView, (Node)jspPGNode, pagesView.getJspGroupTitle(jspPropertyGroup), (Object)jspPropertyGroup);
                    sectionPanel.setHeaderActions(new Action[]{PagesMultiViewElement.this.removeAction});
                    pagesView.getJspGroupsContainer().addSection((NodeSectionPanel)sectionPanel, true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                finally {
                    PagesMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class ErrorPagesNode
    extends AbstractNode {
        ErrorPagesNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_errorPages"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/htmlObject.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_pages_errorPagesNode");
        }
    }

    private class WelcomeFilesNode
    extends AbstractNode {
        WelcomeFilesNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_welcomeFiles"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/htmlObject.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_pages_welcomeFilesNode");
        }
    }

    private class JspPGNode
    extends AbstractNode {
        JspPGNode(PagesView pagesView, JspPropertyGroup jspPropertyGroup) {
            super(Children.LEAF);
            this.setDisplayName(pagesView.getJspGroupNodeName(jspPropertyGroup));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/jspObject.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_pages_jspPropertyGroupNode");
        }
    }

    class PagesView
    extends SectionView {
        private SectionContainer jspPGCont;
        private Node groupsNode;
        private Node welcomeFilesNode;
        private Node errorPagesNode;

        PagesView(WebApp webApp) {
            AbstractNode abstractNode;
            super((InnerPanelFactory)PagesMultiViewElement.this.factory);
            JspConfig jspConfig = null;
            JspPropertyGroup[] jspPropertyGroupArray = null;
            boolean bl = true;
            try {
                jspConfig = webApp.getSingleJspConfig();
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                bl = false;
            }
            this.welcomeFilesNode = new WelcomeFilesNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.welcomeFilesNode, (Object)"welcome_files"));
            this.errorPagesNode = new ErrorPagesNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.errorPagesNode, (Object)"error_pages"));
            Children.Array array = new Children.Array();
            if (bl) {
                jspPropertyGroupArray = jspConfig == null ? new JspPropertyGroup[]{} : jspConfig.getJspPropertyGroup();
                abstractNode = new Node[jspPropertyGroupArray.length];
                Children.Array array2 = new Children.Array();
                for (int i = 0; i < ((Node[])abstractNode).length; ++i) {
                    abstractNode[i] = new JspPGNode(this, jspPropertyGroupArray[i]);
                }
                array2.add((Node[])abstractNode);
                this.groupsNode = new SectionContainerNode((Children)array2);
                this.groupsNode.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_jspPropGroups"));
                this.groupsNode.setName("dd_multiview_pages_jspPropertyGroupsNode");
                this.jspPGCont = new SectionContainer((SectionView)this, this.groupsNode, NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_jspPropGroups"));
                this.jspPGCont.setHeaderActions(new Action[]{PagesMultiViewElement.this.addAction});
                SectionPanel[] sectionPanelArray = new SectionPanel[jspPropertyGroupArray.length];
                for (int i = 0; i < ((AbstractNode)abstractNode).length; ++i) {
                    sectionPanelArray[i] = new SectionPanel((SectionView)this, (Node)abstractNode[i], this.getJspGroupTitle(jspPropertyGroupArray[i]), (Object)jspPropertyGroupArray[i]);
                    sectionPanelArray[i].setHeaderActions(new Action[]{PagesMultiViewElement.this.removeAction});
                    this.jspPGCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
                }
                this.addSection((NodeSectionPanel)this.jspPGCont);
                array.add(new Node[]{this.welcomeFilesNode, this.errorPagesNode, this.groupsNode});
            } else {
                PagesMultiViewElement.this.addAction.setEnabled(false);
                array.add(new Node[]{this.welcomeFilesNode, this.errorPagesNode});
            }
            abstractNode = new AbstractNode((Children)array);
            this.setRoot((Node)abstractNode);
        }

        Node getJspPGsNode() {
            return this.groupsNode;
        }

        Node getWelcomeFilesNode() {
            return this.welcomeFilesNode;
        }

        SectionContainer getJspGroupsContainer() {
            return this.jspPGCont;
        }

        String getJspGroupTitle(JspPropertyGroup jspPropertyGroup) {
            String string = jspPropertyGroup.getDefaultDisplayName();
            if (string == null) {
                string = NbBundle.getMessage(PagesMultiViewElement.class, (String)"NODE_JSP_GROUP");
            }
            String[] stringArray = jspPropertyGroup.getUrlPattern();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
            return NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_JSP_GROUP", (Object)string, (Object)stringBuffer.toString());
        }

        String getJspGroupNodeName(JspPropertyGroup jspPropertyGroup) {
            String string = jspPropertyGroup.getDefaultDisplayName();
            if (string != null) {
                return string;
            }
            return NbBundle.getMessage(PagesMultiViewElement.class, (String)"NODE_JSP_GROUP");
        }

        public Error validateView() {
            return SectionValidator.validatePages(PagesMultiViewElement.this.webApp);
        }
    }
}

