/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.client;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.j2ee.ddloaders.client.ClientDataObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class ClientDataNode
extends DataNode {
    private static final String DEPLOYMENT = "deployment";
    private static final Image ERROR_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/client/error-badge.gif");
    private static final Image CLIETN_XML = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/client/DDDataIcon.gif");
    private ClientDataObject dataObject;
    public static final String PROPERTY_DOCUMENT_TYPE = "documentType";
    private PropertyChangeListener ddListener;

    public ClientDataNode(ClientDataObject clientDataObject) {
        this(clientDataObject, Children.LEAF);
    }

    public ClientDataNode(ClientDataObject clientDataObject, Children children) {
        super((DataObject)clientDataObject, children);
        this.dataObject = clientDataObject;
        this.initListeners();
    }

    private void initListeners() {
        this.ddListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                Object object2 = propertyChangeEvent.getOldValue();
                if ("documentDTD".equals(string)) {
                    ClientDataNode.this.firePropertyChange(ClientDataNode.PROPERTY_DOCUMENT_TYPE, object2, object);
                }
                if ("valid".equals(string) && Boolean.TRUE.equals(object)) {
                    ClientDataNode.this.removePropertyChangeListener(ClientDataNode.this.ddListener);
                }
                if ("propertySets".equals(string)) {
                    ClientDataNode.this.firePropertySetsChange(null, null);
                }
                if ("sax_error".equals(string)) {
                    ClientDataNode.this.fireShortDescriptionChange((String)object2, (String)object);
                }
            }
        };
        this.getDataObject().addPropertyChangeListener(this.ddListener);
    }

    private ClientDataObject getDDDataObject() {
        return (ClientDataObject)this.getDataObject();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        PropertySupport.ReadOnly readOnly = new PropertySupport.ReadOnly(PROPERTY_DOCUMENT_TYPE, String.class, NbBundle.getBundle(ClientDataNode.class).getString("PROP_documentDTD"), NbBundle.getBundle(ClientDataNode.class).getString("HINT_documentDTD")){

            public Object getValue() {
                return ClientDataNode.this.dataObject.getAppClient().getVersion();
            }
        };
        set.put((Node.Property)readOnly);
        sheet.put(set);
        return sheet;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("TBD application-client.xml file");
    }

    void iconChanged() {
        this.fireIconChange();
    }

    public Image getIcon(int n) {
        if (this.dataObject.getSaxError() == null) {
            return CLIETN_XML;
        }
        return ImageUtilities.mergeImages((Image)CLIETN_XML, (Image)ERROR_BADGE, (int)6, (int)6);
    }

    public String getShortDescription() {
        SAXException sAXException = this.dataObject.getSaxError();
        if (sAXException == null) {
            return NbBundle.getBundle(ClientDataNode.class).getString("HINT_web_dd");
        }
        return sAXException.getMessage();
    }
}

