/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.components.DiscreteProgress;
import org.netbeans.modules.profiler.ui.HyperlinkTextArea;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SettingsContainerPanel
extends JPanel
implements ChangeListener,
HelpCtx.Provider {
    private static final String ADVANCED_CAPTION_TEXT = NbBundle.getMessage(SettingsContainerPanel.class, (String)"SettingsContainerPanel_AdvancedCaptionText");
    private static final String BASIC_SETTINGS_STRING = NbBundle.getMessage(SettingsContainerPanel.class, (String)"SettingsContainerPanel_BasicSettingsString");
    private static final String ADVANCED_SETTINGS_STRING = NbBundle.getMessage(SettingsContainerPanel.class, (String)"SettingsContainerPanel_AdvancedSettingsString");
    private static final String READONLY_SETTINGS_MSG = NbBundle.getMessage(SettingsContainerPanel.class, (String)"SettingsContainerPanel_ReadOnlySettingsMsg");
    private static final String OVERHEAD_LABEL_TEXT = NbBundle.getMessage(SettingsContainerPanel.class, (String)"SettingsContainerPanel_OverheadLabelText");
    private CardLayout basicAdvancedSettingsSwitchContainerLayout;
    private Contents contents;
    private DiscreteProgress progress;
    private HyperlinkTextArea basicAdvancedSettingsSwitchArea;
    private JLabel captionLabel;
    private JPanel basicAdvancedSettingsSwitchContainer;
    private JScrollPane contentsScroll;
    private String caption;
    private boolean showingAdvancedSettings = true;
    private boolean showingPreset;

    public SettingsContainerPanel() {
        this.initComponents();
    }

    public void setCaption(String string) {
        this.caption = string;
        this.captionLabel.setText(string);
    }

    public void setContents(Contents contents) {
        this.setContents(contents, false);
    }

    public void setContents(Contents contents, boolean bl) {
        if (this.contents != null) {
            contents.removeChangeListener(this);
        }
        this.contents = contents;
        if (this.contents != null) {
            contents.addChangeListener(this);
        }
        if (bl) {
            this.switchToAdvancedSettings();
        } else {
            this.switchToBasicSettings();
        }
    }

    public HelpCtx getHelpCtx() {
        JPanel jPanel;
        if (this.contents == null) {
            return HelpCtx.DEFAULT_HELP;
        }
        JPanel jPanel2 = jPanel = this.showingAdvancedSettings ? this.contents.getAdvancedSettingsPanel() : this.contents.getBasicSettingsPanel();
        if (jPanel == null || !(jPanel instanceof HelpCtx.Provider)) {
            return HelpCtx.DEFAULT_HELP;
        }
        return ((HelpCtx.Provider)jPanel).getHelpCtx();
    }

    public void setShowingPreset(boolean bl) {
        this.showingPreset = bl;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.progress.setActiveUnits(Math.round(this.contents.getProfilingOverhead() * 10.0f));
    }

    public void switchToAdvancedSettings() {
        this.showingAdvancedSettings = false;
        this.toggleBasicAdvancedSettingsView();
    }

    public void switchToBasicSettings() {
        this.showingAdvancedSettings = true;
        this.toggleBasicAdvancedSettingsView();
    }

    void setPreferredContentsSize(Dimension dimension) {
        this.contentsScroll.setPreferredSize(dimension);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.setBackground(SelectProfilingTask.BACKGROUND_COLOR);
        this.captionLabel = new JLabel(" ");
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1, this.captionLabel.getFont().getSize2D() + 3.0f));
        this.captionLabel.setForeground(new Color(198, 129, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(27, 30, 12, 20);
        this.add((Component)this.captionLabel, gridBagConstraints);
        JSeparator jSeparator = Utils.createHorizontalSeparator();
        jSeparator.setBackground(this.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.add((Component)jSeparator, gridBagConstraints);
        this.contentsScroll = new JScrollPane(20, 31);
        this.contentsScroll.setBorder(BorderFactory.createEmptyBorder());
        this.contentsScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        this.add((Component)this.contentsScroll, gridBagConstraints);
        JSeparator jSeparator2 = Utils.createHorizontalSeparator();
        jSeparator2.setBackground(this.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.add((Component)jSeparator2, gridBagConstraints);
        JLabel jLabel = new JLabel(OVERHEAD_LABEL_TEXT);
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getSize2D() - 1.0f));
        jLabel.setForeground(SelectProfilingTask.DARKLINK_COLOR_INACTIVE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 22, 4, 0);
        this.add((Component)jLabel, gridBagConstraints);
        this.progress = new DiscreteProgress();
        this.progress.setActiveUnits(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 4, 0);
        this.add((Component)this.progress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 4, 0);
        this.add((Component)Utils.createFillerPanel(), gridBagConstraints);
        this.basicAdvancedSettingsSwitchArea = new HyperlinkTextArea(ADVANCED_SETTINGS_STRING){

            protected Color getHighlightColor() {
                return SelectProfilingTask.DARKLINK_COLOR;
            }

            protected String getHighlightText(String string) {
                return "<nobr><u>" + string + "</u></nobr>";
            }

            protected Color getNormalColor() {
                return SelectProfilingTask.DARKLINK_COLOR_INACTIVE;
            }

            protected String getNormalText(String string) {
                return "<nobr><u>" + string + "</u></nobr>";
            }
        };
        Font font = UIManager.getFont("Label.font");
        this.basicAdvancedSettingsSwitchArea.setFont(font.deriveFont(font.getSize2D() - 1.0f));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 4, 22);
        this.add((Component)((Object)this.basicAdvancedSettingsSwitchArea), gridBagConstraints);
        this.basicAdvancedSettingsSwitchArea.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    SettingsContainerPanel.this.toggleBasicAdvancedSettingsView();
                }
            }
        });
        this.basicAdvancedSettingsSwitchArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    SettingsContainerPanel.this.toggleBasicAdvancedSettingsView();
                }
            }
        });
    }

    private void toggleBasicAdvancedSettingsView() {
        JPanel jPanel;
        this.contents.synchronizeBasicAdvancedPanels();
        boolean bl = this.showingAdvancedSettings = !this.showingAdvancedSettings;
        if (this.showingAdvancedSettings) {
            this.captionLabel.setText(MessageFormat.format(ADVANCED_CAPTION_TEXT, this.caption));
            this.basicAdvancedSettingsSwitchArea.setText(BASIC_SETTINGS_STRING);
            jPanel = this.contents.getAdvancedSettingsPanel();
        } else {
            this.captionLabel.setText(this.caption);
            this.basicAdvancedSettingsSwitchArea.setText(ADVANCED_SETTINGS_STRING);
            jPanel = this.contents.getBasicSettingsPanel();
        }
        this.basicAdvancedSettingsSwitchArea.updateAppearance();
        jPanel.setBackground(this.getBackground());
        this.contentsScroll.setViewportView(jPanel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JScrollBar jScrollBar = SettingsContainerPanel.this.contentsScroll.getVerticalScrollBar();
                if (jScrollBar == null || !jScrollBar.isVisible()) {
                    return;
                }
                jScrollBar.setValue(0);
            }
        });
        SelectProfilingTask.getDefault().updateHelpCtx();
        if (this.showingPreset && this.showingAdvancedSettings) {
            ProfilerDialogs.DNSAMessage dNSAMessage = new ProfilerDialogs.DNSAMessage("SettingsContainerPanel.switchToAdvancedSettings.presetNotification", READONLY_SETTINGS_MSG, 1);
            dNSAMessage.setDNSADefault(false);
            ProfilerDialogs.notify((NotifyDescriptor)dNSAMessage);
        }
    }

    public static interface Contents {
        public JPanel getAdvancedSettingsPanel();

        public JPanel getBasicSettingsPanel();

        public float getProfilingOverhead();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public void synchronizeBasicAdvancedPanels();
    }
}

