/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.LocationCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LoadGeneratorCustomizer
extends ValidityAwarePanel
implements ActionListener,
ChangeListener,
DocumentListener,
ValidityListener,
HelpCtx.Provider {
    private static final String NAME_LABEL_TEXT = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_NameLabelText");
    private static final String SETTINGS_LABEL_TEXT = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_SettingsLabelText");
    private static final String SCRIPT_LABEL_TEXT = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_ScriptLabelText");
    private static final String BROWSE_BUTTON_TEXT = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_BrowseButtonText");
    private static final String STOP_LABEL_TEXT = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_StopLabelText");
    private static final String DEFINE_RADIO_TEXT = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_DefineRadioText");
    private static final String STOP_RADIO_TEXT = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_StopRadioText");
    private static final String LOCATION_BEGIN_LABEL_TEXT = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_LocationBeginLabelText");
    private static final String LOCATION_END_LABEL_TEXT = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_LocationEndLabelText");
    private static final String CHOOSE_SCRIPT_DIALOG_CAPTION = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_ChooseScriptDialogCaption");
    private static final String SCRIPT_FIELD_ACCESS_DESCR = NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_ScriptFieldAccessDescr");
    private static final String HELP_CTX_KEY = "LoadGeneratorCustomizer.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("LoadGeneratorCustomizer.HelpCtx");
    private static int defaultTextComponentHeight = -1;
    private static JFileChooser fileChooser;
    private JButton scriptButton;
    private JLabel captionLabel;
    private JLabel locationBeginHeaderLabel;
    private JLabel locationEndHeaderLabel;
    private JLabel nameLabel;
    private JLabel scriptLabel;
    private JLabel settingsHeaderLabel;
    private JLabel stopLabel;
    private JPanel captionPanel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel secondLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel thirdLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton stopDefineRadio;
    private JRadioButton stopOnStopRadio;
    private JSeparator locationBeginHeaderSeparator;
    private JSeparator locationEndHeaderSeparator;
    private JSeparator settingsHeaderSeparator;
    private JTextField nameTextField;
    private JTextField scriptTextField;
    private LocationCustomizer locationBeginCustomizer;
    private LocationCustomizer locationEndCustomizer;
    private Project project;

    public LoadGeneratorCustomizer(String string, Icon icon) {
        this.initComponents(string, icon);
        this.normalizeCaptionAreaWidth();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public Component getInitialFocusTarget() {
        return this.nameTextField;
    }

    public void setPPEndLocation(CodeProfilingPoint.Location location) {
        if (location == null) {
            this.stopOnStopRadio.setSelected(true);
            this.locationEndCustomizer.setPPLocation(CodeProfilingPoint.Location.EMPTY);
        } else {
            this.stopDefineRadio.setSelected(true);
            this.locationEndCustomizer.setPPLocation(location);
        }
    }

    public CodeProfilingPoint.Location getPPEndLocation() {
        if (this.stopOnStopRadio.isSelected()) {
            return null;
        }
        return this.locationEndCustomizer.getPPLocation();
    }

    public void setPPName(String string) {
        this.nameTextField.setText(string);
    }

    public String getPPName() {
        return this.nameTextField.getText();
    }

    public void setPPStartLocation(CodeProfilingPoint.Location location) {
        this.locationBeginCustomizer.setPPLocation(location);
    }

    public CodeProfilingPoint.Location getPPStartLocation() {
        return this.locationBeginCustomizer.getPPLocation();
    }

    public int getPreferredCaptionAreaWidth() {
        int n = this.nameLabel.getPreferredSize().width - 12;
        n = Math.max(n, this.scriptLabel.getPreferredSize().width);
        n = Math.max(n, this.stopLabel.getPreferredSize().width);
        return Math.max(n, this.locationBeginCustomizer.getPreferredCaptionAreaWidth());
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setScriptFile(String string) {
        this.scriptTextField.setText(string);
    }

    public String getScriptFile() {
        return this.scriptTextField.getText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.scriptButton) {
            JFileChooser jFileChooser = this.getFileChooser();
            Object var3_3 = null;
            String string = this.scriptTextField.getText();
            if (string.length() > 0) {
                jFileChooser.setCurrentDirectory(new File(string).getParentFile());
            } else {
                jFileChooser.setCurrentDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
            }
            if (jFileChooser.showOpenDialog(null) == 0) {
                this.scriptTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void initComponents(String string, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.captionPanel = new JPanel(new BorderLayout(0, 0));
        this.captionPanel.setOpaque(true);
        this.captionPanel.setBackground(UIUtils.getProfilerResultsBackground());
        this.captionLabel = new JLabel(string, icon, 10);
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1));
        this.captionLabel.setOpaque(false);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 6));
        this.captionPanel.add((Component)this.captionLabel, "West");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 16, 0);
        this.add((Component)this.captionPanel, gridBagConstraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NAME_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 10, 5);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, gridBagConstraints);
        this.nameTextField = new JTextField(""){

            public Dimension getPreferredSize() {
                return LoadGeneratorCustomizer.this.getParent() instanceof JViewport ? this.getMinimumSize() : new Dimension(400, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }
        };
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 13);
        this.add((Component)this.nameTextField, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.settingsHeaderLabel = new JLabel(SETTINGS_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.settingsHeaderLabel, gridBagConstraints);
        this.settingsHeaderSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.settingsHeaderSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.scriptLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.scriptLabel, (String)SCRIPT_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)this.scriptLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.secondLineCaptionSpacer, gridBagConstraints);
        this.scriptTextField = new JTextField(""){

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.scriptLabel.setLabelFor(this.scriptTextField);
        this.scriptTextField.getAccessibleContext().setAccessibleDescription(SCRIPT_FIELD_ACCESS_DESCR);
        this.scriptTextField.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)this.scriptTextField, gridBagConstraints);
        this.scriptButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.scriptButton, (String)BROWSE_BUTTON_TEXT);
        this.scriptButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.scriptButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 5, 13);
        this.add((Component)jPanel2, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.stopLabel = new JLabel(STOP_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.stopLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this.thirdLineCaptionSpacer, gridBagConstraints);
        this.stopDefineRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.stopDefineRadio, (String)DEFINE_RADIO_TEXT);
        buttonGroup.add(this.stopDefineRadio);
        this.stopDefineRadio.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.stopDefineRadio, gridBagConstraints);
        this.stopOnStopRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.stopOnStopRadio, (String)STOP_RADIO_TEXT);
        this.stopOnStopRadio.addChangeListener(this);
        buttonGroup.add(this.stopOnStopRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this.stopOnStopRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 10, 13);
        this.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this.locationBeginHeaderLabel = new JLabel(LOCATION_BEGIN_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel4.add((Component)this.locationBeginHeaderLabel, gridBagConstraints);
        this.locationBeginHeaderSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel4.add((Component)this.locationBeginHeaderSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)jPanel4, gridBagConstraints);
        this.locationBeginCustomizer = new LocationCustomizer();
        this.locationBeginCustomizer.addValidityListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 12, 13);
        this.add((Component)this.locationBeginCustomizer, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        this.locationEndHeaderLabel = new JLabel(LOCATION_END_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel5.add((Component)this.locationEndHeaderLabel, gridBagConstraints);
        this.locationEndHeaderSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel5.add((Component)this.locationEndHeaderSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)jPanel5, gridBagConstraints);
        this.locationEndCustomizer = new LocationCustomizer();
        this.locationEndCustomizer.resetMnemonic();
        this.locationEndCustomizer.addValidityListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 20, 13);
        this.add((Component)this.locationEndCustomizer, gridBagConstraints);
        JPanel jPanel6 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel6, gridBagConstraints);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LoadGeneratorCustomizer loadGeneratorCustomizer = new LoadGeneratorCustomizer("Load Generator", null);
        loadGeneratorCustomizer.addValidityListener(new ValidityListener(){

            public void validityChanged(boolean bl) {
                System.err.println(">>> Validity changed to " + bl);
            }
        });
        JFrame jFrame = new JFrame("Customize Profiling Point");
        jFrame.getContentPane().add(loadGeneratorCustomizer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
        int n = this.nameLabel.getPreferredSize().width - 12;
        int n2 = this.getPreferredCaptionAreaWidth() - n;
        int n3 = n2 > 0 ? n2 : 0;
        int n4 = this.scriptLabel.getPreferredSize().width;
        int n5 = this.getPreferredCaptionAreaWidth() - n4;
        int n6 = n5 > 0 ? n5 : 0;
        int n7 = this.stopLabel.getPreferredSize().width;
        int n8 = this.getPreferredCaptionAreaWidth() - n7;
        int n9 = n8 > 0 ? n8 : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n3, 0, 0));
        this.secondLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n6, 0, 0));
        this.thirdLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n9, 0, 0));
        this.locationBeginCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
        this.locationEndCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.stopDefineRadio || changeEvent.getSource() == this.stopOnStopRadio) {
            boolean bl = this.stopDefineRadio.isSelected();
            this.locationEndCustomizer.setEnabled(bl);
            this.locationEndHeaderLabel.setEnabled(bl);
            this.locationEndHeaderSeparator.setEnabled(bl);
            this.updateValidity();
        }
    }

    public void validityChanged(boolean bl) {
        this.updateValidity();
    }

    private JFileChooser getFileChooser() {
        if (fileChooser == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(CHOOSE_SCRIPT_DIALOG_CAPTION);
            jFileChooser.setFileFilter(new FileFilter(){
                private Set<String> extensions = new HashSet<String>();
                {
                    LoadGenPlugin loadGenPlugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
                    this.extensions = loadGenPlugin.getSupportedExtensions();
                }

                public boolean accept(File file) {
                    return file.isDirectory() || this.extensions.contains(FileUtil.getExtension((String)file.getPath()));
                }

                public String getDescription() {
                    return NbBundle.getMessage(LoadGeneratorCustomizer.class, (String)"LoadGeneratorCustomizer_SupportedFiles");
                }
            });
            fileChooser = jFileChooser;
        }
        return fileChooser;
    }

    private boolean isNameEmpty() {
        return this.nameTextField.getText().trim().length() == 0;
    }

    private boolean isScriptValid() {
        String string = this.scriptTextField.getText();
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            LoadGenPlugin loadGenPlugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
            if (loadGenPlugin == null) {
                return false;
            }
            String string2 = FileUtil.getExtension((String)this.scriptTextField.getText());
            return loadGenPlugin.getSupportedExtensions().contains(string2);
        }
        return false;
    }

    private boolean areEndLocationSettingsValid() {
        return this.stopOnStopRadio.isSelected() || this.locationEndCustomizer.areSettingsValid();
    }

    private void updateValidity() {
        boolean bl;
        boolean bl2 = bl = !this.isNameEmpty() && this.isScriptValid() && this.locationBeginCustomizer.areSettingsValid() && this.areEndLocationSettingsValid();
        if (bl != this.areSettingsValid()) {
            this.fireValidityChanged(bl);
        }
    }
}

