/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.ReferencesBrowserController;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.ui.FieldTreeCellRenderer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ReferencesBrowserControllerUI
extends JTitledPanel {
    private static final String VIEW_TITLE_REFERENCES = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ViewTitleReferences");
    private static final String NO_INSTANCE_SELECTED_MSG = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_NoInstanceSelectedMsg");
    private static final String SHOW_LOOP_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowLoopItemText");
    private static final String SHOW_INSTANCE_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowInstanceItemText");
    private static final String SHOW_IN_CLASSES_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowInClassesItemText");
    private static final String SHOW_GCROOT_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowGcRootItemText");
    private static final String GO_TO_SOURCE_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_GoToSourceItemText");
    private static final String SHOW_HIDE_COLUMNS_STRING = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowHideColumnsString");
    private static final String FIELD_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_FieldColumnName");
    private static final String FIELD_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_FieldColumnDescr");
    private static final String TYPE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_TypeColumnName");
    private static final String TYPE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_TypeColumnDescr");
    private static final String FULL_TYPE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_FullTypeColumnName");
    private static final String FULL_TYPE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_FullTypeColumnDescr");
    private static final String VALUE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ValueColumnName");
    private static final String VALUE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ValueColumnDescr");
    private static final String SIZE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_SizeColumnName");
    private static final String SIZE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_SizeColumnDescr");
    private static final String RETAINED_SIZE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_RetainedSizeColumnName");
    private static final String RETAINED_SIZE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_RetainedSizeColumnDescr");
    private static ImageIcon ICON_FIELDS = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/incomingRef.png", (boolean)false);
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private int columnCount;
    private CardLayout contents;
    private FieldTreeCellRenderer treeCellRenderer = new FieldTreeCellRenderer();
    private FieldsListTreeTableModel realFieldsListTableModel;
    private ExtendedTreeTableModel fieldsListTableModel;
    private JMenuItem showGcRootItem;
    private JMenuItem showInstanceItem;
    private JMenuItem showLoopOriginItem;
    private JMenuItem showSourceItem;
    private JPanel dataPanel;
    private JPanel noDataPanel;
    private JPopupMenu cornerPopup;
    private JPopupMenu tablePopup;
    private JTreeTable fieldsListTable;
    private ReferencesBrowserController referencesBrowserController;
    private String filterValue = "";
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private boolean internalCornerButtonClick = false;
    private boolean needsUpdate = true;
    private boolean sortingOrder = true;
    private int sortingColumn = 0;
    private boolean retainedSizeSupported;
    private static final int MAX_STEP = 10;

    public ReferencesBrowserControllerUI(ReferencesBrowserController referencesBrowserController) {
        super(VIEW_TITLE_REFERENCES, (Icon)ICON_FIELDS, true);
        this.referencesBrowserController = referencesBrowserController;
        this.retainedSizeSupported = referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getRetainedSizesStatus() != -1;
        this.columnCount = this.retainedSizeSupported ? 6 : 5;
        this.realFieldsListTableModel = new FieldsListTreeTableModel();
        this.fieldsListTableModel = new ExtendedTreeTableModel((AbstractTreeTableModel)this.realFieldsListTableModel);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && ReferencesBrowserControllerUI.this.isShowing() && ReferencesBrowserControllerUI.this.needsUpdate) {
                    ReferencesBrowserControllerUI.this.update();
                }
            }
        });
        this.initColumnsData();
        this.initData();
        this.initComponents();
        referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().addStateListener(new HeapFragmentWalker.StateListener(){

            public void stateChanged(HeapFragmentWalker.StateEvent stateEvent) {
                if (stateEvent.getRetainedSizesStatus() == 3 && stateEvent.isMasterChange()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ReferencesBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(5, true);
                            ReferencesBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                            ReferencesBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                            ReferencesBrowserControllerUI.this.setColumnsData();
                        }
                    });
                }
            }
        });
    }

    public void refreshView() {
        if (this.fieldsListTable != null) {
            this.fieldsListTable.updateTreeTable();
        }
    }

    public void selectNode(HeapWalkerNode heapWalkerNode) {
        CCTNode[] cCTNodeArray = this.fieldsListTable.getPathToRoot((CCTNode)heapWalkerNode);
        this.selectPath(cCTNodeArray, Math.min(cCTNodeArray.length, 10));
    }

    private void selectPath(final CCTNode[] cCTNodeArray, final int n) {
        if (n >= cCTNodeArray.length) {
            this.fieldsListTable.getTree().setSelectionPath(new TreePath(cCTNodeArray));
        } else {
            Object[] objectArray = new Object[n];
            System.arraycopy(cCTNodeArray, 0, objectArray, 0, n);
            final TreePath treePath = new TreePath(objectArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReferencesBrowserControllerUI.this.fieldsListTable.getTree().setSelectionPath(treePath);
                    ReferencesBrowserControllerUI.this.fieldsListTable.scrollRectToVisible(ReferencesBrowserControllerUI.this.fieldsListTable.getCellRect(ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow(), 0, true));
                    ReferencesBrowserControllerUI.this.selectPath(cCTNodeArray, n + 10);
                }
            });
        }
    }

    public void update() {
        if (this.isShowing()) {
            this.initData();
            if (this.contents != null) {
                if (this.fieldsListTableModel.getRoot() == null || this.fieldsListTableModel.getRoot() == ReferencesBrowserController.EMPTY_INSTANCE_NODE) {
                    this.contents.show(this.getContentPanel(), NO_DATA);
                } else {
                    this.contents.show(this.getContentPanel(), DATA);
                }
                this.fieldsListTable.resetTreeCellOffsetX();
            }
            this.needsUpdate = false;
        } else {
            this.needsUpdate = true;
        }
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realFieldsListTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.realFieldsListTableModel.getColumnName(i));
            jCheckBoxMenuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.fieldsListTable != null) {
                jCheckBoxMenuItem.setState(this.fieldsListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.fieldsListTable.getColumnModel();
        this.fieldsListTable.setTreeCellRenderer((EnhancedTreeCellRenderer)this.treeCellRenderer);
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int n = this.fieldsListTableModel.getRealColumn(i);
            if (n == 0) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(final JCheckBoxMenuItem jCheckBoxMenuItem) {
        final boolean[] blArray = new boolean[1];
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (blArray[0]) {
                    return;
                }
                final int n = Integer.parseInt(actionEvent.getActionCommand());
                if (n == 5 && !ReferencesBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(n)) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            final int n2 = ReferencesBrowserControllerUI.this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().computeRetainedSizes(false);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (n2 != 3) {
                                        blArray[0] = true;
                                        jCheckBoxMenuItem.setSelected(!jCheckBoxMenuItem.isSelected());
                                        blArray[0] = false;
                                    } else {
                                        ReferencesBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(n, !ReferencesBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(n));
                                        ReferencesBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                                        ReferencesBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                                        ReferencesBrowserControllerUI.this.setColumnsData();
                                    }
                                }
                            });
                        }
                    });
                } else {
                    ReferencesBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(n, !ReferencesBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(n));
                    ReferencesBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                    ReferencesBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                    ReferencesBrowserControllerUI.this.setColumnsData();
                }
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu jPopupMenu) {
        final JButton jButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/lib/profiler/ui/resources/hideColumn.png", (boolean)false));
        jButton.setToolTipText(SHOW_HIDE_COLUMNS_STRING);
        jButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 1));
        }
        jButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    ReferencesBrowserControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (jPopupMenu.isVisible()) {
                    ReferencesBrowserControllerUI.this.internalCornerButtonClick = true;
                    jButton.getModel().setArmed(false);
                } else {
                    ReferencesBrowserControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        ReferencesBrowserControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                    }
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !ReferencesBrowserControllerUI.this.internalCornerButtonClick) {
                    ReferencesBrowserControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        return jButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.showInstanceItem = new JMenuItem(SHOW_INSTANCE_ITEM_TEXT);
        this.showInstanceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesBrowserControllerUI.this.performDefaultAction();
            }
        });
        this.showInstanceItem.setFont(jPopupMenu.getFont().deriveFont(1));
        this.showGcRootItem = new JMenuItem(SHOW_GCROOT_ITEM_TEXT);
        this.showGcRootItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceNode instanceNode;
                HeapWalkerNode heapWalkerNode;
                int n = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (n != -1 && (heapWalkerNode = (HeapWalkerNode)ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent()) instanceof InstanceNode && (instanceNode = (InstanceNode)heapWalkerNode).hasInstance()) {
                    ReferencesBrowserControllerUI.this.referencesBrowserController.navigateToNearestGCRoot(instanceNode);
                }
            }
        });
        this.showLoopOriginItem = new JMenuItem(SHOW_LOOP_ITEM_TEXT);
        this.showLoopOriginItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapWalkerNode heapWalkerNode;
                int n = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (n != -1 && (heapWalkerNode = (HeapWalkerNode)ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent()) instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)heapWalkerNode).isLoop()) {
                    ReferencesBrowserControllerUI.this.selectNode(((HeapWalkerInstanceNode)heapWalkerNode).getLoopTo());
                }
            }
        });
        this.showSourceItem = new JMenuItem(GO_TO_SOURCE_ITEM_TEXT);
        this.showSourceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (n != -1) {
                    HeapWalkerNode heapWalkerNode = (HeapWalkerNode)ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent();
                    String string = heapWalkerNode.getType();
                    while (string.endsWith("[]")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    NetBeansProfiler.getDefaultNB().openJavaSource(null, string, null, null);
                }
            }
        });
        jPopupMenu.add(this.showInstanceItem);
        jPopupMenu.add(this.showGcRootItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.showLoopOriginItem);
        jPopupMenu.add(this.showSourceItem);
        return jPopupMenu;
    }

    private void initColumnsData() {
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = FIELD_COLUMN_NAME;
        this.columnToolTips[0] = FIELD_COLUMN_DESCR;
        this.columnNames[1] = TYPE_COLUMN_NAME;
        this.columnToolTips[1] = TYPE_COLUMN_DESCR;
        this.columnNames[2] = FULL_TYPE_COLUMN_NAME;
        this.columnToolTips[2] = FULL_TYPE_COLUMN_DESCR;
        this.columnNames[3] = VALUE_COLUMN_NAME;
        this.columnToolTips[3] = VALUE_COLUMN_DESCR;
        this.columnNames[4] = SIZE_COLUMN_NAME;
        this.columnToolTips[4] = SIZE_COLUMN_DESCR;
        if (this.retainedSizeSupported) {
            this.columnNames[5] = RETAINED_SIZE_COLUMN_NAME;
            this.columnToolTips[5] = RETAINED_SIZE_COLUMN_DESCR;
        }
        int n = this.getFontMetrics(this.getFont()).charWidth('W');
        FieldTreeCellRenderer fieldTreeCellRenderer = new FieldTreeCellRenderer();
        fieldTreeCellRenderer.setLeafIcon(null);
        fieldTreeCellRenderer.setClosedIcon(null);
        fieldTreeCellRenderer.setOpenIcon(null);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n * 18;
        this.columnRenderers[1] = labelTableCellRenderer;
        this.columnWidths[1] = n * 28;
        this.columnRenderers[2] = labelTableCellRenderer;
        this.columnWidths[2] = n * 14;
        this.columnRenderers[3] = labelTableCellRenderer;
        this.columnWidths[3] = n * 7;
        this.columnRenderers[4] = labelTableCellRenderer;
        if (this.retainedSizeSupported) {
            this.columnWidths[4] = n * 7;
            this.columnRenderers[5] = labelTableCellRenderer;
        }
    }

    private void initComponents() {
        this.treeCellRenderer.setLeafIcon(null);
        this.treeCellRenderer.setClosedIcon(null);
        this.treeCellRenderer.setOpenIcon(null);
        this.fieldsListTableModel.setRealColumnVisibility(2, false);
        this.fieldsListTableModel.setRealColumnVisibility(4, false);
        if (this.retainedSizeSupported) {
            this.fieldsListTableModel.setRealColumnVisibility(5, this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getRetainedSizesStatus() == 3);
        }
        this.fieldsListTable = new JTreeTable((AbstractTreeTableModel)this.fieldsListTableModel){

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < ReferencesBrowserControllerUI.this.fieldsListTableModel.getColumnCount(); ++i) {
                    if (ReferencesBrowserControllerUI.this.fieldsListTableModel.getRealColumn(i) == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(this.getWidth() - n);
                }
                super.doLayout();
            }
        };
        this.fieldsListTable.setSelectionMode(0);
        this.fieldsListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.fieldsListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.fieldsListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.fieldsListTable.setShowHorizontalLines(false);
        this.fieldsListTable.setShowVerticalLines(true);
        this.fieldsListTable.setRowMargin(0);
        this.fieldsListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.fieldsListTable.getTree().setLargeModel(true);
        this.fieldsListTable.getTree().setToggleClickCount(0);
        this.fieldsListTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.fieldsListTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.fieldsListTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesBrowserControllerUI.this.performDefaultAction();
            }
        });
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>(this.fieldsListTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.fieldsListTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet(this.fieldsListTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.fieldsListTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JTreeTablePanel jTreeTablePanel = new JTreeTablePanel(this.fieldsListTable);
        jTreeTablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.add((Component)jTreeTablePanel, "Center");
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hTMLTextArea = new HTMLTextArea();
        hTMLTextArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String string = MessageFormat.format(NO_INSTANCE_SELECTED_MSG, "<img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/instances.png'>");
        hTMLTextArea.setText(string);
        this.noDataPanel.add((Component)hTMLTextArea, "Center");
        this.contents = new CardLayout();
        this.setLayout(this.contents);
        this.add(this.noDataPanel, NO_DATA);
        this.add(this.dataPanel, DATA);
        this.fieldsListTable.addMouseListener((MouseListener)new FieldsListTableMouseListener());
        this.fieldsListTable.addKeyListener((KeyListener)new FieldsListTableKeyListener());
    }

    private void initData() {
        this.fieldsListTableModel.setRoot((Object)this.referencesBrowserController.getFilteredSortedReferences(this.filterValue, this.sortingColumn, this.sortingOrder));
        this.refreshView();
    }

    private void navigateToInstance(Instance instance) {
        this.referencesBrowserController.navigateToInstance(instance);
    }

    private void performDefaultAction() {
        HeapWalkerNode heapWalkerNode;
        int n = this.fieldsListTable.getSelectedRow();
        if (n != -1 && (heapWalkerNode = (HeapWalkerNode)this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent()) instanceof HeapWalkerInstanceNode) {
            this.referencesBrowserController.createNavigationHistoryPoint();
            HeapWalkerInstanceNode heapWalkerInstanceNode = (HeapWalkerInstanceNode)heapWalkerNode;
            this.referencesBrowserController.navigateToInstance(heapWalkerInstanceNode.getInstance());
        }
    }

    private void saveColumnsData() {
        TableColumnModel tableColumnModel = this.fieldsListTable.getColumnModel();
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int n = this.fieldsListTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
    }

    private void showColumnSelectionPopup(JPopupMenu jPopupMenu, JButton jButton) {
        this.initColumnSelectorItems();
        jPopupMenu.show(jButton, jButton.getWidth() - jPopupMenu.getPreferredSize().width, jButton.getHeight());
    }

    private void showPopupMenu(int n, int n2, int n3) {
        HeapWalkerNode heapWalkerNode = (HeapWalkerNode)this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent();
        if (heapWalkerNode instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)heapWalkerNode).isLoop()) {
            this.showLoopOriginItem.setVisible(true);
        } else {
            this.showLoopOriginItem.setVisible(false);
        }
        if (heapWalkerNode.isRoot()) {
            this.showInstanceItem.setEnabled(false);
        } else {
            this.showInstanceItem.setEnabled(heapWalkerNode instanceof HeapWalkerInstanceNode && (!(heapWalkerNode instanceof HeapWalkerFieldNode) || !((HeapWalkerFieldNode)heapWalkerNode).isStatic()));
        }
        this.showGcRootItem.setEnabled(heapWalkerNode instanceof HeapWalkerInstanceNode && (!heapWalkerNode.currentlyHasChildren() || heapWalkerNode.getNChildren() != 1 || !HeapWalkerNodeFactory.isMessageNode(heapWalkerNode.getChild(0))));
        this.showSourceItem.setEnabled(heapWalkerNode instanceof HeapWalkerInstanceNode);
        if (n2 == -1 || n3 == -1) {
            Rectangle rectangle = this.fieldsListTable.getCellRect(n, 0, true);
            if (n2 == -1) {
                n2 = rectangle.x + rectangle.width / 2;
            }
            if (n3 == -1) {
                n3 = rectangle.y + rectangle.height / 2;
            }
        }
        this.tablePopup.show((Component)this.fieldsListTable, n2, n3);
    }

    private class FieldsListTreeTableModel
    extends AbstractTreeTableModel {
        private FieldsListTreeTableModel() {
            super((CCTNode)ReferencesBrowserController.EMPTY_INSTANCE_NODE);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public int getColumnCount() {
            return ReferencesBrowserControllerUI.this.columnCount;
        }

        public String getColumnName(int n) {
            return ReferencesBrowserControllerUI.this.columnNames[n];
        }

        public String getColumnToolTipText(int n) {
            return ReferencesBrowserControllerUI.this.columnToolTips[n];
        }

        public boolean isLeaf(Object object) {
            return ((HeapWalkerNode)object).isLeaf();
        }

        public Object getValueAt(Object object, int n) {
            HeapWalkerNode heapWalkerNode = (HeapWalkerNode)object;
            switch (n) {
                case 0: {
                    return heapWalkerNode;
                }
                case 1: {
                    return heapWalkerNode.getSimpleType();
                }
                case 2: {
                    return heapWalkerNode.getType();
                }
                case 3: {
                    return heapWalkerNode.getValue();
                }
                case 4: {
                    return heapWalkerNode.getSize();
                }
                case 5: {
                    return heapWalkerNode.getRetainedSize();
                }
            }
            return null;
        }
    }

    private class FieldsListTableMouseListener
    extends MouseAdapter {
        private FieldsListTableMouseListener() {
        }

        private void updateSelection(int n) {
            ReferencesBrowserControllerUI.this.fieldsListTable.requestFocusInWindow();
            if (n != -1) {
                ReferencesBrowserControllerUI.this.fieldsListTable.setRowSelectionInterval(n, n);
            } else {
                ReferencesBrowserControllerUI.this.fieldsListTable.clearSelection();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = ReferencesBrowserControllerUI.this.fieldsListTable.rowAtPoint(mouseEvent.getPoint());
            this.updateSelection(n);
            if (mouseEvent.isPopupTrigger()) {
                ReferencesBrowserControllerUI.this.showPopupMenu(n, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = ReferencesBrowserControllerUI.this.fieldsListTable.rowAtPoint(mouseEvent.getPoint());
            this.updateSelection(n);
            if (mouseEvent.isPopupTrigger()) {
                ReferencesBrowserControllerUI.this.showPopupMenu(n, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                HeapWalkerNode heapWalkerNode;
                int n = ReferencesBrowserControllerUI.this.fieldsListTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.getX() >= ((ReferencesBrowserControllerUI)ReferencesBrowserControllerUI.this).fieldsListTable.getTree().getRowBounds((int)n).x - ReferencesBrowserControllerUI.this.fieldsListTable.getTreeCellOffsetX() && n != -1 && (heapWalkerNode = (HeapWalkerNode)ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(n).getLastPathComponent()) instanceof HeapWalkerInstanceNode) {
                    ReferencesBrowserControllerUI.this.performDefaultAction();
                }
            }
        }
    }

    private class FieldsListTableKeyListener
    extends KeyAdapter {
        private FieldsListTableKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow()) != -1) {
                ReferencesBrowserControllerUI.this.showPopupMenu(n, -1, -1);
            }
        }
    }
}

