/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.InstancesListController;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.ui.FieldTreeCellRenderer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InstancesListControllerUI
extends JTitledPanel {
    private static final String VIEW_CAPTION = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_ViewCaption");
    private static final String SHOW_HIDE_COLUMNS_STRING = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_ShowHideColumnsString");
    private static final String INSTANCE_COLUMN_NAME = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_InstanceColumnName");
    private static final String INSTANCE_COLUMN_DESCR = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_InstanceColumnDescr");
    private static final String SIZE_COLUMN_NAME = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_SizeColumnName");
    private static final String SIZE_COLUMN_DESCR = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_SizeColumnDescr");
    private static final String RETAINED_SIZE_COLUMN_NAME = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_RetainedSizeColumnName");
    private static final String RETAINED_SIZE_COLUMN_DESCR = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_RetainedSizeColumnDescr");
    private static final String REACHABLE_SIZE_COLUMN_NAME = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_ReachableSizeColumnName");
    private static final String REACHABLE_SIZE_COLUMN_DESCR = NbBundle.getMessage(InstancesListControllerUI.class, (String)"InstancesListControllerUI_ReachableSizeColumnDescr");
    private static ImageIcon ICON_INSTANCES = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/instances.png", (boolean)false);
    private int columnCount;
    private ExtendedTreeTableModel instancesListTableModel;
    private FieldTreeCellRenderer treeCellRenderer = new FieldTreeCellRenderer();
    private Instance instanceToSelect = null;
    private InstancesListController instancesListController;
    private InstancesListTreeTableModel realInstancesListModel;
    private boolean retainedSizeSupported;
    private JPanel dataPanel;
    private JPopupMenu cornerPopup;
    private JTreeTable instancesListTable;
    private String filterValue = "";
    private String selectedRowContents;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private boolean internalCornerButtonClick = false;
    private boolean selectionSaved = false;
    private boolean sorting = false;
    private boolean sortingOrder = false;
    private int selectedRow;
    private int sortingColumn = 1;

    public InstancesListControllerUI(InstancesListController instancesListController) {
        super(VIEW_CAPTION, (Icon)ICON_INSTANCES, true);
        this.instancesListController = instancesListController;
        this.retainedSizeSupported = instancesListController.getInstancesController().getHeapFragmentWalker().getRetainedSizesStatus() != -1;
        this.columnCount = this.retainedSizeSupported ? 3 : 2;
        this.realInstancesListModel = new InstancesListTreeTableModel();
        this.instancesListTableModel = new ExtendedTreeTableModel((AbstractTreeTableModel)this.realInstancesListModel);
        this.initColumnsData();
        this.initData();
        this.initComponents();
        instancesListController.getInstancesController().getHeapFragmentWalker().addStateListener(new HeapFragmentWalker.StateListener(){

            public void stateChanged(HeapFragmentWalker.StateEvent stateEvent) {
                if (stateEvent.getRetainedSizesStatus() == 3 && stateEvent.isMasterChange()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            InstancesListControllerUI.this.instancesListTableModel.setRealColumnVisibility(2, true);
                            InstancesListControllerUI.this.instancesListTable.createDefaultColumnsFromModel();
                            InstancesListControllerUI.this.instancesListTable.updateTreeTableHeader();
                            InstancesListControllerUI.this.setColumnsData();
                        }
                    });
                }
            }
        });
    }

    public void initColumns() {
        if (this.instancesListTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JavaClass javaClass = InstancesListControllerUI.this.instancesListController.getInstancesController().getSelectedClass();
                    if (javaClass != null && javaClass.isArray()) {
                        if (!InstancesListControllerUI.this.instancesListTableModel.isRealColumnVisible(1)) {
                            InstancesListControllerUI.this.toggleColumnVisibility(1, false);
                        }
                    } else if (InstancesListControllerUI.this.instancesListTableModel.isRealColumnVisible(1)) {
                        InstancesListControllerUI.this.toggleColumnVisibility(1, false);
                    }
                }
            });
        }
    }

    public void makeVisible() {
        if (!this.isShowing()) {
            this.setVisible(true);
        }
    }

    public void refreshView() {
        if (this.instancesListTable != null) {
            HeapWalkerNode heapWalkerNode = (HeapWalkerNode)this.instancesListTableModel.getRoot();
            this.instancesListTable.getTree().setShowsRootHandles(heapWalkerNode instanceof InstancesListController.InstancesListClassNode && heapWalkerNode.getChild(0) instanceof InstancesListController.InstancesListContainerNode);
            this.instancesListTable.updateTreeTable();
        }
    }

    public void selectInstance(Instance instance) {
        if (this.displaysFlatInstances()) {
            this.selectFlatInstance(instance);
        } else if (this.displaysCollapsedInstances()) {
            this.selectCollapsedInstance(instance);
        }
    }

    public void selectPath(TreePath treePath) {
        if (this.instancesListTable == null) {
            return;
        }
        final TreePath treePath2 = treePath;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!InstancesListControllerUI.this.isShowing()) {
                    InstancesListControllerUI.this.setVisible(true);
                }
                InstancesListControllerUI.this.instancesListTable.getTree().setSelectionPath(treePath2);
                Rectangle rectangle = InstancesListControllerUI.this.instancesListTable.getTree().getPathBounds(treePath2);
                if (rectangle != null) {
                    InstancesListControllerUI.this.instancesListTable.scrollRectToVisible(rectangle);
                }
                if (InstancesListControllerUI.this.sorting) {
                    InstancesListControllerUI.this.sorting = false;
                }
            }
        });
    }

    public void update() {
        this.update(false);
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realInstancesListModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.realInstancesListModel.getColumnName(i));
            jCheckBoxMenuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.instancesListTable != null) {
                jCheckBoxMenuItem.setState(this.instancesListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.instancesListTable.getColumnModel();
        this.instancesListTable.setTreeCellRenderer((EnhancedTreeCellRenderer)this.treeCellRenderer);
        for (int i = 0; i < this.instancesListTableModel.getColumnCount(); ++i) {
            int n = this.instancesListTableModel.getRealColumn(i);
            if (n == 0) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(final JCheckBoxMenuItem jCheckBoxMenuItem) {
        final boolean[] blArray = new boolean[1];
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (blArray[0]) {
                    return;
                }
                final int n = Integer.parseInt(actionEvent.getActionCommand());
                if (n == 2 && !InstancesListControllerUI.this.instancesListTableModel.isRealColumnVisible(n)) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            final int n2 = InstancesListControllerUI.this.instancesListController.getInstancesController().getHeapFragmentWalker().computeRetainedSizes(false);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (n2 != 3) {
                                        blArray[0] = true;
                                        jCheckBoxMenuItem.setSelected(!jCheckBoxMenuItem.isSelected());
                                        blArray[0] = false;
                                    } else {
                                        InstancesListControllerUI.this.toggleColumnVisibility(n, true);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    InstancesListControllerUI.this.toggleColumnVisibility(n, true);
                }
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu jPopupMenu) {
        final JButton jButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/lib/profiler/ui/resources/hideColumn.png", (boolean)false));
        jButton.setToolTipText(SHOW_HIDE_COLUMNS_STRING);
        jButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 1));
        }
        jButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    InstancesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (jPopupMenu.isVisible()) {
                    InstancesListControllerUI.this.internalCornerButtonClick = true;
                    jButton.getModel().setArmed(false);
                } else {
                    InstancesListControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        InstancesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                    }
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !InstancesListControllerUI.this.internalCornerButtonClick) {
                    InstancesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        return jButton;
    }

    private boolean displaysCollapsedInstances() {
        HeapWalkerNode heapWalkerNode = (HeapWalkerNode)this.instancesListTableModel.getRoot();
        return heapWalkerNode != null && heapWalkerNode.getNChildren() > 0 && heapWalkerNode.getChild(0) instanceof InstancesListController.InstancesListContainerNode;
    }

    private boolean displaysFlatInstances() {
        HeapWalkerNode heapWalkerNode = (HeapWalkerNode)this.instancesListTableModel.getRoot();
        return heapWalkerNode != null && heapWalkerNode.getNChildren() > 0 && heapWalkerNode.getChild(0) instanceof InstancesListController.InstancesListInstanceNode;
    }

    private void initColumnsData() {
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = INSTANCE_COLUMN_NAME;
        this.columnToolTips[0] = INSTANCE_COLUMN_DESCR;
        this.columnNames[1] = SIZE_COLUMN_NAME;
        this.columnToolTips[1] = SIZE_COLUMN_DESCR;
        if (this.retainedSizeSupported) {
            this.columnNames[2] = RETAINED_SIZE_COLUMN_NAME;
            this.columnToolTips[2] = RETAINED_SIZE_COLUMN_DESCR;
        }
        int n = this.getFontMetrics(this.getFont()).charWidth('W') * 7;
        FieldTreeCellRenderer fieldTreeCellRenderer = new FieldTreeCellRenderer();
        fieldTreeCellRenderer.setLeafIcon(null);
        fieldTreeCellRenderer.setClosedIcon(null);
        fieldTreeCellRenderer.setOpenIcon(null);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n;
        this.columnRenderers[1] = labelTableCellRenderer;
        if (this.retainedSizeSupported) {
            this.columnWidths[1] = n;
            this.columnRenderers[2] = labelTableCellRenderer;
        }
    }

    private void initComponents() {
        this.treeCellRenderer.setLeafIcon(null);
        this.treeCellRenderer.setClosedIcon(null);
        this.treeCellRenderer.setOpenIcon(null);
        if (this.retainedSizeSupported) {
            this.instancesListTableModel.setRealColumnVisibility(2, this.instancesListController.getInstancesController().getHeapFragmentWalker().getRetainedSizesStatus() == 3);
        }
        this.instancesListTable = new JTreeTable((AbstractTreeTableModel)this.instancesListTableModel){

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < InstancesListControllerUI.this.instancesListTableModel.getColumnCount(); ++i) {
                    if (InstancesListControllerUI.this.instancesListTableModel.getRealColumn(i) == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(this.getWidth() - n);
                }
                super.doLayout();
            }
        };
        this.instancesListTable.getTree().setRootVisible(false);
        this.instancesListTable.setSelectionMode(0);
        this.instancesListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.instancesListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.instancesListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.instancesListTable.setShowHorizontalLines(false);
        this.instancesListTable.setShowVerticalLines(true);
        this.instancesListTable.setRowMargin(0);
        this.instancesListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.instancesListTable.getTree().setLargeModel(true);
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>(this.instancesListTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.instancesListTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet(this.instancesListTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.instancesListTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        this.cornerPopup = new JPopupMenu();
        JTreeTablePanel jTreeTablePanel = new JTreeTablePanel(this.instancesListTable);
        jTreeTablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.setLayout(new BorderLayout());
        this.add((Component)jTreeTablePanel, "Center");
        this.instancesListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                HeapWalkerNode heapWalkerNode;
                if (InstancesListControllerUI.this.sorting || listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                Instance instance = null;
                int n = InstancesListControllerUI.this.instancesListTable.getSelectedRow();
                if (n != -1 && (heapWalkerNode = (HeapWalkerNode)InstancesListControllerUI.this.instancesListTable.getTree().getPathForRow(n).getLastPathComponent()) instanceof InstancesListController.InstancesListInstanceNode) {
                    instance = ((InstancesListController.InstancesListInstanceNode)heapWalkerNode).getInstance();
                }
                InstancesListControllerUI.this.instancesListController.instanceSelected(instance);
            }
        });
        this.setPreferredSize(new Dimension(225, 500));
    }

    private void initData() {
        this.instancesListTableModel.setRoot((Object)this.instancesListController.getFilteredSortedInstances(this.filterValue, this.sortingColumn, this.sortingOrder));
        this.refreshView();
    }

    private void restoreSelection() {
        if (this.selectedRowContents != null) {
            this.instancesListTable.selectRowByContents(this.selectedRowContents, 0, true);
        }
        this.selectionSaved = false;
    }

    private void saveSelection() {
        if (this.selectionSaved) {
            return;
        }
        this.selectedRow = this.instancesListTable == null ? -1 : this.instancesListTable.getSelectedRow();
        this.selectedRowContents = null;
        if (this.selectedRow != -1) {
            this.selectedRowContents = this.instancesListTable.getValueAt(this.selectedRow, 0).toString();
        }
        this.selectionSaved = true;
    }

    private void selectCollapsedInstance(Instance instance) {
        HeapWalkerNode heapWalkerNode = (HeapWalkerNode)this.instancesListTableModel.getRoot();
        if (heapWalkerNode instanceof InstancesListController.InstancesListNode) {
            InstancesListController.InstancesListNode instancesListNode = (InstancesListController.InstancesListNode)((Object)heapWalkerNode);
            TreePath treePath = instancesListNode.getInstancePath(instance);
            if (treePath != null) {
                this.selectPath(treePath);
            } else {
                HeapWalkerNode heapWalkerNode2 = this.instancesListController.getInstanceContainer(instance, (InstancesListController.InstancesListClassNode)heapWalkerNode);
                if (heapWalkerNode2 != null) {
                    this.instancesListController.scheduleInstanceSelection(instance);
                    heapWalkerNode2.getChildren();
                }
            }
        }
    }

    private void selectFlatInstance(Instance instance) {
        InstancesListController.InstancesListNode instancesListNode;
        TreePath treePath;
        HeapWalkerNode heapWalkerNode = (HeapWalkerNode)this.instancesListTableModel.getRoot();
        if (heapWalkerNode instanceof InstancesListController.InstancesListNode && (treePath = (instancesListNode = (InstancesListController.InstancesListNode)((Object)heapWalkerNode)).getInstancePath(instance)) != null) {
            this.selectPath(treePath);
        }
    }

    private void showColumnSelectionPopup(JPopupMenu jPopupMenu, JButton jButton) {
        this.initColumnSelectorItems();
        jPopupMenu.show(jButton, jButton.getWidth() - jPopupMenu.getPreferredSize().width, jButton.getHeight());
    }

    private void toggleColumnVisibility(int n, boolean bl) {
        boolean bl2 = false;
        int n2 = this.instancesListTable.getSortingColumn();
        int n3 = this.instancesListTableModel.getRealColumn(n2);
        boolean bl3 = this.instancesListTableModel.isRealColumnVisible(n);
        if (bl3 && n == n3) {
            n2 = n2 + 1 == this.instancesListTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
            n3 = this.instancesListTableModel.getRealColumn(n2);
            bl2 = true;
        }
        this.instancesListTableModel.setRealColumnVisibility(n, !bl3);
        this.instancesListTable.createDefaultColumnsFromModel();
        this.instancesListTable.updateTreeTableHeader();
        n2 = this.instancesListTableModel.getVirtualColumn(n3);
        if (bl2) {
            if (bl) {
                this.instancesListTableModel.sortByColumn(n2, this.instancesListTableModel.getInitialSorting(n2));
            } else {
                this.sortingOrder = this.instancesListTableModel.getInitialSorting(n2);
                this.sortingColumn = n2;
            }
            this.instancesListTable.updateTreeTable();
        }
        this.instancesListTable.setSortingColumn(n2);
        this.instancesListTable.setSortingOrder(this.sortingOrder);
        this.instancesListTable.getTableHeader().repaint();
        this.setColumnsData();
    }

    private void update(boolean bl) {
        this.makeVisible();
        this.initData();
        if (!bl && this.instancesListTable != null) {
            this.instancesListTable.resetTreeCellOffsetX();
        }
    }

    private class InstancesListTreeTableModel
    extends AbstractTreeTableModel {
        private InstancesListTreeTableModel() {
            super((CCTNode)InstancesListController.EMPTY_INSTANCE_NODE, true, InstancesListControllerUI.this.sortingColumn, InstancesListControllerUI.this.sortingOrder);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public int getColumnCount() {
            return InstancesListControllerUI.this.columnCount;
        }

        public String getColumnName(int n) {
            return InstancesListControllerUI.this.columnNames[n];
        }

        public String getColumnToolTipText(int n) {
            return InstancesListControllerUI.this.columnToolTips[n];
        }

        public boolean getInitialSorting(int n) {
            switch (n) {
                case 0: {
                    return true;
                }
            }
            return false;
        }

        public boolean isLeaf(Object object) {
            return ((HeapWalkerNode)object).isLeaf();
        }

        public Object getValueAt(Object object, int n) {
            if (object instanceof InstancesListController.InstancesListNode) {
                InstancesListController.InstancesListNode instancesListNode = (InstancesListController.InstancesListNode)object;
                switch (n) {
                    case 0: {
                        return instancesListNode;
                    }
                    case 1: {
                        return instancesListNode.getSize();
                    }
                    case 2: {
                        return instancesListNode.getRetainedSize();
                    }
                }
                return null;
            }
            HeapWalkerNode heapWalkerNode = (HeapWalkerNode)object;
            switch (n) {
                case 0: {
                    return heapWalkerNode;
                }
            }
            return "";
        }

        public void sortByColumn(int n, boolean bl) {
            HeapWalkerNode heapWalkerNode;
            int n2;
            InstancesListControllerUI.this.sortingColumn = n;
            InstancesListControllerUI.this.sortingOrder = bl;
            Instance instance = InstancesListControllerUI.this.instancesListController.getSelectedInstance();
            if (instance != null) {
                InstancesListControllerUI.this.instancesListController.scheduleInstanceSelection(instance);
            } else if (InstancesListControllerUI.this.instancesListTable != null && (n2 = InstancesListControllerUI.this.instancesListTable.getSelectedRow()) != -1 && (heapWalkerNode = (HeapWalkerNode)InstancesListControllerUI.this.instancesListTable.getTree().getPathForRow(n2).getLastPathComponent()) instanceof InstancesListController.InstancesListContainerNode) {
                InstancesListControllerUI.this.instancesListController.scheduleContainerSelection(heapWalkerNode.getParent().getIndexOfChild(heapWalkerNode));
            }
            if (InstancesListControllerUI.this.isShowing()) {
                InstancesListControllerUI.this.sorting = true;
            }
            InstancesListControllerUI.this.update(true);
        }
    }
}

