/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.Color;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.OQLSupport;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.OQLControllerUI;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.engine.api.OQLException;
import org.netbeans.modules.profiler.oql.engine.api.ReferenceChain;
import org.openide.util.NbBundle;

public class OQLController
extends AbstractTopLevelController
implements NavigationHistoryManager.NavigationHistoryCapable {
    private static final String CANNOT_RESOLVE_CLASS_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveClassMsg");
    private static final String CANNOT_RESOLVE_INSTANCE_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveInstanceMsg");
    private HeapFragmentWalker heapFragmentWalker;
    private ResultsController resultsController;
    private QueryController queryController;
    private SavedController savedController;
    private final ExecutorService progressUpdater = Executors.newSingleThreadExecutor();
    private final AtomicBoolean analysisRunning = new AtomicBoolean(false);
    private OQLEngine engine = null;

    public OQLController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        if (OQLEngine.isOQLSupported()) {
            this.engine = new OQLEngine(heapFragmentWalker.getHeapFragment());
            this.resultsController = new ResultsController(this);
            this.queryController = new QueryController(this);
            this.savedController = new SavedController(this);
        }
    }

    public void executeQuery(String string) {
        this.executeQueryImpl(string);
    }

    public void cancelQuery() {
        this.finalizeQuery();
    }

    public boolean isQueryRunning() {
        return this.analysisRunning.get();
    }

    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public ResultsController getResultsController() {
        return this.resultsController;
    }

    public QueryController getQueryController() {
        return this.queryController;
    }

    public SavedController getSavedController() {
        return this.savedController;
    }

    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[]{this.resultsController.getPresenter(), this.queryController.getPresenter(), this.savedController.getPresenter()};
    }

    protected AbstractButton createControllerPresenter() {
        return ((OQLControllerUI)this.getPanel()).getPresenter();
    }

    protected JPanel createControllerUI() {
        return new OQLControllerUI(this);
    }

    public NavigationHistoryManager.Configuration getCurrentConfiguration() {
        return new NavigationHistoryManager.Configuration();
    }

    public void configure(NavigationHistoryManager.Configuration configuration) {
        this.heapFragmentWalker.switchToHistoryOQLView();
    }

    private void executeQueryImpl(final String string) {
        final DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(0, 10, 0, 100);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowserUtils.performTask(new Runnable(){

                    public void run() {
                        final AtomicInteger atomicInteger = new AtomicInteger(100);
                        defaultBoundedRangeModel.setMaximum(100);
                        final StringBuilder stringBuilder = new StringBuilder();
                        final boolean[] blArray = new boolean[1];
                        Color color = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
                        final String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
                        stringBuilder.append("<table border='0' width='100%'>");
                        try {
                            OQLController.this.analysisRunning.compareAndSet(false, true);
                            OQLController.this.queryController.queryStarted(defaultBoundedRangeModel);
                            OQLController.this.progressUpdater.submit(new Runnable(){

                                public void run() {
                                    while (OQLController.this.analysisRunning.get()) {
                                        int n = defaultBoundedRangeModel.getValue() + 10;
                                        if (n > defaultBoundedRangeModel.getMaximum()) {
                                            n = defaultBoundedRangeModel.getMinimum();
                                        }
                                        defaultBoundedRangeModel.setValue(n);
                                        try {
                                            Thread.sleep(200L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            Thread.currentThread().interrupt();
                                        }
                                    }
                                }
                            });
                            OQLController.this.engine.executeQuery(string, new OQLEngine.ObjectVisitor(){

                                public boolean visit(Object object) {
                                    stringBuilder.append(blArray[0] ? "<tr><td style='background-color: " + string + ";'>" : "<tr><td>");
                                    blArray[0] = !blArray[0];
                                    OQLController.this.dump(object, stringBuilder);
                                    stringBuilder.append("</td></tr>");
                                    return atomicInteger.decrementAndGet() == 0 || !OQLController.this.analysisRunning.get();
                                }
                            });
                            if (atomicInteger.get() == 0) {
                                stringBuilder.append("<tr><td><h4>Too many results. Please, refine your query.</h4></td></tr>");
                            } else if (atomicInteger.get() == 100) {
                                stringBuilder.append("<tr><td><h4>");
                                stringBuilder.append(NbBundle.getMessage(OQLController.class, (String)"OQL_NO_RESULTS_MSG"));
                                stringBuilder.append("</h4></td></tr>");
                            }
                            stringBuilder.append("</table>");
                            OQLController.this.resultsController.setResult(stringBuilder.toString());
                            OQLController.this.finalizeQuery();
                        }
                        catch (OQLException oQLException) {
                            StringBuilder stringBuilder2 = new StringBuilder();
                            stringBuilder2.append("<h2>").append(NbBundle.getMessage(OQLController.class, (String)"OQL_QUERY_ERROR")).append("</h2>");
                            stringBuilder2.append(NbBundle.getMessage(OQLController.class, (String)"OQL_QUERY_PLZ_CHECK"));
                            stringBuilder2.append("<hr>");
                            stringBuilder2.append(oQLException.getLocalizedMessage().replace("\n", "<br>").replace("\r", "<br>"));
                            OQLController.this.resultsController.setResult(stringBuilder2.toString());
                            OQLController.this.finalizeQuery();
                        }
                    }
                });
            }
        });
    }

    private void finalizeQuery() {
        this.analysisRunning.compareAndSet(true, false);
        this.queryController.queryFinished();
    }

    private void dump(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            return;
        }
        if (object instanceof Instance) {
            Instance instance = (Instance)object;
            stringBuilder.append(OQLController.printInstance(instance));
        } else if (object instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)object;
            stringBuilder.append(OQLController.printClass(javaClass));
        } else if (object instanceof ReferenceChain) {
            stringBuilder.append("<h4>Reference Chain</h4>");
            for (ReferenceChain referenceChain = (ReferenceChain)object; referenceChain != null; referenceChain = referenceChain.getNext()) {
                stringBuilder.append(OQLController.printInstance(referenceChain.getObj())).append("&gt;");
            }
            stringBuilder.delete(stringBuilder.length() - 5, stringBuilder.length());
        } else if (object instanceof Map) {
            Set set = ((Map)object).entrySet();
            stringBuilder.append("<span>{");
            for (Map.Entry entry : set) {
                this.dump(entry.getKey(), stringBuilder);
                stringBuilder.append(" = ");
                this.dump(entry.getValue(), stringBuilder);
                stringBuilder.append(", ");
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            stringBuilder.append("}</span>");
        } else {
            stringBuilder.append(object.toString());
        }
    }

    private OQLEngine getEngine() {
        return this.engine;
    }

    private void showURL(URL uRL) {
        String string = uRL.toString();
        if (string.startsWith("file://instance/")) {
            string = string.substring("file://instance/".length());
            int n = string.indexOf("#");
            int n2 = string.indexOf("@");
            String string2 = null;
            if (n > -1 || n2 > -1) {
                string2 = string.substring(0, Math.max(n, n2));
            }
            Instance instance = null;
            String string3 = null;
            if (n > -1) {
                string3 = string.substring(n + 1);
                JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(string2);
                if (javaClass != null) {
                    List list = javaClass.getInstances();
                    int n3 = Integer.parseInt(string3);
                    if (n3 <= list.size()) {
                        instance = (Instance)list.get(n3 - 1);
                    }
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, string2));
                }
            } else if (n2 > -1) {
                string3 = string.substring(n2 + 1);
                instance = this.heapFragmentWalker.getHeapFragment().getInstanceByID(Long.parseLong(string3));
            }
            if (instance != null) {
                this.heapFragmentWalker.getClassesController().showInstance(instance);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_INSTANCE_MSG, string3, string2));
            }
        } else if (string.startsWith("file://class/")) {
            string = string.substring("file://class/".length());
            JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(Long.parseLong(string));
            if (javaClass != null) {
                this.heapFragmentWalker.getClassesController().showClass(javaClass);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, string));
            }
        }
    }

    private static String printClass(JavaClass javaClass) {
        String string;
        if (javaClass == null) {
            return NbBundle.getMessage(Utils.class, (String)"LBL_UnknownClass");
        }
        String string2 = string = javaClass.getName();
        String string3 = "";
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(58);
        if (n2 == -1) {
            n2 = string.lastIndexOf(59);
        }
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            string3 = "." + string.substring(n2 + 1);
        }
        String string4 = string.substring(n + 1);
        return "<a href='file://class/" + javaClass.getJavaClassId() + "'>" + string2 + "</a>" + string3;
    }

    private static String printInstance(Instance instance) {
        String string = instance.getJavaClass().getName();
        return "<a href='file://instance/" + string + "@" + instance.getInstanceId() + "'>" + string + '#' + instance.getInstanceNumber() + "</a>";
    }

    public static class SavedController
    extends AbstractController {
        private OQLController oqlController;

        public SavedController(OQLController oQLController) {
            this.oqlController = oQLController;
        }

        public OQLController getOQLController() {
            return this.oqlController;
        }

        public void saveQuery(String string) {
            ((OQLControllerUI.SavedUI)((Object)this.getPanel())).saveQuery(string);
        }

        public static void loadData(OQLSupport.OQLTreeModel oQLTreeModel) {
            OQLSupport.loadModel(oQLTreeModel);
        }

        public static void saveData(OQLSupport.OQLTreeModel oQLTreeModel) {
            OQLSupport.saveModel(oQLTreeModel);
        }

        protected AbstractButton createControllerPresenter() {
            return ((OQLControllerUI.SavedUI)((Object)this.getPanel())).getPresenter();
        }

        protected JPanel createControllerUI() {
            OQLControllerUI.SavedUI savedUI = new OQLControllerUI.SavedUI(this);
            return savedUI;
        }
    }

    public static class QueryController
    extends AbstractController {
        private OQLController oqlController;

        public QueryController(OQLController oQLController) {
            this.oqlController = oQLController;
        }

        public OQLController getOQLController() {
            return this.oqlController;
        }

        public void setQuery(String string) {
            ((OQLControllerUI.QueryUI)((Object)this.getPanel())).setQuery(string);
        }

        private void queryStarted(BoundedRangeModel boundedRangeModel) {
            ((OQLControllerUI.QueryUI)((Object)this.getPanel())).queryStarted(boundedRangeModel);
        }

        private void queryFinished() {
            ((OQLControllerUI.QueryUI)((Object)this.getPanel())).queryFinished();
        }

        protected AbstractButton createControllerPresenter() {
            return ((OQLControllerUI.QueryUI)((Object)this.getPanel())).getPresenter();
        }

        protected JPanel createControllerUI() {
            return new OQLControllerUI.QueryUI(this, this.oqlController.getEngine());
        }
    }

    public static class ResultsController
    extends AbstractController {
        private OQLController oqlController;

        public ResultsController(OQLController oQLController) {
            this.oqlController = oQLController;
        }

        public void setResult(String string) {
            ((OQLControllerUI.ResultsUI)((Object)this.getPanel())).setResult(string);
        }

        public void showURL(URL uRL) {
            this.oqlController.showURL(uRL);
        }

        public OQLController getOQLController() {
            return this.oqlController;
        }

        protected AbstractButton createControllerPresenter() {
            return ((OQLControllerUI.ResultsUI)((Object)this.getPanel())).getPresenter();
        }

        protected JPanel createControllerUI() {
            return new OQLControllerUI.ResultsUI(this);
        }
    }
}

