/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SelfResizingPanel
extends JPanel {
    private boolean painted = false;

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (!this.painted) {
            this.paintedFirstTime(graphics);
            this.painted = true;
        }
    }

    protected void paintedFirstTime(Graphics graphics) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelfResizingPanel.this.adjustWindowSize();
            }
        });
    }

    protected void adjustWindowSize() {
        Dimension dimension = this.getSize();
        int n = dimension.height;
        int n2 = this.getPreferredSize().height;
        if (n < n2) {
            int n3 = n2 - n;
            Window window = SwingUtilities.getWindowAncestor(this);
            Dimension dimension2 = window.getSize();
            window.setSize(dimension2.width, dimension2.height + n3);
        }
    }

    protected boolean isPainted() {
        return this.painted;
    }
}

