/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.AlgorithmSuite;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic128;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic128Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic128Sha256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic128Sha256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic192;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic192Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic192Sha256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic192Sha256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic256Sha256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.Basic256Sha256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.TripleDes;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.TripleDesRsa15;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.TripleDesSha256;
import org.netbeans.modules.websvc.wsitmodelext.security.algosuite.TripleDesSha256Rsa15;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

public class AlgoSuiteModelHelper {
    private static HashMap<ConfigVersion, AlgoSuiteModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private AlgoSuiteModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final AlgoSuiteModelHelper getInstance(ConfigVersion configVersion) {
        AlgoSuiteModelHelper algoSuiteModelHelper = instances.get(configVersion);
        if (algoSuiteModelHelper == null) {
            algoSuiteModelHelper = new AlgoSuiteModelHelper(configVersion);
            instances.put(configVersion, algoSuiteModelHelper);
        }
        return algoSuiteModelHelper;
    }

    public static String getAlgorithmSuite(WSDLComponent wSDLComponent) {
        WSDLComponent wSDLComponent2 = AlgoSuiteModelHelper.getAlgorithmSuiteElement(wSDLComponent);
        if (wSDLComponent2 != null) {
            if (wSDLComponent2 instanceof Basic128) {
                return ComboConstants.BASIC128;
            }
            if (wSDLComponent2 instanceof Basic192) {
                return ComboConstants.BASIC192;
            }
            if (wSDLComponent2 instanceof Basic256) {
                return ComboConstants.BASIC256;
            }
            if (wSDLComponent2 instanceof TripleDes) {
                return ComboConstants.TRIPLEDES;
            }
            if (wSDLComponent2 instanceof Basic256Rsa15) {
                return ComboConstants.BASIC256RSA15;
            }
            if (wSDLComponent2 instanceof Basic192Rsa15) {
                return ComboConstants.BASIC192RSA15;
            }
            if (wSDLComponent2 instanceof Basic128Rsa15) {
                return ComboConstants.BASIC128RSA15;
            }
            if (wSDLComponent2 instanceof TripleDesRsa15) {
                return ComboConstants.TRIPLEDESRSA15;
            }
            if (wSDLComponent2 instanceof Basic256Sha256) {
                return ComboConstants.BASIC256SHA256;
            }
            if (wSDLComponent2 instanceof Basic192Sha256) {
                return ComboConstants.BASIC192SHA256;
            }
            if (wSDLComponent2 instanceof Basic128Sha256) {
                return ComboConstants.BASIC128SHA256;
            }
            if (wSDLComponent2 instanceof TripleDesSha256) {
                return ComboConstants.TRIPLEDESSHA256;
            }
            if (wSDLComponent2 instanceof Basic256Sha256Rsa15) {
                return ComboConstants.BASIC256SHA256RSA15;
            }
            if (wSDLComponent2 instanceof Basic192Sha256Rsa15) {
                return ComboConstants.BASIC192SHA256RSA15;
            }
            if (wSDLComponent2 instanceof Basic128Sha256Rsa15) {
                return ComboConstants.BASIC128SHA256RSA15;
            }
            if (wSDLComponent2 instanceof TripleDesSha256Rsa15) {
                return ComboConstants.TRIPLEDESSHA256RSA15;
            }
        }
        return null;
    }

    private static WSDLComponent getAlgorithmSuiteElement(WSDLComponent wSDLComponent) {
        List list;
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            wSDLComponent = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        }
        if (wSDLComponent == null) {
            return null;
        }
        Policy policy = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent, Policy.class, false);
        AlgorithmSuite algorithmSuite = (AlgorithmSuite)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, AlgorithmSuite.class, false);
        if ((policy = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)algorithmSuite, Policy.class, false)) != null && (list = policy.getExtensibilityElements()) != null && !list.isEmpty()) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(0);
            return extensibilityElement;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlgorithmSuite(WSDLComponent wSDLComponent, String string) {
        WSDLModel wSDLModel = wSDLComponent.getModel();
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        WSDLComponent wSDLComponent2 = wSDLComponent;
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            Policy policy2;
            QName qName = null;
            if (ComboConstants.BASIC128.equals(string)) {
                qName = SecurityPolicyQName.BASIC128.getQName(this.configVersion);
            } else if (ComboConstants.BASIC192.equals(string)) {
                qName = SecurityPolicyQName.BASIC192.getQName(this.configVersion);
            } else if (ComboConstants.BASIC256.equals(string)) {
                qName = SecurityPolicyQName.BASIC256.getQName(this.configVersion);
            } else if (ComboConstants.TRIPLEDES.equals(string)) {
                qName = SecurityPolicyQName.TRIPLEDES.getQName(this.configVersion);
            } else if (ComboConstants.BASIC128RSA15.equals(string)) {
                qName = SecurityPolicyQName.BASIC128RSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC192RSA15.equals(string)) {
                qName = SecurityPolicyQName.BASIC192RSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC256RSA15.equals(string)) {
                qName = SecurityPolicyQName.BASIC256RSA15.getQName(this.configVersion);
            } else if (ComboConstants.TRIPLEDESRSA15.equals(string)) {
                qName = SecurityPolicyQName.TRIPLEDESRSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC128SHA256.equals(string)) {
                qName = SecurityPolicyQName.BASIC128SHA256.getQName(this.configVersion);
            } else if (ComboConstants.BASIC192SHA256.equals(string)) {
                qName = SecurityPolicyQName.BASIC192SHA256.getQName(this.configVersion);
            } else if (ComboConstants.BASIC256SHA256.equals(string)) {
                qName = SecurityPolicyQName.BASIC256SHA256.getQName(this.configVersion);
            } else if (ComboConstants.TRIPLEDESSHA256.equals(string)) {
                qName = SecurityPolicyQName.TRIPLEDESSHA256.getQName(this.configVersion);
            } else if (ComboConstants.BASIC128SHA256RSA15.equals(string)) {
                qName = SecurityPolicyQName.BASIC128SHA256RSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC192SHA256RSA15.equals(string)) {
                qName = SecurityPolicyQName.BASIC192SHA256RSA15.getQName(this.configVersion);
            } else if (ComboConstants.BASIC256SHA256RSA15.equals(string)) {
                qName = SecurityPolicyQName.BASIC256SHA256RSA15.getQName(this.configVersion);
            } else if (ComboConstants.TRIPLEDESSHA256RSA15.equals(string)) {
                qName = SecurityPolicyQName.TRIPLEDESSHA256RSA15.getQName(this.configVersion);
            }
            PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
            AlgorithmSuite algorithmSuite = (AlgorithmSuite)policyModelHelper.createElement(wSDLComponent2, SecurityPolicyQName.ALGORITHMSUITE.getQName(this.configVersion), AlgorithmSuite.class, !(wSDLComponent2 instanceof Policy));
            List list = algorithmSuite.getExtensibilityElements(Policy.class);
            if (list != null && !list.isEmpty()) {
                for (Policy policy2 : list) {
                    algorithmSuite.removeExtensibilityElement((ExtensibilityElement)policy2);
                }
            }
            Policy policy3 = (Policy)policyModelHelper.createElement((WSDLComponent)algorithmSuite, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
            policy2 = (ExtensibilityElement)wSDLComponentFactory.create((WSDLComponent)policy3, qName);
            policy3.addExtensibilityElement((ExtensibilityElement)policy2);
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }
}

