/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageAttachments;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageBody;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageElement;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageHeader;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.TargetElement;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.AddHeaderPanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetsPanel
extends JPanel {
    private WSDLComponent comp;
    private Binding binding;
    private Vector<Vector> targetsModel;
    private MessagePartsModel targetsTableDataModel;
    private Vector<String> columnNames = new Vector();
    private AddHeaderPanel addHeaderPanel;
    boolean inSync = false;
    private JButton addAttachButton;
    private JButton addBodyButton;
    private JButton addHeaderButton;
    private JButton addPartButton;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JButton removeButton;

    public TargetsPanel(WSDLComponent wSDLComponent) {
        WSDLComponent wSDLComponent2;
        this.comp = wSDLComponent;
        for (wSDLComponent2 = wSDLComponent; !(wSDLComponent2 instanceof Binding) && wSDLComponent2 != null; wSDLComponent2 = (WSDLComponent)wSDLComponent2.getParent()) {
        }
        if (wSDLComponent2 != null && wSDLComponent2 instanceof Binding) {
            this.binding = (Binding)wSDLComponent2;
        }
        this.initComponents();
        this.columnNames.add(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Targets_MessagePart"));
        this.columnNames.add(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Targets_Sign"));
        this.columnNames.add(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Targets_Encrypt"));
        this.columnNames.add(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Targets_Require"));
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        this.targetsModel = SecurityPolicyModelHelper.getTargets(this.comp);
        this.targetsTableDataModel = new MessagePartsModel(this.getTargetsModel(), this.columnNames);
        this.jTable1.setModel(this.targetsTableDataModel);
        this.jTable1.doLayout();
        this.jTable1.setDefaultEditor(MessageElement.class, new XPathTableCellEditor());
        this.jTable1.getColumnModel().getColumn(0).setCellEditor(new XPathTableCellEditor());
        this.enableDisable();
        this.inSync = false;
    }

    private AddHeaderPanel getAddHeaderPanel() {
        return new AddHeaderPanel(this.binding);
    }

    private void saveTargetsModel() {
        if (!this.inSync) {
            SecurityPolicyModelHelper.getInstance(PolicyModelHelper.getConfigVersion(this.comp)).setTargets(this.comp, this.getTargetsModel());
            this.jTable1.setModel(new MessagePartsModel(this.getTargetsModel(), this.columnNames));
        }
    }

    private void enableDisable() {
    }

    private void initComponents() {
        this.addHeaderButton = new JButton();
        this.removeButton = new JButton();
        this.addPartButton = new JButton();
        this.addBodyButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.addAttachButton = new JButton();
        this.addHeaderButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_AddHeader"));
        this.addHeaderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetsPanel.this.addHeaderButtonActionPerformed(actionEvent);
            }
        });
        this.removeButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetsPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.addPartButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_AddXPath"));
        this.addPartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetsPanel.this.addPartButtonActionPerformed(actionEvent);
            }
        });
        this.addBodyButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_AddBody"));
        this.addBodyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetsPanel.this.addBodyButtonActionPerformed(actionEvent);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setShowVerticalLines(false);
        this.jTable1.setVerifyInputWhenFocusTarget(false);
        this.jScrollPane2.setViewportView(this.jTable1);
        this.addAttachButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_AddAttachment"));
        this.addAttachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetsPanel.this.addAttachButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 358, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.addBodyButton, -1, -1, Short.MAX_VALUE).add((Component)this.addPartButton, -1, -1, Short.MAX_VALUE).add((Component)this.addHeaderButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeButton, -1, -1, Short.MAX_VALUE)).add((Component)this.addAttachButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addAttachButton, this.addBodyButton, this.addHeaderButton, this.addPartButton, this.removeButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addBodyButton).addPreferredGap(0).add((Component)this.addHeaderButton).addPreferredGap(0).add((Component)this.addPartButton).addPreferredGap(0).add((Component)this.addAttachButton).add(7, 7, 7).add((Component)this.removeButton)).add((Component)this.jScrollPane2, -1, 183, Short.MAX_VALUE)).addContainerGap()));
    }

    private void addBodyButtonActionPerformed(ActionEvent actionEvent) {
        MessageBody messageBody = new MessageBody();
        if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), messageBody) == null) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(0, messageBody);
            vector.add(1, Boolean.TRUE);
            vector.add(2, Boolean.FALSE);
            vector.add(3, Boolean.FALSE);
            this.getTargetsModel().add(vector);
            this.saveTargetsModel();
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jTable1.getSelectedRows();
        ArrayList<Vector> arrayList = new ArrayList<Vector>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getTargetsModel().get(nArray[i]));
        }
        for (Object e : arrayList) {
            this.getTargetsModel().remove(e);
        }
        this.saveTargetsModel();
    }

    private void addPartButtonActionPerformed(ActionEvent actionEvent) {
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TargetsPanel.class, (String)"WARNING_DISABLE_OPTIMSECURITY")));
        if (NotifyDescriptor.OK_OPTION.equals(object)) {
            MessageElement messageElement = new MessageElement(NbBundle.getMessage(TargetsPanel.class, (String)"TXT_EditHere"));
            Vector<Object> vector = new Vector<Object>();
            vector.add(0, messageElement);
            vector.add(1, Boolean.FALSE);
            vector.add(2, Boolean.FALSE);
            vector.add(3, Boolean.TRUE);
            this.getTargetsModel().add(vector);
            this.jTable1.updateUI();
        }
    }

    private void addHeaderButtonActionPerformed(ActionEvent actionEvent) {
        this.addHeaderPanel = this.getAddHeaderPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.addHeaderPanel, NbBundle.getMessage(TargetsPanel.class, (String)"LBL_SignEncryptChooser_AddHeaderTitle"), true, 2, DialogDescriptor.CANCEL_OPTION, 0, new HelpCtx(TargetsPanel.class), null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(DialogDescriptor.OK_OPTION) && this.addHeaderPanel != null) {
            if (this.addHeaderPanel.isAllHeaders()) {
                Vector<Object> vector;
                MessageHeader messageHeader;
                for (String string : MessageHeader.ADDRESSING_HEADERS) {
                    messageHeader = new MessageHeader(string);
                    if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), messageHeader) != null) continue;
                    vector = new Vector<Object>();
                    vector.add(0, messageHeader);
                    vector.add(1, Boolean.TRUE);
                    vector.add(2, Boolean.FALSE);
                    vector.add(3, Boolean.FALSE);
                    this.getTargetsModel().add(vector);
                }
                for (String string : MessageHeader.RM_HEADERS) {
                    messageHeader = new MessageHeader(string);
                    if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), messageHeader) != null) continue;
                    vector = new Vector();
                    vector.add(0, messageHeader);
                    vector.add(1, Boolean.TRUE);
                    vector.add(2, Boolean.FALSE);
                    vector.add(3, Boolean.FALSE);
                    this.getTargetsModel().add(vector);
                }
            } else {
                String string = this.addHeaderPanel.getHeader();
                MessageHeader messageHeader = new MessageHeader(string);
                if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), messageHeader) == null) {
                    Vector<Object> vector = new Vector<Object>();
                    vector.add(0, messageHeader);
                    vector.add(1, Boolean.TRUE);
                    vector.add(2, Boolean.FALSE);
                    vector.add(3, Boolean.FALSE);
                    this.getTargetsModel().add(vector);
                }
            }
            this.saveTargetsModel();
        }
    }

    private void addAttachButtonActionPerformed(ActionEvent actionEvent) {
        MessageAttachments messageAttachments = new MessageAttachments();
        if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), messageAttachments) == null) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(0, messageAttachments);
            vector.add(1, Boolean.TRUE);
            vector.add(2, Boolean.FALSE);
            vector.add(3, Boolean.FALSE);
            this.getTargetsModel().add(vector);
            this.saveTargetsModel();
        }
    }

    public Vector<Vector> getTargetsModel() {
        return this.targetsModel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessagePartsModel
    extends DefaultTableModel {
        public MessagePartsModel(Vector<Vector> vector, Vector vector2) {
            super(vector, vector2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            Vector vector = TargetsPanel.this.getTargetsModel().get(n);
            if (n2 == 0) {
                return vector.get(0) instanceof MessageElement;
            }
            if (n2 == 1 || n2 == 2) {
                return true;
            }
            if (n2 == 3) {
                return vector.get(0) instanceof MessageElement;
            }
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TargetElement.class;
            }
            return Boolean.class;
        }
    }

    public static class XPathTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField component = new JTextField();

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                this.component.setText(((MessageElement)object).getElement());
                return this.component;
            }
            return null;
        }

        public Object getCellEditorValue() {
            return new MessageElement(this.component.getText());
        }
    }
}

