/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.wsdl.websvcmgr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WsdlDataImpl;

public class WebServiceListManager
implements PropertyChangeListener {
    private List<WsdlDataImpl> wsdlServices;
    private static WebServiceListManager mgr;
    private boolean initialized;

    public static WebServiceListManager getInstance() {
        if (mgr == null) {
            mgr = new WebServiceListManager();
        }
        return mgr;
    }

    private WebServiceListManager() {
    }

    public void init() {
        if (!this.initialized) {
            this.initialized = true;
            this.wsdlServices = new ArrayList<WsdlDataImpl>();
            SaasServicesModel saasServicesModel = SaasServicesModel.getInstance();
            saasServicesModel.addPropertyChangeListener(this);
            SaasGroup saasGroup = saasServicesModel.getRootGroup();
            List<SaasGroup> list = saasGroup.getChildrenGroups();
            for (SaasGroup saasGroup2 : list) {
                List<Saas> list2 = saasGroup2.getServices();
                for (Saas saas : list2) {
                    if (!(saas instanceof WsdlSaas)) continue;
                    WsdlSaas wsdlSaas = (WsdlSaas)saas;
                    this.wsdlServices.add(new WsdlDataImpl(wsdlSaas.getDelegate().getUrl()));
                }
            }
        }
    }

    public boolean wsdlDataExistsFor(String string) {
        this.init();
        for (WsdlDataImpl wsdlDataImpl : this.wsdlServices) {
            if (!wsdlDataImpl.getOriginalWsdlUrl().equals(string)) continue;
            return true;
        }
        return false;
    }

    public WsdlDataImpl findWsdlData(String string) {
        this.init();
        for (WsdlDataImpl wsdlDataImpl : this.wsdlServices) {
            if (!wsdlDataImpl.getOriginalWsdlUrl().equals(string)) continue;
            return wsdlDataImpl;
        }
        return null;
    }

    public WsdlDataImpl findReadyWsdlData(String string) {
        WsdlDataImpl wsdlDataImpl = this.findWsdlData(string);
        if (wsdlDataImpl != null && wsdlDataImpl.isReady()) {
            return wsdlDataImpl;
        }
        return null;
    }

    public void addWsdlData(WsdlDataImpl wsdlDataImpl) {
        this.wsdlServices.add(wsdlDataImpl);
    }

    public void removeWsdlData(WsdlDataImpl wsdlDataImpl) {
        if (this.wsdlDataExistsFor(wsdlDataImpl.getOriginalWsdlUrl())) {
            this.wsdlServices.remove(wsdlDataImpl);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

