/*
 * Decompiled with CFR 0.152.
 */
package jdbc_adapter;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Timer;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class JdbcMySQLSpec {
    private static final byte BACKQUOTE = 96;
    private static final byte[] QUOTED_DOT = new byte[]{96, 46, 96};
    private static final byte[] ZERO = new byte[]{92, 48};
    private static final byte[] NEWLINE = new byte[]{92, 110};
    private static final byte[] CARRIAGE = new byte[]{92, 114};
    private static final byte[] ZED = new byte[]{92, 90};
    private static final byte[] DBL = new byte[]{92, 34};
    private static final byte[] SINGLE = new byte[]{92, 39};
    private static final byte[] ESCAPE = new byte[]{92, 92};

    public static void load(RubyModule rubyModule) {
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("MySQL");
        rubyModule2.defineAnnotatedMethods(JdbcMySQLSpec.class);
    }

    @JRubyMethod(name={"quote_string"}, required=1, frame=false)
    public static IRubyObject quote_string(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ByteList byteList = ((RubyString)iRubyObject2).getByteList();
        ByteList byteList2 = new ByteList();
        byteList2.append(byteList);
        for (int i = byteList2.begin; i < byteList2.begin + byteList2.realSize; ++i) {
            byte[] byArray = null;
            switch (byteList2.bytes[i]) {
                case 0: {
                    byArray = ZERO;
                    break;
                }
                case 10: {
                    byArray = NEWLINE;
                    break;
                }
                case 13: {
                    byArray = CARRIAGE;
                    break;
                }
                case 26: {
                    byArray = ZED;
                    break;
                }
                case 34: {
                    byArray = DBL;
                    break;
                }
                case 39: {
                    byArray = SINGLE;
                    break;
                }
                case 92: {
                    byArray = ESCAPE;
                }
            }
            if (byArray == null) continue;
            byteList2.replace(i, 1, byArray);
            i += byArray.length - 1;
        }
        if (byteList2.length() == byteList.length()) {
            return iRubyObject2;
        }
        return threadContext.getRuntime().newString(byteList2);
    }

    @JRubyMethod(name={"quote_column_name"}, frame=false)
    public static IRubyObject quote_column_name(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ByteList byteList = iRubyObject2.asString().getByteList();
        ByteList byteList2 = new ByteList();
        byteList2.insert(0, 96);
        byteList2.append(byteList);
        byteList2.append((byte)96);
        return threadContext.getRuntime().newString(byteList2);
    }

    @JRubyMethod(name={"quote_table_name"}, frame=false)
    public static IRubyObject quote_table_name(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ByteList byteList = iRubyObject2.asString().getByteList();
        ByteList byteList2 = new ByteList();
        byteList2.insert(0, 96);
        byteList2.append(byteList);
        int n = 0;
        int n2 = 0;
        while ((n = byteList2.indexOf(46, n2)) != -1) {
            byteList2.replace(n, 1, QUOTED_DOT);
            n2 = n + 3;
        }
        byteList2.append((byte)96);
        return threadContext.getRuntime().newString(byteList2);
    }

    @JRubyMethod(module=true, frame=false)
    public static IRubyObject kill_cancel_timer(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Connection connection = (Connection)iRubyObject2.dataGetStruct();
        if (connection != null && connection.getClass().getClassLoader() == iRubyObject.getRuntime().getJRubyClassLoader()) {
            try {
                Field field = connection.getClass().getDeclaredField("cancelTimer");
                field.setAccessible(true);
                Timer timer = (Timer)field.get(null);
                timer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return iRubyObject.getRuntime().getNil();
    }
}

