/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.jaxws;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.spi.jaxws.client.ProjectJAXWSClientSupport;
import org.openide.filesystems.FileObject;

public class EjbProjectJAXWSClientSupport
extends ProjectJAXWSClientSupport {
    private EjbJarProject project;

    public EjbProjectJAXWSClientSupport(EjbJarProject ejbJarProject) {
        super((Project)ejbJarProject);
        this.project = ejbJarProject;
    }

    public FileObject getWsdlFolder(boolean bl) throws IOException {
        FileObject fileObject;
        EjbJar ejbJar = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        if (ejbJar != null && (fileObject = ejbJar.getMetaInf()) != null) {
            FileObject fileObject2 = fileObject.getFileObject("wsdl");
            if (fileObject2 != null) {
                return fileObject2;
            }
            if (bl) {
                return fileObject.createFolder("wsdl");
            }
        }
        return null;
    }

    protected void addJaxWs20Library() throws Exception {
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (sourceGroupArray.length > 0) {
            try {
                FileObject fileObject = sourceGroupArray[0].getRootFolder();
                String string = System.getProperty("java.version");
                if (string.compareTo("1.6") >= 0) {
                    WSUtils.addJaxWsApiEndorsed((Project)this.project, (FileObject)fileObject);
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(EjbProjectJAXWSClientSupport.class.getName()).log(Level.FINE, "Cannot add JAX-WS-ENDORSED classpath", iOException);
            }
        }
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getAPIEjbJar().getMetaInf();
    }

    protected String getProjectJavaEEVersion() {
        EjbJar ejbJar = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        if (ejbJar != null) {
            if (Profile.JAVA_EE_6_WEB.equals(ejbJar.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_6_FULL.equals(ejbJar.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_5.equals(ejbJar.getJ2eeProfile())) {
                return "java-ee-version-15";
            }
        }
        return "java-ee-version-none";
    }
}

