/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.subversion;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class SubversionHyperlink
implements OutputListener {
    private static final Logger LOG = Logger.getLogger(SubversionHyperlink.class.getName());
    private final String module;
    private final String path;
    private final int startRev;
    private final int endRev;
    private final HudsonJob job;
    private static Set<String> knownRepos = new HashSet<String>();

    SubversionHyperlink(String string, String string2, int n, int n2, HudsonJob hudsonJob) {
        this.module = string;
        this.path = string2;
        this.startRev = n;
        this.endRev = n2;
        this.job = hudsonJob;
    }

    public void outputLineAction(OutputEvent outputEvent) {
        HudsonSCM.Helper.noteWillShowDiff((String)this.path);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                String string = SubversionHyperlink.this.findRepo(SubversionHyperlink.this.module);
                if (string == null) {
                    return;
                }
                try {
                    StreamSource streamSource = SubversionHyperlink.this.makeSource(string, SubversionHyperlink.this.path, SubversionHyperlink.this.startRev);
                    StreamSource streamSource2 = SubversionHyperlink.this.makeSource(string, SubversionHyperlink.this.path, SubversionHyperlink.this.endRev);
                    HudsonSCM.Helper.showDiff((StreamSource)streamSource, (StreamSource)streamSource2, (String)SubversionHyperlink.this.path);
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, null, iOException);
                }
            }
        });
    }

    public void outputLineSelected(OutputEvent outputEvent) {
    }

    public void outputLineCleared(OutputEvent outputEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String findRepo(String string) {
        for (String object : knownRepos) {
            if (!string.startsWith(object)) continue;
            return object;
        }
        LOG.log(Level.FINER, "looking for repo from {0}", string);
        try {
            block6: while (true) {
                InputStream inputStream = new ConnectionBuilder().job(this.job).url(string).connection().getInputStream();
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!string2.equals("  <li><a href=\"../\">..</a></li>")) continue;
                        string = string.replaceFirst("/[^/]+$", "");
                        continue block6;
                    }
                }
                finally {
                    inputStream.close();
                    continue;
                }
                break;
            }
            LOG.log(Level.FINER, "  => {0}", string);
            knownRepos.add(string);
            return string;
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "trying to find repo for " + string, iOException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSource makeSource(String string, String string2, int n) throws IOException {
        Object object;
        Object object2;
        StringReader stringReader;
        if (n == 0) {
            stringReader = new StringReader("");
        } else {
            object2 = new URL(string + "/!svn/ver/" + n + string2).openStream();
            try {
                object = new ByteArrayOutputStream();
                FileUtil.copy((InputStream)object2, (OutputStream)object);
                stringReader = new StringReader(((ByteArrayOutputStream)object).toString());
            }
            finally {
                ((InputStream)object2).close();
            }
        }
        object2 = "text/plain";
        object = string2;
        String string3 = NbBundle.getMessage(SubversionHyperlink.class, (String)"SubversionHyperlink.title", (Object)string2.replaceFirst(".+/", ""), (Object)n);
        return StreamSource.createSource((String)object, (String)string3, (String)object2, (Reader)stringReader);
    }
}

