/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.MonitorInfo;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.NativeMethodExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ArgumentObjectVariable;
import org.netbeans.modules.debugger.jpda.models.ArgumentVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.netbeans.spi.debugger.jpda.EditorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallStackFrameImpl
implements CallStackFrame {
    private final JPDAThreadImpl thread;
    private StackFrame sf;
    private Location sfLocation;
    private int depth;
    private JPDADebuggerImpl debugger;
    private EditorContext.Operation currentOperation;
    private EqualsInfo equalsInfo;
    private boolean valid;

    public CallStackFrameImpl(JPDAThreadImpl jPDAThreadImpl, StackFrame stackFrame, int n, JPDADebuggerImpl jPDADebuggerImpl) {
        this.thread = jPDAThreadImpl;
        this.sf = stackFrame;
        this.depth = n;
        this.debugger = jPDADebuggerImpl;
        this.equalsInfo = new EqualsInfo(jPDADebuggerImpl, stackFrame, n);
        this.valid = true;
        try {
            this.sfLocation = StackFrameWrapper.location(stackFrame);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    public synchronized int getLineNumber(String string) {
        if (!this.valid && this.sfLocation == null) {
            return 0;
        }
        try {
            Location location = this.getStackFrameLocation();
            return LocationWrapper.lineNumber0(location, string);
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return 0;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return 0;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return 0;
        }
    }

    public synchronized EditorContext.Operation getCurrentOperation(String string) {
        return this.currentOperation;
    }

    public synchronized void setCurrentOperation(EditorContext.Operation operation) {
        this.currentOperation = operation;
    }

    public synchronized String getMethodName() {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        try {
            Location location = this.getStackFrameLocation();
            return TypeComponentWrapper.name(LocationWrapper.method(location));
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
    }

    public synchronized String getClassName() {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        try {
            Location location = this.getStackFrameLocation();
            return ReferenceTypeWrapper.name(LocationWrapper.declaringType(location));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return "";
        }
    }

    public synchronized JPDAClassType getClassType() {
        if (!this.valid && this.sfLocation == null) {
            return null;
        }
        try {
            Location location = this.getStackFrameLocation();
            return new JPDAClassTypeImpl(this.debugger, LocationWrapper.declaringType(location));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return null;
        }
    }

    public synchronized String getDefaultStratum() {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        try {
            Location location = this.getStackFrameLocation();
            return ReferenceTypeWrapper.defaultStratum(LocationWrapper.declaringType(location));
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return "";
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
    }

    public synchronized List<String> getAvailableStrata() {
        if (!this.valid && this.sfLocation == null) {
            return Collections.emptyList();
        }
        try {
            Location location = this.getStackFrameLocation();
            return ReferenceTypeWrapper.availableStrata(LocationWrapper.declaringType(location));
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return Collections.emptyList();
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return Collections.emptyList();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return Collections.emptyList();
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return Collections.emptyList();
        }
    }

    public String getSourceDebugExtension() {
        if (!this.valid && this.sfLocation == null) {
            return null;
        }
        try {
            Location location = this.getStackFrameLocation();
            if (VirtualMachineWrapper.canGetSourceDebugExtension(location.virtualMachine())) {
                return ReferenceTypeWrapper.sourceDebugExtension(LocationWrapper.declaringType(location));
            }
            return null;
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    public synchronized String getSourceName(String string) throws AbsentInformationException {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        try {
            Location location = this.getStackFrameLocation();
            return LocationWrapper.sourceName(location, string);
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return "";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public synchronized String getSourcePath(String string) throws AbsentInformationException {
        if (!this.valid && this.sfLocation == null) {
            return "";
        }
        try {
            Location location = this.getStackFrameLocation();
            return LocationWrapper.sourcePath(location, string);
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return "";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public LocalVariable[] getLocalVariables() throws AbsentInformationException {
        try {
            Location location = this.getStackFrameLocation();
            String string = ReferenceTypeWrapper.name(LocationWrapper.declaringType(location));
            List<com.sun.jdi.LocalVariable> list = StackFrameWrapper.visibleVariables(this.getStackFrame());
            int n = list.size();
            LocalVariable[] localVariableArray = new LocalVariable[n];
            for (int i = 0; i < n; ++i) {
                AbstractVariable abstractVariable;
                Value value;
                com.sun.jdi.LocalVariable localVariable = list.get(i);
                LocalVariable localVariable2 = (LocalVariable)this.debugger.getLocalVariable(localVariable, value = StackFrameWrapper.getValue(this.getStackFrame(), localVariable));
                if (localVariable2 instanceof Local) {
                    abstractVariable = (Local)localVariable2;
                    ((Local)abstractVariable).setFrame(this);
                    ((Local)abstractVariable).setClassName(string);
                } else {
                    abstractVariable = (ObjectLocalVariable)localVariable2;
                    ((ObjectLocalVariable)abstractVariable).setFrame(this);
                    ((ObjectLocalVariable)abstractVariable).setClassName(string);
                }
                localVariableArray[i] = localVariable2;
            }
            return localVariableArray;
        }
        catch (NativeMethodExceptionWrapper nativeMethodExceptionWrapper) {
            throw new AbsentInformationException("native method");
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            throw new AbsentInformationException("thread is running");
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw new AbsentInformationException("frame class is collected");
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return new LocalVariable[0];
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw new AbsentInformationException(internalExceptionWrapper.getLocalizedMessage());
        }
    }

    LocalVariable getLocalVariable(String string) throws AbsentInformationException {
        try {
            com.sun.jdi.LocalVariable localVariable;
            Location location = this.getStackFrameLocation();
            String string2 = ReferenceTypeWrapper.name(LocationWrapper.declaringType(location));
            try {
                localVariable = StackFrameWrapper.visibleVariableByName(this.getStackFrame(), string);
            }
            catch (NativeMethodExceptionWrapper nativeMethodExceptionWrapper) {
                localVariable = null;
            }
            if (localVariable == null) {
                return null;
            }
            Value value = StackFrameWrapper.getValue(this.getStackFrame(), localVariable);
            LocalVariable localVariable2 = (LocalVariable)this.debugger.getLocalVariable(localVariable, value);
            if (localVariable2 instanceof Local) {
                Local local = (Local)localVariable2;
                local.setFrame(this);
                local.setInnerValue(value);
                local.setClassName(string2);
            } else {
                ObjectLocalVariable objectLocalVariable = (ObjectLocalVariable)localVariable2;
                objectLocalVariable.setFrame(this);
                objectLocalVariable.setInnerValue(value);
                objectLocalVariable.setClassName(string2);
            }
            return localVariable2;
        }
        catch (NativeMethodException nativeMethodException) {
            throw new AbsentInformationException("native method");
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            throw new AbsentInformationException("thread is running");
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw new AbsentInformationException("frame class is collected");
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw new AbsentInformationException(internalExceptionWrapper.getLocalizedMessage());
        }
    }

    public LocalVariable[] getMethodArguments() {
        try {
            StackFrame stackFrame = this.getStackFrame();
            String string = this.debugger.getEngineContext().getURL(stackFrame, this.getDefaultStratum());
            List<Value> list = CallStackFrameImpl.getArgumentValues(stackFrame);
            if (list == null) {
                return null;
            }
            Location location = this.getStackFrameLocation();
            EditorContext.MethodArgument[] methodArgumentArray = EditorContextBridge.getContext().getArguments(string, LocationWrapper.lineNumber(location));
            if (methodArgumentArray == null) {
                return null;
            }
            int n = Math.min(list.size(), methodArgumentArray.length);
            LocalVariable[] localVariableArray = new LocalVariable[n];
            for (int i = 0; i < n; ++i) {
                Value value = list.get(i);
                localVariableArray[i] = value instanceof ObjectReference ? new ArgumentObjectVariable(this.debugger, (ObjectReference)value, methodArgumentArray[i].getName(), methodArgumentArray[i].getType()) : new ArgumentVariable(this.debugger, (PrimitiveValue)value, methodArgumentArray[i].getName(), methodArgumentArray[i].getType());
            }
            return localVariableArray;
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return new LocalVariable[0];
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return new LocalVariable[0];
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return new LocalVariable[0];
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return new LocalVariable[0];
        }
    }

    static boolean canFindOperationArguments() {
        return JPDAUtils.IS_JDK_160_02;
    }

    /*
     * Exception decompiling
     */
    List<LocalVariable> findOperationArguments(EditorContext.Operation var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [32[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<Value> getArgumentValues(StackFrame stackFrame) {
        if (!JPDAUtils.IS_JDK_16) {
            return null;
        }
        try {
            Method method = LocationWrapper.method(StackFrameWrapper.location(stackFrame));
            if (MethodWrapper.isNative(method)) {
                throw new NativeMethodException(TypeComponentWrapper.name(method));
            }
            return StackFrameWrapper.getArgumentValues0(stackFrame);
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return Collections.emptyList();
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return Collections.emptyList();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return Collections.emptyList();
        }
    }

    public synchronized This getThisVariable() {
        ObjectReference objectReference;
        if (!this.valid) {
            return null;
        }
        try {
            objectReference = StackFrameWrapper.thisObject(this.getStackFrame());
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            this.valid = false;
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        if (objectReference == null) {
            return null;
        }
        return new ThisVariable(this.debugger, objectReference, "");
    }

    public void makeCurrent() {
        this.debugger.setCurrentCallStackFrame(this);
    }

    public boolean isCurrent() {
        return this.equals(this.debugger.getCurrentCallStackFrame());
    }

    public synchronized boolean isObsolete() {
        try {
            Location location = this.getStackFrameLocation();
            return MethodWrapper.isObsolete0(LocationWrapper.method(location));
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            throw invalidStackFrameExceptionWrapper.getCause();
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
    }

    public boolean canPop() {
        if (!this.debugger.canPopFrames()) {
            return false;
        }
        try {
            ThreadReference threadReference = StackFrameWrapper.thread(this.getStackFrame());
            if (ThreadReferenceWrapper.frameCount(threadReference) <= 1) {
                return false;
            }
            List<StackFrame> list = ThreadReferenceWrapper.frames(threadReference, 0, 2);
            if (MethodWrapper.isNative(LocationWrapper.method(StackFrameWrapper.location(list.get(0)))) || MethodWrapper.isNative(LocationWrapper.method(StackFrameWrapper.location(list.get(1))))) {
                return false;
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return false;
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return false;
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return false;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        return true;
    }

    public void popFrame() {
        try {
            StackFrame stackFrame = this.getStackFrame();
            this.debugger.popFrames(StackFrameWrapper.thread(stackFrame), stackFrame);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            throw invalidStackFrameExceptionWrapper.getCause();
        }
    }

    public JPDAThread getThread() {
        return this.thread;
    }

    private synchronized Location getStackFrameLocation() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        if (this.sfLocation == null) {
            this.sfLocation = StackFrameWrapper.location(this.getStackFrame());
        }
        return this.sfLocation;
    }

    public StackFrame getStackFrame() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        block7: {
            try {
                StackFrameWrapper.thread(this.sf);
            }
            catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                try {
                    ThreadReference threadReference = this.thread.getThreadReference();
                    if (this.depth >= ThreadReferenceWrapper.frameCount(threadReference)) {
                        throw invalidStackFrameExceptionWrapper;
                    }
                    this.sf = ThreadReferenceWrapper.frame(threadReference, this.depth);
                    this.sfLocation = StackFrameWrapper.location(this.getStackFrame());
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    throw invalidStackFrameExceptionWrapper;
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    throw invalidStackFrameExceptionWrapper;
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    throw invalidStackFrameExceptionWrapper;
                }
                if (this.equalsInfo.equals(new EqualsInfo(this.debugger, this.sf, this.depth))) break block7;
                throw invalidStackFrameExceptionWrapper;
            }
        }
        return this.sf;
    }

    public int getFrameDepth() {
        return this.depth;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CallStackFrameImpl)) {
            return false;
        }
        CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)object;
        return this.equalsInfo.equals(callStackFrameImpl.equalsInfo);
    }

    public synchronized int hashCode() {
        return this.equalsInfo.hashCode();
    }

    public List<MonitorInfo> getOwnedMonitors() {
        List<MonitorInfo> list;
        try {
            list = this.getThread().getOwnedMonitorsAndFrames();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            list = Collections.emptyList();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            list = Collections.emptyList();
        }
        if (list.size() == 0) {
            return list;
        }
        ArrayList<MonitorInfo> arrayList = new ArrayList<MonitorInfo>();
        for (MonitorInfo monitorInfo : list) {
            if (!this.equals(monitorInfo.getFrame())) continue;
            arrayList.add(monitorInfo);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static final class EqualsInfo {
        private JPDAThread thread;
        private int depth;
        private ReferenceType locationType;
        private String locationMethodName;
        private String locationMethodSignature;
        private long locationCodeIndex;

        public EqualsInfo(JPDADebuggerImpl jPDADebuggerImpl, StackFrame stackFrame, int n) {
            try {
                this.thread = jPDADebuggerImpl.getThread(StackFrameWrapper.thread(stackFrame));
                this.depth = n;
                Location location = StackFrameWrapper.location(stackFrame);
                this.locationType = LocationWrapper.declaringType(location);
                this.locationMethodName = TypeComponentWrapper.name(LocationWrapper.method(location));
                this.locationMethodSignature = TypeComponentWrapper.signature(LocationWrapper.method(location));
                this.locationCodeIndex = LocationWrapper.codeIndex(location);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                this.thread = null;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                this.thread = null;
            }
            catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                this.thread = null;
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof EqualsInfo)) {
                return false;
            }
            EqualsInfo equalsInfo = (EqualsInfo)object;
            return this.thread == equalsInfo.thread && this.depth == equalsInfo.depth && (this.locationType == null && equalsInfo.locationType == null || this.locationType != null && ((Object)this.locationType).equals(equalsInfo.locationType)) && (this.locationMethodName == null && equalsInfo.locationMethodName == null || this.locationMethodName != null && this.locationMethodName.equals(equalsInfo.locationMethodName)) && (this.locationMethodSignature == null && equalsInfo.locationMethodSignature == null || this.locationMethodSignature != null && this.locationMethodSignature.equals(equalsInfo.locationMethodSignature)) && this.locationCodeIndex == equalsInfo.locationCodeIndex;
        }

        public int hashCode() {
            if (this.thread == null) {
                return 0;
            }
            return this.thread.hashCode() << 8 + this.depth + ((Object)this.locationType).hashCode() << (int)(4L + this.locationCodeIndex);
        }
    }
}

