/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineBreakpointImpl
extends ClassBasedBreakpoint {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private int lineNumber;
    private BreakpointsReader reader;

    public LineBreakpointImpl(LineBreakpoint lineBreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session, SourcePath sourcePath) {
        super((JPDABreakpoint)lineBreakpoint, breakpointsReader, jPDADebuggerImpl, session);
        this.reader = breakpointsReader;
        this.updateLineNumber();
        this.setSourceRoot(sourcePath.getSourceRoot(lineBreakpoint.getURL()));
        this.set();
    }

    private void updateLineNumber() {
        this.lineNumber = EditorContextBridge.getContext().getLineNumber((Object)this.getBreakpoint(), (Object)this.getDebugger());
    }

    protected LineBreakpoint getBreakpoint() {
        return (LineBreakpoint)super.getBreakpoint();
    }

    @Override
    void fixed() {
        logger.fine("LineBreakpoint fixed: " + this);
        this.updateLineNumber();
        super.fixed();
    }

    @Override
    protected void setRequests() {
        LineBreakpoint lineBreakpoint = this.getBreakpoint();
        this.updateLineNumber();
        String[] stringArray = new String[]{null};
        String string = this.getDebugger().getEngineContext().getRelativePath(lineBreakpoint.getURL(), '/', true);
        if (string == null) {
            String string2 = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoSourceRoot", (Object)lineBreakpoint.getURL());
            this.setInvalid(string2);
            return;
        }
        String string3 = lineBreakpoint.getPreferredClassName();
        if (string3 == null && (string3 = this.reader.findCachedClassName((JPDABreakpoint)lineBreakpoint)) == null && (string3 = EditorContextBridge.getContext().getClassName(lineBreakpoint.getURL(), this.lineNumber)) != null && string3.length() > 0) {
            this.reader.storeCachedClassName((JPDABreakpoint)lineBreakpoint, string3);
        }
        if (string3 == null || string3.length() == 0) {
            logger.warning("Class name not defined for breakpoint " + lineBreakpoint);
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoBPClass"));
            return;
        }
        boolean bl = false;
        String string4 = this.getSourceRoot();
        if (string4 != null) {
            String[] stringArray2 = this.getDebugger().getEngineContext().getSourceRoots();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!string4.equals(stringArray2[i])) continue;
                bl = true;
            }
        }
        if (!bl && LineBreakpointImpl.classExistsInSources(string3, this.getDebugger().getEngineContext().getProjectSourceRoots())) {
            logger.fine("LineBreakpoint " + lineBreakpoint + " NOT submitted, URL " + lineBreakpoint.getURL() + " not in sources, but class " + string3 + " exist in sources.");
            return;
        }
        if (bl && !this.isEnabled(string, stringArray)) {
            string4 = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_DifferentPrefferedSourceRoot", (Object)stringArray[0]);
            this.setInvalid(string4);
            logger.fine("LineBreakpoint " + lineBreakpoint + " NOT submitted, because of '" + string4 + "'.");
            return;
        }
        logger.fine("LineBreakpoint " + lineBreakpoint + " - setting request for " + string3);
        this.setClassRequests(new String[]{string3}, new String[0], 1);
        this.checkLoadedClasses(string3, null);
    }

    private void setInvalid(String string) {
        ErrorManager.getDefault().log(16, "Unable to submit line breakpoint to " + this.getBreakpoint().getURL() + " at line " + this.lineNumber + ", reason: " + string);
        this.setValidity(Breakpoint.VALIDITY.INVALID, string);
    }

    private static boolean classExistsInSources(final String string, String[] classPath) {
        Object object2;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(((String[])classPath).length);
        for (Object object2 : classPath) {
            FileObject fileObject = LineBreakpointImpl.getFileObject((String)object2);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
        ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[0]), (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[0]), (ClassPath)classPath2);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        object2 = new boolean[]{false};
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>((boolean[])object2){
                final /* synthetic */ boolean[] val$found;
                {
                    this.val$found = blArray;
                }

                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (typeElement != null) {
                        this.val$found[0] = true;
                    }
                }
            }, false);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return (boolean)object2[0];
    }

    private static FileObject getFileObject(String string) {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        String string2 = null;
        if (fileObject == null && string.contains("!/")) {
            int n = string.indexOf("!/");
            file = new File(string.substring(0, n));
            fileObject = FileUtil.toFileObject((File)file);
            string2 = string.substring(n + "!/".length());
        }
        if (fileObject != null && FileUtil.isArchiveFile((FileObject)fileObject)) {
            fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
            if (string2 != null) {
                fileObject = fileObject.getFileObject(string2);
            }
        }
        return fileObject;
    }

    @Override
    protected void classLoaded(List<ReferenceType> list) {
        LineBreakpoint lineBreakpoint = this.getBreakpoint();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Classes " + list + " loaded for breakpoint " + lineBreakpoint);
        }
        boolean bl = false;
        String string = null;
        for (ReferenceType referenceType : list) {
            String[] stringArray = new String[]{null};
            List list2 = LineBreakpointImpl.getLocations(referenceType, lineBreakpoint.getStratum(), lineBreakpoint.getSourceName(), lineBreakpoint.getSourcePath(), this.lineNumber, stringArray);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Locations in " + referenceType + " are: " + list2 + ", reason = '" + stringArray[0]);
            }
            if (list2.isEmpty()) {
                string = stringArray[0];
                continue;
            }
            for (Location location : list2) {
                try {
                    BreakpointRequest breakpointRequest = EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), location);
                    this.setFilters(breakpointRequest);
                    this.addEventRequest(breakpointRequest);
                    bl = true;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {}
            }
        }
        if (bl) {
            this.setValidity(Breakpoint.VALIDITY.VALID, string);
        } else {
            ErrorManager.getDefault().log(16, "Unable to submit line breakpoint to " + list.get(0).name() + " at line " + this.lineNumber + ", reason: " + string);
            this.setValidity(Breakpoint.VALIDITY.INVALID, string);
        }
    }

    @Override
    protected EventRequest createEventRequest(EventRequest eventRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        Location location = BreakpointRequestWrapper.location((BreakpointRequest)eventRequest);
        BreakpointRequest breakpointRequest = EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), location);
        this.setFilters(breakpointRequest);
        return breakpointRequest;
    }

    private void setFilters(BreakpointRequest breakpointRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        JPDAThread[] jPDAThreadArray;
        JPDAThread[] jPDAThreadArray2 = this.getBreakpoint().getThreadFilters((JPDADebugger)this.getDebugger());
        if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
            jPDAThreadArray = jPDAThreadArray2;
            int n = jPDAThreadArray.length;
            for (int i = 0; i < n; ++i) {
                JPDAThread jPDAThread = jPDAThreadArray[i];
                BreakpointRequestWrapper.addThreadFilter(breakpointRequest, ((JPDAThreadImpl)jPDAThread).getThreadReference());
            }
        }
        if ((jPDAThreadArray = this.getBreakpoint().getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
            for (JPDAThread jPDAThread : jPDAThreadArray) {
                BreakpointRequestWrapper.addInstanceFilter(breakpointRequest, (ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
            }
        }
    }

    @Override
    public boolean processCondition(Event event) {
        if (event instanceof BreakpointEvent) {
            try {
                return this.processCondition(event, this.getBreakpoint().getCondition(), LocatableEventWrapper.thread((BreakpointEvent)event), null);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean exec(Event event) {
        if (event instanceof BreakpointEvent) {
            try {
                return this.perform(event, LocatableEventWrapper.thread((BreakpointEvent)event), LocationWrapper.declaringType(LocatableWrapper.location((LocatableEvent)event)), null);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return false;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return false;
            }
        }
        return super.exec(event);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("lineNumber".equals(propertyChangeEvent.getPropertyName())) {
            int n = this.lineNumber;
            this.updateLineNumber();
            if (this.lineNumber == n) {
                return;
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    private static List getLocations(ReferenceType referenceType, String string, String string2, String string3, int n, String[] stringArray) {
        try {
            stringArray[0] = null;
            List<Location> list = LineBreakpointImpl.locationsOfLineInClass(referenceType, string, string2, string3, n, stringArray);
            if (list.isEmpty() && stringArray[0] == null) {
                stringArray[0] = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoLocation", (Object)Integer.toString(n), (Object)referenceType.name());
            }
            return list;
        }
        catch (AbsentInformationException absentInformationException) {
            stringArray[0] = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoLineInfo", (Object)referenceType.name());
        }
        catch (ObjectCollectedException objectCollectedException) {
            stringArray[0] = objectCollectedException.getLocalizedMessage();
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            ErrorManager.getDefault().notify(65536, (Throwable)classNotPreparedException);
        }
        catch (InternalException internalException) {
            ErrorManager.getDefault().annotate((Throwable)internalException, NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_jdi_internal_error"));
            ErrorManager.getDefault().notify((Throwable)internalException);
            stringArray[0] = internalException.getLocalizedMessage();
        }
        return Collections.EMPTY_LIST;
    }

    private static List<Location> locationsOfLineInClass(ReferenceType referenceType, String string, String string2, String string3, int n, String[] stringArray) throws AbsentInformationException, ObjectCollectedException, ClassNotPreparedException, InternalException {
        List<Location> list;
        try {
            list = ReferenceTypeWrapper.locationsOfLine0(referenceType, string, string2, n);
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            throw classNotPreparedExceptionWrapper.getCause();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("LineBreakpoint: locations for ReferenceType=" + referenceType + ", stratum=" + string + ", source name=" + string2 + ", bpSourcePath=" + string3 + ", lineNumber=" + n + " are: {" + list + "}");
        }
        if (!list.isEmpty()) {
            if (string3 == null) {
                return list;
            }
            string3 = string3.replace(File.separatorChar, '/');
            ArrayList<Location> arrayList = new ArrayList<Location>(list.size());
            for (Location location : list) {
                String string4;
                try {
                    string4 = LocationWrapper.sourcePath(location).replace(File.separatorChar, '/');
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    return Collections.emptyList();
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return Collections.emptyList();
                }
                string4 = LineBreakpointImpl.normalize(string4);
                if (string4.equals(string3)) {
                    arrayList.add(location);
                    continue;
                }
                stringArray[0] = "Breakpoint source path '" + string3 + "' is different from the location source path '" + string4 + "'.";
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("LineBreakpoint: relevant location(s) for path '" + string3 + "': " + arrayList);
            }
            if (!arrayList.isEmpty()) {
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    private static String normalize(String string) {
        Pattern pattern = Pattern.compile("(/|\\A)\\./");
        Pattern pattern2 = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceAll("$1");
            matcher = pattern.matcher(string);
        }
        matcher = pattern2.matcher(string);
        while (matcher.find()) {
            if (matcher.group(2).equals("..")) continue;
            string = string.substring(0, matcher.start()) + matcher.group(1) + string.substring(matcher.end());
            matcher = pattern2.matcher(string);
        }
        return string;
    }
}

