/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;

public class StartActionProvider
extends ActionsProvider
implements Cancellable {
    private static final Logger logger = Logger.getLogger(StartActionProvider.class.getName());
    private static int jdiTrace;
    private JPDADebuggerImpl debuggerImpl;
    private ContextProvider lookupProvider;
    private Thread startingThread;

    public StartActionProvider(ContextProvider contextProvider) {
        this.debuggerImpl = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.lookupProvider = contextProvider;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_START);
    }

    public void doAction(Object object) {
        logger.fine("S StartActionProvider.doAction ()");
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)((Object)this.lookupProvider.lookupFirst(null, JPDADebugger.class));
        if (jPDADebuggerImpl != null && jPDADebuggerImpl.getVirtualMachine() != null) {
            return;
        }
        logger.fine("S StartActionProvider.doAction () setStarting");
        this.debuggerImpl.setStarting();
        AbstractDICookie abstractDICookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
        this.doStartDebugger(abstractDICookie);
        logger.fine("S StartActionProvider.doAction () end");
    }

    public void postAction(Object object, final Runnable runnable) {
        logger.fine("S StartActionProvider.postAction ()");
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)((Object)this.lookupProvider.lookupFirst(null, JPDADebugger.class));
        if (jPDADebuggerImpl != null && jPDADebuggerImpl.getVirtualMachine() != null) {
            runnable.run();
            return;
        }
        final AbstractDICookie abstractDICookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
        logger.fine("S StartActionProvider.postAction () setStarting");
        this.debuggerImpl.setStarting();
        logger.fine("S StartActionProvider.postAction () setStarting end");
        this.debuggerImpl.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StartActionProvider startActionProvider = StartActionProvider.this;
                synchronized (startActionProvider) {
                    StartActionProvider.this.startingThread = Thread.currentThread();
                }
                try {
                    StartActionProvider.this.doStartDebugger(abstractDICookie);
                }
                finally {
                    startActionProvider = StartActionProvider.this;
                    synchronized (startActionProvider) {
                        StartActionProvider.this.startingThread = null;
                    }
                    runnable.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartDebugger(AbstractDICookie abstractDICookie) {
        VirtualMachine virtualMachine;
        logger.fine("S StartActionProvider.doStartDebugger");
        Exception exception = null;
        try {
            this.debuggerImpl.setAttaching(abstractDICookie);
            virtualMachine = abstractDICookie.getVirtualMachine();
            this.debuggerImpl.setAttaching(null);
            VirtualMachineWrapper.setDebugTraceMode(virtualMachine, jdiTrace);
            Object object = new Object();
            Operator operator = this.createOperator(virtualMachine, object);
            Object object2 = object;
            synchronized (object2) {
                logger.fine("S StartActionProvider.doAction () - starting operator thread");
                operator.start();
                if (abstractDICookie instanceof ListeningDICookie) {
                    object.wait(1500L);
                }
            }
            this.debuggerImpl.setRunning(virtualMachine, operator);
            logger.fine("S StartActionProvider.doStartDebugger end: success");
        }
        catch (InterruptedException interruptedException) {
            exception = interruptedException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (Exception exception2) {
            exception = exception2;
            ErrorManager.getDefault().notify((Throwable)exception2);
        }
        if (exception != null) {
            logger.fine("S StartActionProvider.doAction ().thread end: exception " + exception);
            this.debuggerImpl.setException(exception);
            virtualMachine = (Session)this.lookupProvider.lookupFirst(null, Session.class);
            this.debuggerImpl.getRequestProcessor().post(new Runnable((Session)virtualMachine){
                final /* synthetic */ Session val$session;
                {
                    this.val$session = session;
                }

                public void run() {
                    this.val$session.kill();
                }
            });
        }
    }

    public boolean isEnabled(Object object) {
        return true;
    }

    public void addActionsProviderListener(ActionsProviderListener actionsProviderListener) {
    }

    public void removeActionsProviderListener(ActionsProviderListener actionsProviderListener) {
    }

    private Operator createOperator(VirtualMachine virtualMachine, final Object object) {
        return new Operator(virtualMachine, this.debuggerImpl, new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean exec(Event event) {
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
                return false;
            }

            public void removed(EventRequest eventRequest) {
            }
        }, new Runnable(){

            public void run() {
                StartActionProvider.this.debuggerImpl.finish();
            }
        }, this.debuggerImpl.accessLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        StartActionProvider startActionProvider = this;
        synchronized (startActionProvider) {
            if (this.startingThread == null) {
                return true;
            }
            this.startingThread.interrupt();
        }
        return true;
    }

    static {
        if (System.getProperty("netbeans.debugger.jditrace") != null) {
            try {
                jdiTrace = Integer.parseInt(System.getProperty("netbeans.debugger.jditrace"));
            }
            catch (NumberFormatException numberFormatException) {
                jdiTrace = 0;
            }
        } else {
            jdiTrace = 0;
        }
    }
}

