/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.util.WeakSet;

abstract class JPDADebuggerActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    protected JPDADebuggerImpl debugger;
    private static Set<JPDADebuggerActionProvider> providersToDisableOnLazyActions = new WeakSet();
    private volatile boolean disabled;

    JPDADebuggerActionProvider(JPDADebuggerImpl jPDADebuggerImpl) {
        this.debugger = jPDADebuggerImpl;
        jPDADebuggerImpl.addPropertyChangeListener("state", this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.checkEnabled(this.debugger.getState());
    }

    protected abstract void checkEnabled(int var1);

    public boolean isEnabled(Object object) {
        if (!this.disabled) {
            this.checkEnabled(this.debugger.getState());
        }
        return super.isEnabled(object);
    }

    JPDADebuggerImpl getDebuggerImpl() {
        return this.debugger;
    }

    protected void removeStepRequests(ThreadReference threadReference) {
        JPDADebuggerActionProvider.removeStepRequests(this.getDebuggerImpl(), threadReference);
    }

    static void removeStepRequests(JPDADebuggerImpl jPDADebuggerImpl, ThreadReference threadReference) {
        try {
            VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
            if (virtualMachine == null) {
                return;
            }
            EventRequestManager eventRequestManager = VirtualMachineWrapper.eventRequestManager(virtualMachine);
            List<StepRequest> list = EventRequestManagerWrapper.stepRequests(eventRequestManager);
            for (StepRequest stepRequest : list) {
                if (!StepRequestWrapper.thread(stepRequest).equals(threadReference)) continue;
                EventRequestManagerWrapper.deleteEventRequest(eventRequestManager, stepRequest);
                jPDADebuggerImpl.getOperator().unregister(stepRequest);
                break;
            }
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            illegalThreadStateException.printStackTrace();
        }
        catch (InvalidRequestStateException invalidRequestStateException) {
            invalidRequestStateException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProviderToDisableOnLazyAction(JPDADebuggerActionProvider jPDADebuggerActionProvider) {
        Class<JPDADebuggerActionProvider> clazz = JPDADebuggerActionProvider.class;
        synchronized (JPDADebuggerActionProvider.class) {
            providersToDisableOnLazyActions.add(jPDADebuggerActionProvider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doLazyAction(final Runnable runnable) {
        Class<JPDADebuggerActionProvider> clazz = JPDADebuggerActionProvider.class;
        synchronized (JPDADebuggerActionProvider.class) {
            final HashSet<JPDADebuggerActionProvider> hashSet = new HashSet<JPDADebuggerActionProvider>(providersToDisableOnLazyActions);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (JPDADebuggerActionProvider jPDADebuggerActionProvider : hashSet) {
                Set set = jPDADebuggerActionProvider.getActions();
                jPDADebuggerActionProvider.disabled = true;
                for (Object e : set) {
                    jPDADebuggerActionProvider.setEnabled(e, false);
                }
            }
            this.debugger.getRequestProcessor().post(new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                        for (JPDADebuggerActionProvider jPDADebuggerActionProvider : hashSet) {
                            Set set = jPDADebuggerActionProvider.getActions();
                            jPDADebuggerActionProvider.disabled = false;
                            jPDADebuggerActionProvider.checkEnabled(JPDADebuggerActionProvider.this.debugger.getState());
                        }
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        // empty catch block
                    }
                }
            });
            return;
        }
    }
}

