/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositoryUtils;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KenaiUtil {
    public static boolean isLoggedIn() {
        return Kenai.getDefault().getPasswordAuthentication() != null;
    }

    public static boolean isKenai(String string) {
        return KenaiProject.getNameForRepository((String)string) != null;
    }

    public static boolean isKenai(Repository repository) {
        return repository.getLookup().lookup(KenaiProject.class) != null;
    }

    public static PasswordAuthentication getPasswordAuthentication(boolean bl) {
        PasswordAuthentication passwordAuthentication = Kenai.getDefault().getPasswordAuthentication();
        if (passwordAuthentication != null) {
            return passwordAuthentication;
        }
        if (!bl) {
            return null;
        }
        if (!KenaiUtil.showLogin()) {
            return null;
        }
        return Kenai.getDefault().getPasswordAuthentication();
    }

    public static boolean showLogin() {
        return UIUtils.showLogin();
    }

    public static Repository getKenaiBugtrackingRepository(KenaiProject kenaiProject) {
        return KenaiRepositoryUtils.getInstance().getRepository(kenaiProject);
    }

    public static Repository getKenaiBugtrackingRepository(String string) throws KenaiException {
        KenaiProject kenaiProject = Kenai.getDefault().getProject(string);
        return kenaiProject != null ? KenaiUtil.getKenaiBugtrackingRepository(kenaiProject) : null;
    }

    public static Repository getKenaiRepository(String string) {
        KenaiProject kenaiProject = KenaiUtil.getKenaiProject(string);
        return kenaiProject == null ? null : KenaiRepositoryUtils.getInstance().getRepository(kenaiProject);
    }

    public static String getProjectUrl(String string) {
        KenaiProject kenaiProject = KenaiUtil.getKenaiProject(string);
        return kenaiProject == null ? null : kenaiProject.getWebLocation().toString();
    }

    public static Collection<RepositoryUser> getProjectMembers(String string) {
        List<RepositoryUser> list = null;
        try {
            KenaiProject kenaiProject = Kenai.getDefault().getProject(string);
            KenaiProjectMember[] kenaiProjectMemberArray = kenaiProject.getMembers();
            list = new ArrayList<RepositoryUser>(kenaiProjectMemberArray.length);
            for (KenaiProjectMember kenaiProjectMember : kenaiProjectMemberArray) {
                KenaiUser kenaiUser = kenaiProjectMember.getKenaiUser();
                list.add(new RepositoryUser(kenaiUser.getUserName(), kenaiUser.getFirstName() + " " + kenaiUser.getLastName()));
            }
        }
        catch (KenaiException kenaiException) {
            kenaiException.printStackTrace();
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public static KenaiProject getKenaiProject(ProjectHandle projectHandle) {
        try {
            return Kenai.getDefault().getProject(projectHandle.getId());
        }
        catch (KenaiException kenaiException) {
            BugtrackingManager.LOG.log(Level.WARNING, "Could not get KenaiProject object for project Id \"{0}\".", projectHandle.getId());
            BugtrackingManager.LOG.log(Level.INFO, null, kenaiException);
            return null;
        }
    }

    public static String getChatLink(Issue issue) {
        return "ISSUE:" + issue.getID();
    }

    private static KenaiProject getKenaiProject(String string) {
        KenaiProject kenaiProject;
        try {
            kenaiProject = KenaiProject.forRepository((String)string);
        }
        catch (KenaiException kenaiException) {
            return null;
        }
        return kenaiProject;
    }
}

