/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileToRepoMappingStorage {
    private static Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.util.FileToRepoMappingStorage");
    private static final String REPOSITORY_FOR_FILE_PREFIX = "repository for ";
    private static final Boolean FIRM_ASSOCIATION = Boolean.TRUE;
    private static final Boolean LOOSE_ASSOCIATION = Boolean.FALSE;
    private static FileToRepoMappingStorage instance;

    FileToRepoMappingStorage() {
    }

    public static synchronized FileToRepoMappingStorage getInstance() {
        if (instance == null) {
            instance = new FileToRepoMappingStorage();
        }
        return instance;
    }

    public void setFirmAssociation(File file, Repository repository) {
        this.setAssociation(file, repository, true);
    }

    public boolean setLooseAssociation(File file, Repository repository) {
        Repository repository2 = this.getFirmlyAssociatedRepository(file);
        if (repository2 == null) {
            this.setAssociation(file, repository, false);
            return true;
        }
        return false;
    }

    public Repository getRepository(File file) {
        return this.getAssociatedRepository(file, null);
    }

    public Repository getFirmlyAssociatedRepository(File file) {
        return this.getAssociatedRepository(file, FIRM_ASSOCIATION);
    }

    public Repository getLooselyAssociatedRepository(File file) {
        return this.getAssociatedRepository(file, LOOSE_ASSOCIATION);
    }

    public Collection<String> getAllFirmlyAssociatedUrls() {
        HashSet<String> hashSet = new HashSet<String>(10);
        try {
            String[] stringArray;
            Preferences preferences = this.getPreferences();
            for (String string : stringArray = preferences.keys()) {
                String string2;
                if (!string.startsWith(REPOSITORY_FOR_FILE_PREFIX) || (string2 = preferences.get(string, null)) == null || string2.length() <= 0 || string2.charAt(0) != '!') continue;
                hashSet.add(string2.substring(1));
            }
        }
        catch (BackingStoreException backingStoreException) {
            LOG.log(Level.INFO, null, backingStoreException);
        }
        return hashSet;
    }

    private Repository getAssociatedRepository(File file, Boolean bl) {
        boolean bl2;
        String string = FileToRepoMappingStorage.getPath(file);
        if (string == null) {
            return null;
        }
        String string2 = this.getValueForKey(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        char c = string2.charAt(0);
        switch (c) {
            case '!': {
                bl2 = bl != LOOSE_ASSOCIATION;
                break;
            }
            case '?': {
                bl2 = bl != FIRM_ASSOCIATION;
                break;
            }
            default: {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("unexpected first char of value in mapping: " + string + '=' + string2 + " (expected: '?' or '!')");
                }
                bl2 = false;
            }
        }
        return bl2 ? this.getRepositoryByUrl(string2.substring(1)) : null;
    }

    private Repository getRepositoryByUrl(String string) {
        Repository[] repositoryArray;
        for (Repository repository : repositoryArray = BugtrackingManager.getInstance().getRepositories()) {
            String string2 = FileToRepoMappingStorage.cutTrailingSlashes(repository.getUrl());
            if (!string2.equals(string)) continue;
            return repository;
        }
        return null;
    }

    private void setAssociation(File file, Repository repository, boolean bl) {
        String string = FileToRepoMappingStorage.getPath(file);
        if (string == null) {
            return;
        }
        String string2 = FileToRepoMappingStorage.cutTrailingSlashes(repository.getUrl());
        String string3 = new StringBuilder(1 + string2.length()).append(bl ? (char)'!' : '?').append(string2).toString();
        this.storeKeyValuePair(string, string3);
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            LOG.throwing(FileToRepoMappingStorage.class.getCanonicalName(), "storeMappingToPrefs", iOException);
            return null;
        }
    }

    private void storeKeyValuePair(String string, String string2) {
        this.getPreferences().put(REPOSITORY_FOR_FILE_PREFIX + string, string2);
    }

    private String getValueForKey(String string) {
        return this.getPreferences().get(REPOSITORY_FOR_FILE_PREFIX + string, null);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(FileToRepoMappingStorage.class);
    }

    private static String cutTrailingSlashes(String string) {
        int n;
        for (n = string.length(); n > 1 && string.charAt(n - 1) == '/'; --n) {
        }
        return n == string.length() ? string : string.substring(0, n);
    }
}

