/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.selectors.RepositoryFormPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class RepositorySelectorBuilder
implements ItemListener,
ItemSelectable {
    private static final String EMPTY_PANEL = "empty panel";
    private static final String NEW_REPO_PANEL = "new repo panel";
    private Repository[] existingRepositories;
    private BugtrackingConnector[] bugtrackingConnectors;
    private JLabel label;
    private JComboBox combo;
    private final JComponent cardsPanel = new JPanel(new CardLayout());
    private boolean emptyPanelInitialized;
    private RepositoryFormPanel repositoryFormsPanel;
    private ChangeListener repositoryFormPanelListener;
    private boolean isValidData;
    private boolean repositoryFormVisible;
    private List<ChangeListener> changeListeners;
    private ChangeEvent changeEvent;
    private List<ResizeListener> resizeListeners;
    private List<ItemListener> selectionListeners;
    private String labelText = null;
    private boolean labelAbove = false;
    private boolean labelVisible = true;
    private boolean comboVisible = true;
    private boolean displayFormForExistingRepo = true;
    private String bugtrackingConnectorDisplayFormat;
    private String initialErrorMessage;
    private Repository repoToPreselect;

    public void setLabelVisible(boolean bl) {
        if (!bl && this.label != null) {
            throw new IllegalStateException("Cannot change visibility of an already created label.");
        }
        this.labelVisible = bl;
    }

    public void setLabelText(String string) {
        if (this.label == null) {
            this.labelText = string;
        } else {
            Mnemonics.setLocalizedText((JLabel)this.label, (String)string);
        }
    }

    public void setComboBoxVisible(boolean bl) {
        if (!bl && this.combo != null) {
            throw new IllegalStateException("Cannot change parameters of an already created combo-box.");
        }
        this.comboVisible = bl;
        if (!bl) {
            this.combo = null;
        }
    }

    public void setBugtrackingConnectorDisplayFormat(String string) {
        this.bugtrackingConnectorDisplayFormat = string;
    }

    public void setLabelAboveComboBox() {
        this.labelAbove = true;
    }

    public void setLabelNextToComboBox() {
        this.labelAbove = false;
    }

    public void setDisplayFormForExistingRepositories(boolean bl) {
        this.displayFormForExistingRepo = bl;
    }

    public void setExistingRepositories(Repository[] repositoryArray) {
        if (this.combo != null) {
            throw new IllegalStateException("Cannot change parameters of an already created combo-box.");
        }
        if (repositoryArray != null && repositoryArray.length == 0) {
            repositoryArray = null;
        }
        this.existingRepositories = repositoryArray;
    }

    public void setBugtrackingConnectors(BugtrackingConnector[] bugtrackingConnectorArray) {
        if (this.combo != null) {
            throw new IllegalStateException("Cannot change parameters of an already created combo-box.");
        }
        if (bugtrackingConnectorArray != null && bugtrackingConnectorArray.length == 0) {
            bugtrackingConnectorArray = null;
        }
        this.bugtrackingConnectors = bugtrackingConnectorArray;
    }

    public void setPreselectedRepository(Repository repository) {
        this.repoToPreselect = repository;
        if (this.combo != null) {
            this.combo.setSelectedItem(repository);
        }
    }

    public void setInitialErrorMessage(String string) {
        this.initialErrorMessage = string;
    }

    public JLabel getLabel() {
        if (this.labelVisible && this.label == null) {
            this.initializeLabel();
        }
        return this.label;
    }

    public JComboBox getComboBox() {
        if (this.comboVisible && this.combo == null) {
            this.initializeCombo();
        }
        return this.combo;
    }

    public JComponent getFormPanel() {
        if (!this.comboVisible && this.repositoryFormsPanel == null && this.repoToPreselect != null) {
            this.initializeCardsPanel();
        }
        return this.cardsPanel;
    }

    private void initializeLabel() {
        this.label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.label, (String)(this.labelText != null ? this.labelText : RepositorySelectorBuilder.getDefaultLabelText()));
        if (this.combo != null) {
            this.bindLabelToCombo();
        }
    }

    private void initializeCombo() {
        boolean bl;
        boolean bl2 = this.existingRepositories != null && this.existingRepositories.length != 0;
        boolean bl3 = bl = this.bugtrackingConnectors != null && this.bugtrackingConnectors.length != 0;
        if (!bl2 && !bl) {
            throw new IllegalStateException("No data for the combo-box.");
        }
        String string = this.bugtrackingConnectorDisplayFormat != null ? this.bugtrackingConnectorDisplayFormat : NbBundle.getMessage(ComboItemsRenderer.class, (String)"NewBugtrackingRepositoryConnection");
        this.combo = new JComboBox<Object>(RepositorySelectorBuilder.joinArrays(this.existingRepositories, RepositorySelectorBuilder.createRepositoryInfos(this.bugtrackingConnectors)));
        this.combo.setRenderer(new ComboItemsRenderer(this.combo.getRenderer(), string));
        if (this.repoToPreselect != null) {
            this.combo.setSelectedItem(this.repoToPreselect);
        }
        this.itemSelected(this.combo.getSelectedItem());
        this.combo.addItemListener(this);
        this.combo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositorySelectorBuilder.class, (String)"RepositorySelectorBuilder.combo.accessibleDescription"));
        if (this.label != null) {
            this.bindLabelToCombo();
        }
    }

    private void initializeCardsPanel() {
        if (!this.comboVisible && this.repositoryFormsPanel == null && this.repoToPreselect != null) {
            this.displayRepositoryForm(this.repoToPreselect, this.initialErrorMessage);
        }
    }

    private void bindLabelToCombo() {
        if (this.label != null && this.combo != null) {
            this.label.setLabelFor(this.combo);
        }
    }

    public JComponent createPanel() {
        JComponent jComponent;
        this.label = this.getLabel();
        this.combo = this.getComboBox();
        this.initializeCardsPanel();
        if (this.label == null && this.combo == null) {
            RepositorySelectorBuilder.addInsetsToPanel(this.cardsPanel);
            return this.cardsPanel;
        }
        if (this.label != null && this.combo != null && this.labelAbove) {
            jComponent = new JPanel();
            jComponent.setLayout(new BoxLayout(jComponent, 1));
            jComponent.add(this.label);
            jComponent.add(this.createVerticalStrut(jComponent, this.label, this.combo, 0));
            jComponent.add(this.combo);
            this.label.setAlignmentX(0.0f);
            this.combo.setAlignmentX(0.0f);
        } else if (this.label != null && this.combo != null) {
            jComponent = new JPanel();
            jComponent.setLayout(new BoxLayout(jComponent, 0));
            jComponent.add(this.label);
            jComponent.add(this.createHorizontalStrut(jComponent, this.label, this.combo, 0));
            jComponent.add(this.combo);
            this.combo.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else if (this.label != null) {
            jComponent = this.label;
        } else {
            assert (this.combo != null);
            jComponent = this.combo;
        }
        AutoResizingPanel autoResizingPanel = new AutoResizingPanel();
        autoResizingPanel.setLayout(new BorderLayout(0, this.getSpace(autoResizingPanel, jComponent, this.cardsPanel, 1, 1)));
        autoResizingPanel.add((Component)jComponent, "North");
        autoResizingPanel.add((Component)this.cardsPanel, "Center");
        autoResizingPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositorySelectorBuilder.class, (String)"RepositorySelector.accessibleDescription"));
        RepositorySelectorBuilder.addInsetsToPanel(autoResizingPanel);
        this.addResizeListener(autoResizingPanel);
        return autoResizingPanel;
    }

    public DialogDescriptor createDialogDescriptor(String string) {
        return new ValidatingDialogDescriptor(string);
    }

    private static NewRepositoryInfo[] createRepositoryInfos(BugtrackingConnector[] bugtrackingConnectorArray) {
        if (bugtrackingConnectorArray == null) {
            return null;
        }
        NewRepositoryInfo[] newRepositoryInfoArray = new NewRepositoryInfo[bugtrackingConnectorArray.length];
        for (int i = 0; i < bugtrackingConnectorArray.length; ++i) {
            newRepositoryInfoArray[i] = new NewRepositoryInfo(bugtrackingConnectorArray[i]);
        }
        return newRepositoryInfoArray;
    }

    public Repository getSelectedRepository() {
        Object object;
        if (this.combo != null && (object = this.combo.getSelectedItem()) instanceof Repository) {
            return (Repository)object;
        }
        return this.repositoryFormsPanel.getSelectedRepository();
    }

    public boolean isValidData() {
        return this.isValidData;
    }

    private static String getDefaultLabelText() {
        return RepositorySelectorBuilder.getText("LBL_SelectBugtrackingRepository");
    }

    private static void addInsetsToPanel(JComponent jComponent) {
        LayoutStyle layoutStyle = LayoutStyle.getSharedInstance();
        jComponent.setBorder(BorderFactory.createEmptyBorder(layoutStyle.getContainerGap(jComponent, 1, null), layoutStyle.getContainerGap(jComponent, 7, null), layoutStyle.getContainerGap(jComponent, 5, null), layoutStyle.getContainerGap(jComponent, 3, null)));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.itemSelected(itemEvent.getItem());
        }
    }

    private void itemSelected(Object object) {
        if (object instanceof NewRepositoryInfo) {
            NewRepositoryInfo newRepositoryInfo = (NewRepositoryInfo)object;
            this.displayRepositoryForm(newRepositoryInfo);
        } else {
            assert (object instanceof Repository);
            if (this.displayFormForExistingRepo) {
                Repository repository = (Repository)object;
                this.displayRepositoryForm(repository);
            } else {
                this.displayEmptyPanel();
            }
        }
        this.fireSelectionChanged();
    }

    private void setDataValid(boolean bl) {
        boolean bl2 = this.isValidData;
        this.isValidData = bl;
        if (this.isValidData != bl2) {
            this.fireDataValidityChanged();
        }
    }

    private void displayEmptyPanel() {
        if (!this.emptyPanelInitialized) {
            this.cardsPanel.add((Component)new JPanel(), EMPTY_PANEL);
            this.emptyPanelInitialized = true;
        }
        ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, EMPTY_PANEL);
        if (this.repositoryFormVisible) {
            this.repositoryFormsPanel.removeChangeListener(this.repositoryFormPanelListener);
            this.repositoryFormVisible = false;
        }
        this.setDataValid(true);
    }

    private void displayRepositoryForm(NewRepositoryInfo newRepositoryInfo) {
        if (newRepositoryInfo.repository == null) {
            newRepositoryInfo.initializeRepository();
        }
        this.displayRepositoryForm(newRepositoryInfo.repository);
    }

    public void displayRepository(Repository repository) {
        boolean bl;
        if (this.combo != null) {
            this.combo.setSelectedItem(repository);
            bl = this.combo.getSelectedItem() == repository;
        } else {
            bl = false;
        }
        if (!bl) {
            this.displayRepositoryForm(repository);
        }
    }

    public void displayRepositoryForm(Repository repository) {
        this.displayRepositoryForm(repository, null);
    }

    public void displayRepositoryForm(Repository repository, String string) {
        this.makeSureRepositoryFormsPanelExists();
        boolean bl = this.repositoryFormVisible;
        boolean bl2 = this.repositoryFormsPanel.displayForm(repository, string);
        ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, NEW_REPO_PANEL);
        if (!bl) {
            this.repositoryFormsPanel.addChangeListener(this.repositoryFormPanelListener);
            this.setDataValid(this.repositoryFormsPanel.isValidData());
            this.repositoryFormVisible = true;
        }
        if (bl2) {
            this.notifyResizeListeners();
        }
    }

    private void makeSureRepositoryFormsPanelExists() {
        if (this.repositoryFormsPanel != null) {
            return;
        }
        this.repositoryFormsPanel = new RepositoryFormPanel();
        if (this.initialErrorMessage != null) {
            this.repositoryFormsPanel.displayErrorMessage(this.initialErrorMessage);
        }
        if (this.repositoryFormPanelListener == null) {
            this.repositoryFormPanelListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    RepositorySelectorBuilder.this.setDataValid(RepositorySelectorBuilder.this.repositoryFormsPanel.isValidData());
                }
            };
        }
        this.cardsPanel.add((Component)this.repositoryFormsPanel, NEW_REPO_PANEL);
    }

    private void fireDataValidityChanged() {
        if (this.changeListeners != null && !this.changeListeners.isEmpty()) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(this.changeEvent);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(4);
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(changeListener);
    }

    public void addItemListener(ItemListener itemListener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ItemListener>(2);
        }
        this.selectionListeners.add(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        if (this.selectionListeners == null) {
            return;
        }
        this.selectionListeners.remove(itemListener);
    }

    public Object[] getSelectedObjects() {
        Repository[] repositoryArray;
        Repository repository = this.getSelectedRepository();
        if (repository != null) {
            Repository[] repositoryArray2 = new Repository[1];
            repositoryArray = repositoryArray2;
            repositoryArray2[0] = repository;
        } else {
            repositoryArray = null;
        }
        return repositoryArray;
    }

    private void fireSelectionChanged() {
        if (this.selectionListeners == null || this.selectionListeners.isEmpty()) {
            return;
        }
        ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedRepository(), 1);
        for (ItemListener itemListener : this.selectionListeners) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    public void addResizeListener(ResizeListener resizeListener) {
        if (this.resizeListeners == null) {
            this.resizeListeners = new ArrayList<ResizeListener>(4);
        }
        this.resizeListeners.add(resizeListener);
    }

    public void removeResizeListener(ResizeListener resizeListener) {
        if (this.resizeListeners == null) {
            return;
        }
        this.resizeListeners.remove(resizeListener);
    }

    private void notifyResizeListeners() {
        if (this.resizeListeners != null && !this.resizeListeners.isEmpty()) {
            for (ResizeListener resizeListener : this.resizeListeners) {
                resizeListener.resizeMayBeNeeded();
            }
        }
    }

    private static String getText(String string) {
        return NbBundle.getMessage(RepositorySelectorBuilder.class, (String)string);
    }

    private Component createHorizontalStrut(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, int n) {
        return Box.createHorizontalStrut(this.getSpace(jComponent, jComponent2, jComponent3, n, 0));
    }

    private Component createVerticalStrut(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, int n) {
        return Box.createVerticalStrut(this.getSpace(jComponent, jComponent2, jComponent3, n, 1));
    }

    private int getSpace(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, int n, int n2) {
        return LayoutStyle.getSharedInstance().getPreferredGap(jComponent2, jComponent3, n, n2 == 0 ? 3 : 5, (Container)jComponent);
    }

    private static Object[] joinArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray.length == 0) {
            return objectArray2;
        }
        if (objectArray2 == null || objectArray2.length == 0) {
            return objectArray;
        }
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    private static final class ComboItemsRenderer
    implements ListCellRenderer {
        private final MessageFormat newConnectionFormat;
        private final ListCellRenderer defaultRenderer;

        private ComboItemsRenderer(ListCellRenderer listCellRenderer, String string) {
            this.defaultRenderer = listCellRenderer;
            this.newConnectionFormat = new MessageFormat(string);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            if (object == null) {
                string = null;
            } else if (object instanceof Repository) {
                string = ((Repository)object).getDisplayName();
            } else if (object instanceof NewRepositoryInfo) {
                String string2 = ((NewRepositoryInfo)object).connector.getDisplayName();
                string = this.newConnectionFormat.format(new Object[]{string2});
            } else {
                assert (false);
                string = "???";
            }
            return this.defaultRenderer.getListCellRendererComponent(jList, string, n, bl, bl2);
        }
    }

    private static final class NewRepositoryInfo {
        private final BugtrackingConnector connector;
        private Repository repository;

        private NewRepositoryInfo(BugtrackingConnector bugtrackingConnector) {
            this.connector = bugtrackingConnector;
        }

        Repository initializeRepository() {
            assert (this.repository == null);
            this.repository = this.connector.createRepository();
            return this.repository;
        }
    }

    public static interface ResizeListener {
        public void resizeMayBeNeeded();
    }

    private final class AutoResizingPanel
    extends JPanel
    implements ResizeListener {
        private Dimension requestedSize;

        AutoResizingPanel() {
        }

        AutoResizingPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public void resizeMayBeNeeded() {
            this.expandWindowToFitNewConnectorForm();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expandWindowToFitNewConnectorForm() {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window == null) {
                return;
            }
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.getPreferredSize();
            if (dimension.width >= dimension2.width && dimension.height >= dimension2.height) {
                return;
            }
            try {
                this.requestedSize = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
                window.pack();
            }
            finally {
                this.requestedSize = null;
            }
        }

        public Dimension getPreferredSize() {
            return this.requestedSize != null ? this.requestedSize : super.getPreferredSize();
        }
    }

    private final class ValidatingDialogDescriptor
    extends DialogDescriptor
    implements ChangeListener,
    ItemListener {
        ValidatingDialogDescriptor(String string) {
            super((Object)RepositorySelectorBuilder.this.createPanel(), string);
            RepositorySelectorBuilder.this.addChangeListener(this);
            this.updateStatus();
            RepositorySelectorBuilder.this.addItemListener(this);
            this.updateHelpId();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateStatus();
        }

        private void updateStatus() {
            this.setValid(RepositorySelectorBuilder.this.isValidData());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateHelpId();
        }

        private void updateHelpId() {
            this.setHelpCtx(this.getHelpFor(RepositorySelectorBuilder.this.getSelectedRepository()));
        }

        private HelpCtx getHelpFor(Repository repository) {
            return repository != null ? repository.getController().getHelpCtx() : null;
        }
    }
}

