/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class QueryAction
extends SystemAction {
    public QueryAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(QueryAction.class, (String)"CTL_QueryAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(QueryAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        QueryAction.openQuery(null, WindowManager.getDefault().getRegistry().getActivatedNodes());
    }

    private static void openQuery(Query query, Node[] nodeArray) {
        QueryAction.openQuery(query, null, nodeArray);
    }

    public static void openQuery(Query query, Repository repository) {
        QueryAction.openQuery(query, repository, null);
    }

    private static void openQuery(Query query, Repository repository, Node[] nodeArray) {
        QueryAction.openQuery(query, repository, false);
    }

    public static void openQuery(Query query, Repository repository, boolean bl) {
        QueryAction.openQuery(query, repository, WindowManager.getDefault().getRegistry().getActivatedNodes(), bl);
    }

    private static void openQuery(final Query query, final Repository repository, final Node[] nodeArray, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BugtrackingManager.LOG.log(Level.FINE, "QueryAction.openQuery start. query [{0}]", new Object[]{query != null ? query.getDisplayName() : null});
                QueryTopComponent queryTopComponent = null;
                if (query != null) {
                    queryTopComponent = QueryTopComponent.find(query);
                }
                if (queryTopComponent == null) {
                    queryTopComponent = new QueryTopComponent();
                    queryTopComponent.init(query, repository, nodeArray, bl);
                }
                if (!queryTopComponent.isOpened()) {
                    queryTopComponent.open();
                }
                queryTopComponent.requestActive();
                BugtrackingManager.LOG.log(Level.FINE, "QueryAction.openQuery finnish. query [{0}]", new Object[]{query != null ? query.getDisplayName() : null});
            }
        });
    }

    public static void closeQuery(final Query query) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopComponent topComponent = null;
                if (query != null) {
                    topComponent = WindowManager.getDefault().findTopComponent(query.getDisplayName());
                }
                if (topComponent != null) {
                    topComponent.close();
                }
            }
        });
    }
}

