/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.RepositoriesSupport;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.nodes.BugtrackingRootNode;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class RepositoryNode
extends AbstractNode {
    private Repository repository;

    public RepositoryNode(Repository repository) {
        super(Children.LEAF);
        this.repository = repository;
        this.setName(repository.getDisplayName());
    }

    public Image getIcon(int n) {
        return this.repository.getIcon();
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{new AbstractAction(((QueryAction)SystemAction.get(QueryAction.class)).getName()){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryAction.openQuery(null, RepositoryNode.this.repository);
            }
        }, new AbstractAction(((IssueAction)SystemAction.get(IssueAction.class)).getName()){

            public void actionPerformed(ActionEvent actionEvent) {
                IssueAction.openIssue(RepositoryNode.this.repository);
            }
        }, new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_EditRepository")){

            public void actionPerformed(ActionEvent actionEvent) {
                BugtrackingUtil.editRepository(RepositoryNode.this.repository);
            }
        }, new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_RemoveRepository")){

            public void actionPerformed(ActionEvent actionEvent) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RepositoryNode.class, (String)"MSG_RemoveRepository", (Object[])new Object[]{RepositoryNode.this.repository.getDisplayName()}), NbBundle.getMessage(RepositoryNode.class, (String)"CTL_RemoveRepository"), 2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION) {
                    BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                        public void run() {
                            RepositoryNode.this.repository.remove();
                            RepositoriesSupport.getInstance().fireRepositoriesChanged();
                        }
                    });
                }
            }
        }};
    }
}

