/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.QueryAccessorImpl;
import org.netbeans.modules.bugtracking.spi.QueryNotifyListener;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query
implements Comparable<Query> {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String EVENT_QUERY_ISSUES_CHANGED = "bugtracking.query.issues_changed";
    public static final String EVENT_QUERY_SAVED = "bugtracking.query.saved";
    public static final String EVENT_QUERY_REMOVED = "bugtracking.query.removed";
    private List<QueryNotifyListener> notifyListeners;
    protected boolean saved;
    private long lastRefresh = -1L;
    private Node[] selection;

    public abstract String getDisplayName();

    public abstract String getTooltip();

    public abstract BugtrackingController getController();

    public abstract Repository getRepository();

    public static void openNew(Repository repository) {
        QueryAction.openQuery(null, repository);
    }

    public abstract boolean refresh();

    protected void setSaved(boolean bl) {
        this.saved = bl;
        if (bl) {
            this.selection = null;
        }
        this.fireQuerySaved();
    }

    public boolean isSaved() {
        return this.saved;
    }

    public abstract Issue[] getIssues(int var1);

    public Issue[] getIssues() {
        return this.getIssues(-1);
    }

    public abstract boolean contains(Issue var1);

    public Issue[] getIssues(String string) {
        return BugtrackingUtil.getByIdOrSummary(this.getIssues(), string);
    }

    @Override
    public int compareTo(Query query) {
        if (query == null) {
            return 1;
        }
        return this.getDisplayName().compareTo(query.getDisplayName());
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public abstract int getIssueStatus(Issue var1);

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    protected void fireQuerySaved() {
        this.support.firePropertyChange(EVENT_QUERY_SAVED, null, null);
    }

    protected void fireQueryRemoved() {
        this.support.firePropertyChange(EVENT_QUERY_REMOVED, null, null);
    }

    protected void fireQueryIssuesChanged() {
        this.support.firePropertyChange(EVENT_QUERY_ISSUES_CHANGED, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotifyListener(QueryNotifyListener queryNotifyListener) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.add(queryNotifyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotifyListener(QueryNotifyListener queryNotifyListener) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.remove(queryNotifyListener);
        }
    }

    protected void fireNotifyData(Issue issue) {
        QueryNotifyListener[] queryNotifyListenerArray;
        for (QueryNotifyListener queryNotifyListener : queryNotifyListenerArray = this.getListeners()) {
            queryNotifyListener.notifyData(issue);
        }
    }

    protected void fireStarted() {
        QueryNotifyListener[] queryNotifyListenerArray;
        for (QueryNotifyListener queryNotifyListener : queryNotifyListenerArray = this.getListeners()) {
            queryNotifyListener.started();
        }
    }

    protected void fireFinished() {
        QueryNotifyListener[] queryNotifyListenerArray;
        for (QueryNotifyListener queryNotifyListener : queryNotifyListenerArray = this.getListeners()) {
            queryNotifyListener.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery(Runnable runnable) {
        this.fireStarted();
        try {
            runnable.run();
        }
        finally {
            this.fireFinished();
            this.fireQueryIssuesChanged();
            this.setLastRefresh(System.currentTimeMillis());
        }
    }

    protected void setLastRefresh(long l) {
        this.lastRefresh = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryNotifyListener[] getListeners() {
        QueryNotifyListener[] queryNotifyListenerArray;
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            queryNotifyListenerArray = list.toArray(new QueryNotifyListener[list.size()]);
        }
        return queryNotifyListenerArray;
    }

    private List<QueryNotifyListener> getNotifyListeners() {
        if (this.notifyListeners == null) {
            this.notifyListeners = new ArrayList<QueryNotifyListener>();
        }
        return this.notifyListeners;
    }

    void setSelection(Node[] nodeArray) {
        this.selection = nodeArray;
    }

    protected Node[] getSelection() {
        return this.selection;
    }

    static {
        QueryAccessorImpl.create();
    }
}

