/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.jira.FakeJiraSupport;
import org.netbeans.modules.bugtracking.jira.JiraUpdater;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositoryUtils;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.spi.KenaiIssueAccessor;
import org.openide.util.NbBundle;

public class IssueAccessorImpl
extends KenaiIssueAccessor {
    public void open(final KenaiProject kenaiProject, final String string) {
        FakeJiraSupport fakeJiraSupport = FakeJiraSupport.get(kenaiProject);
        if (fakeJiraSupport != null && !JiraUpdater.isJiraInstalled()) {
            if (JiraUpdater.notifyJiraDownload(fakeJiraSupport.getIssueUrl(string))) {
                JiraUpdater.getInstance().downloadAndInstall();
            }
            return;
        }
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Issue.class, (String)"LBL_GETTING_REPO"));
        progressHandle.start();
        BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

            public void run() {
                Repository repository = KenaiRepositoryUtils.getInstance().getRepository(kenaiProject);
                progressHandle.finish();
                try {
                    Issue.open(repository, string);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    public KenaiIssueAccessor.IssueHandle[] getRecentIssues() {
        KenaiProject kenaiProject;
        Map<String, List<BugtrackingManager.RecentIssue>> map = BugtrackingManager.getInstance().getAllRecentIssues();
        Repository[] repositoryArray = BugtrackingManager.getInstance().getKnownRepositories();
        HashMap<String, Repository> hashMap = new HashMap<String, Repository>(repositoryArray.length);
        for (Repository object : repositoryArray) {
            hashMap.put(object.getID(), object);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<BugtrackingManager.RecentIssue> arrayList = new ArrayList<BugtrackingManager.RecentIssue>(5);
        for (Map.Entry<String, List<BugtrackingManager.RecentIssue>> entry : map.entrySet()) {
            Repository repository = (Repository)hashMap.get(entry.getKey());
            if (repository == null) {
                BugtrackingManager.LOG.fine("No repository available with ID " + entry.getKey());
                continue;
            }
            kenaiProject = (KenaiProject)repository.getLookup().lookup(KenaiProject.class);
            if (kenaiProject == null) continue;
            block2: for (BugtrackingManager.RecentIssue recentIssue : entry.getValue()) {
                if (arrayList.size() > 5) {
                    arrayList.remove(5);
                }
                if (arrayList.size() == 0) {
                    arrayList.add(recentIssue);
                    hashMap2.put(recentIssue.getIssue().getID(), kenaiProject);
                    continue;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (recentIssue.getTimestamp() > ((BugtrackingManager.RecentIssue)arrayList.get(i)).getTimestamp()) {
                        arrayList.add(i, recentIssue);
                        hashMap2.put(recentIssue.getIssue().getID(), kenaiProject);
                        continue block2;
                    }
                    if (arrayList.size() >= 5) continue;
                    arrayList.add(arrayList.size(), recentIssue);
                    hashMap2.put(recentIssue.getIssue().getID(), kenaiProject);
                    continue block2;
                }
            }
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (BugtrackingManager.RecentIssue recentIssue : arrayList) {
            kenaiProject = (KenaiProject)hashMap2.get(recentIssue.getIssue().getID());
            assert (kenaiProject != null);
            arrayList2.add(new IssueHandleImpl(recentIssue.getIssue(), kenaiProject));
        }
        return arrayList2.toArray(new KenaiIssueAccessor.IssueHandle[arrayList2.size()]);
    }

    public KenaiIssueAccessor.IssueHandle[] getRecentIssues(KenaiProject kenaiProject) {
        assert (kenaiProject != null);
        if (kenaiProject == null) {
            return new KenaiIssueAccessor.IssueHandle[0];
        }
        Repository repository = KenaiRepositoryUtils.getInstance().getRepository(kenaiProject, false);
        if (repository == null) {
            BugtrackingManager.LOG.fine("No issue tracker available for the given kenai project [" + kenaiProject.getName() + "," + kenaiProject.getDisplayName() + "]");
            return new KenaiIssueAccessor.IssueHandle[0];
        }
        List<Issue> list = BugtrackingManager.getInstance().getRecentIssues(repository);
        if (list == null) {
            return new KenaiIssueAccessor.IssueHandle[0];
        }
        ArrayList<IssueHandleImpl> arrayList = new ArrayList<IssueHandleImpl>(list.size());
        for (Issue issue : list) {
            IssueHandleImpl issueHandleImpl = new IssueHandleImpl(issue, kenaiProject);
            arrayList.add(issueHandleImpl);
        }
        return arrayList.toArray(new KenaiIssueAccessor.IssueHandle[arrayList.size()]);
    }

    private class IssueHandleImpl
    extends KenaiIssueAccessor.IssueHandle {
        private final Issue issue;
        private final KenaiProject project;

        public IssueHandleImpl(Issue issue, KenaiProject kenaiProject) {
            super((KenaiIssueAccessor)IssueAccessorImpl.this);
            this.issue = issue;
            this.project = kenaiProject;
        }

        public String getID() {
            return this.issue.getID();
        }

        public KenaiProject getProject() {
            return this.project;
        }

        public String getShortDisplayName() {
            return this.issue.getShortenedDisplayName();
        }

        public String getDisplayName() {
            return this.issue.getDisplayName();
        }

        public boolean isOpened() {
            IssueTopComponent issueTopComponent = IssueTopComponent.find(this.issue, false);
            return issueTopComponent != null ? issueTopComponent.isOpened() : false;
        }

        public boolean isShowing() {
            IssueTopComponent issueTopComponent = IssueTopComponent.find(this.issue, false);
            return issueTopComponent != null ? issueTopComponent.isShowing() : false;
        }
    }
}

