/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.jira;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.jira.DownloadPlugin;
import org.netbeans.modules.bugtracking.jira.FakeJiraSupport;
import org.netbeans.modules.bugtracking.jira.MissingJiraSupportPanel;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JiraUpdater {
    private static JiraUpdater instance;
    private JiraProxyConector connector;

    private JiraUpdater() {
    }

    public static synchronized JiraUpdater getInstance() {
        if (instance == null) {
            instance = new JiraUpdater();
        }
        return instance;
    }

    public static boolean isJiraInstalled() {
        BugtrackingConnector[] bugtrackingConnectorArray;
        for (BugtrackingConnector bugtrackingConnector : bugtrackingConnectorArray = BugtrackingManager.getInstance().getConnectors()) {
            if (!bugtrackingConnector.getClass().getName().startsWith("org.netbeans.modules.jira")) continue;
            return true;
        }
        return false;
    }

    public BugtrackingConnector getConnector() {
        if (this.connector == null) {
            this.connector = new JiraProxyConector();
        }
        return this.connector;
    }

    public void downloadAndInstall() {
        DownloadPlugin downloadPlugin = new DownloadPlugin();
        downloadPlugin.startDownload();
    }

    public static boolean notifyJiraDownload(String string) {
        final JButton jButton = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Download"));
        JButton jButton2 = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Cancel"));
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        JPanel jPanel = JiraUpdater.createNotificationPanel(uRL);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(FakeJiraSupport.class, (String)"CTL_MissingJiraPlugin"), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx(JiraUpdater.class), null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jButton.requestFocusInWindow();
            }
        });
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == jButton;
    }

    private static JPanel createNotificationPanel(final URL uRL) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("<html>" + NbBundle.getMessage(JiraUpdater.class, (String)"MSG_PROJECT_NEEDS_JIRA"));
        LinkButton linkButton = new LinkButton();
        Mnemonics.setLocalizedText((AbstractButton)linkButton, (String)NbBundle.getMessage(JiraUpdater.class, (String)"MSG_PROJECT_NEEDS_JIRA_LINK"));
        if (uRL != null) {
            linkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
                    if (uRLDisplayer != null) {
                        uRLDisplayer.showURL(uRL);
                    } else {
                        BugtrackingManager.LOG.warning("No URLDisplayer found.");
                    }
                }
            });
        } else {
            linkButton.setVisible(false);
        }
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel, -2, 470, Short.MAX_VALUE).add((Component)linkButton)).addContainerGap());
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jLabel).addPreferredGap(0).add((Component)linkButton).addContainerGap(25, Short.MAX_VALUE));
        return jPanel;
    }

    private class JiraProxyController
    extends BugtrackingController {
        private JPanel panel;

        private JiraProxyController() {
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = this.createControllerPanel();
            }
            return this.panel;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.getClass());
        }

        public boolean isValid() {
            return false;
        }

        public void applyChanges() throws IOException {
        }

        private JPanel createControllerPanel() {
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel();
            jLabel.setText(NbBundle.getMessage(FakeJiraSupport.class, (String)"MSG_NOT_YET_INSTALLED"));
            JButton jButton = new JButton();
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JiraUpdater.this.downloadAndInstall();
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MissingJiraSupportPanel.downloadButton.text"));
            GroupLayout groupLayout = new GroupLayout((Container)jPanel);
            jPanel.setLayout((LayoutManager)groupLayout);
            groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel, -2, 100, Short.MAX_VALUE)).addPreferredGap(0).add((Component)jButton)));
            groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jButton)).addContainerGap()));
            return jPanel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JiraProxyRepository
    extends Repository {
        private JiraProxyRepository() {
        }

        @Override
        public Image getIcon() {
            return null;
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getTooltip() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getID() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Issue getIssue(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void remove() {
        }

        @Override
        public BugtrackingController getController() {
            return new JiraProxyController();
        }

        @Override
        public Query createQuery() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Issue createIssue() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Query[] getQueries() {
            return new Query[0];
        }

        @Override
        public Collection<RepositoryUser> getUsers() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Issue[] simpleSearch(String string) {
            return new Issue[0];
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    }

    private class JiraProxyConector
    extends BugtrackingConnector {
        private JiraProxyConector() {
        }

        public String getDisplayName() {
            return NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_FakeJiraName");
        }

        public String getTooltip() {
            return NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_FakeJiraNameTooltip");
        }

        public Repository createRepository() {
            return new JiraProxyRepository();
        }

        public Repository[] getRepositories() {
            return new Repository[0];
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    }
}

